/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;

public abstract class Binding
extends BindingDeclaration {
    private final Supplier<ImmutableSet<DependencyRequest>> dependencies = Suppliers.memoize(() -> {
        ImmutableSet<DependencyRequest> implicitDependencies = this.implicitDependencies();
        return ImmutableSet.copyOf(implicitDependencies.isEmpty() ? this.explicitDependencies() : Sets.union(implicitDependencies, this.explicitDependencies()));
    });

    public boolean requiresModuleInstance() {
        if (!this.bindingElement().isPresent() || !this.contributingModule().isPresent()) {
            return false;
        }
        Set<Modifier> modifiers = this.bindingElement().get().getModifiers();
        return !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC);
    }

    public abstract boolean isNullable();

    public abstract BindingKind kind();

    public abstract BindingType bindingType();

    public final FrameworkType frameworkType() {
        return FrameworkType.forBindingType(this.bindingType());
    }

    public abstract ImmutableSet<DependencyRequest> explicitDependencies();

    public ImmutableSet<DependencyRequest> implicitDependencies() {
        return ImmutableSet.of();
    }

    public final ImmutableSet<DependencyRequest> dependencies() {
        return (ImmutableSet)this.dependencies.get();
    }

    public abstract Optional<? extends Binding> unresolved();

    public Optional<Scope> scope() {
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    static boolean hasNonDefaultTypeParameters(TypeElement element, TypeMirror type2, DaggerTypes types) {
        void var5_7;
        if (element.getTypeParameters().isEmpty()) {
            return false;
        }
        ArrayList defaultTypes = Lists.newArrayList();
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            defaultTypes.add(typeParameterElement.asType());
        }
        List<TypeMirror> actualTypes = type2.accept(new SimpleTypeVisitor6<List<TypeMirror>, Void>(){

            @Override
            protected List<TypeMirror> defaultAction(TypeMirror e, Void p) {
                return ImmutableList.of();
            }

            @Override
            public List<TypeMirror> visitDeclared(DeclaredType t, Void p) {
                return ImmutableList.copyOf(t.getTypeArguments());
            }
        }, null);
        if (defaultTypes.size() != actualTypes.size()) {
            return true;
        }
        boolean bl = false;
        while (var5_7 < defaultTypes.size()) {
            if (!types.isSameType((TypeMirror)defaultTypes.get((int)var5_7), actualTypes.get((int)var5_7))) {
                return true;
            }
            ++var5_7;
        }
        return false;
    }
}

