/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeSpecs;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.producers.CancellationPolicy;
import dagger.producers.internal.CancellationListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@PerComponentImplementation
public final class ComponentImplementation {
    public static final ParameterSpec MAY_INTERRUPT_IF_RUNNING_PARAM = ParameterSpec.builder(Boolean.TYPE, (String)"mayInterruptIfRunning", (Modifier[])new Modifier[0]).build();
    private static final String CANCELLATION_LISTENER_METHOD_NAME = "onProducerFutureCancelled";
    private static final int STATEMENTS_PER_METHOD = 100;
    private ShardImplementation currentShard;
    private final ShardImplementation componentShard;
    private final Map<Key, ShardImplementation> shardsByKey = new HashMap<Key, ShardImplementation>();
    private final Map<ShardImplementation, FieldSpec> shardFieldsByImplementation = new HashMap<ShardImplementation, FieldSpec>();
    private final Optional<ComponentImplementation> parent;
    private final BindingGraph graph;
    private final ComponentNames componentNames;
    private final CompilerOptions compilerOptions;
    private final DaggerElements elements;
    private final ImmutableMap<ComponentImplementation, FieldSpec> componentFieldsByImplementation;

    @Inject
    ComponentImplementation(@ParentComponent Optional<ComponentImplementation> parent, BindingGraph graph, ComponentNames componentNames, CompilerOptions compilerOptions, DaggerElements elements) {
        this.parent = parent;
        this.graph = graph;
        this.componentNames = componentNames;
        this.compilerOptions = compilerOptions;
        this.elements = elements;
        this.componentShard = new ShardImplementation(ComponentImplementation.getComponentName(graph, parent, componentNames));
        this.componentFieldsByImplementation = ComponentImplementation.createComponentFieldsByImplementation(this, compilerOptions);
    }

    public ShardImplementation shardImplementation(Key key) {
        if (!this.shardsByKey.containsKey(key)) {
            int keysPerShard = this.compilerOptions.keysPerComponentShard(this.graph.componentTypeElement());
            if (this.shardsByKey.isEmpty()) {
                this.currentShard = this.componentShard;
            } else if (this.shardsByKey.size() % keysPerShard == 0) {
                ClassName shardName = this.name().nestedClass("Shard" + this.shardsByKey.size() / keysPerShard);
                this.currentShard = this.createShard(shardName);
            }
            this.shardsByKey.put(key, this.currentShard);
        }
        return this.shardsByKey.get(key);
    }

    private ShardImplementation createShard(ClassName shardName) {
        ShardImplementation shard = new ShardImplementation(shardName);
        String shardFieldName = this.componentShard.getUniqueFieldName(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, shardName.simpleName()));
        FieldSpec shardField = FieldSpec.builder((TypeName)shardName, (String)shardFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{shardName}).build();
        this.componentShard.addField(FieldSpecKind.COMPONENT_SHARD, shardField);
        this.componentShard.addTypeSupplier((Supplier<TypeSpec>)((Supplier)shard::generate));
        this.shardFieldsByImplementation.put(shard, shardField);
        return shard;
    }

    ComponentImplementation rootComponentImplementation() {
        return this.parent.map(ComponentImplementation::rootComponentImplementation).orElse(this);
    }

    public CodeBlock componentFieldReference() {
        return CodeBlock.of((String)"$N", (Object[])new Object[]{this.componentFieldsByImplementation.get((Object)this)});
    }

    public ImmutableList<FieldSpec> componentFields() {
        return ImmutableList.copyOf((Collection)this.componentFieldsByImplementation.values());
    }

    public ImmutableList<FieldSpec> creatorComponentFields() {
        return (ImmutableList)this.componentFieldsByImplementation.entrySet().stream().filter(entry -> !this.equals(entry.getKey())).map(Map.Entry::getValue).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableMap<ComponentImplementation, FieldSpec> componentFieldsByImplementation() {
        return this.componentFieldsByImplementation;
    }

    private static ImmutableMap<ComponentImplementation, FieldSpec> createComponentFieldsByImplementation(ComponentImplementation componentImplementation, CompilerOptions compilerOptions) {
        Preconditions.checkArgument((componentImplementation.componentShard != null ? 1 : 0) != 0, (Object)"The component shard must be set before computing the component fields.");
        ImmutableList.Builder builder = ImmutableList.builder();
        ComponentImplementation curr = componentImplementation;
        while (curr != null) {
            builder.add((Object)curr);
            curr = curr.parent.orElse(null);
        }
        return (ImmutableMap)builder.build().reverse().stream().collect(DaggerStreams.toImmutableMap(componentImpl -> componentImpl, componentImpl -> {
            TypeElement component = componentImpl.graph.componentPath().currentComponent();
            ClassName fieldType = componentImpl.name();
            String fieldName = componentImpl.isNested() ? SourceFiles.simpleVariableName(componentImpl.name()) : SourceFiles.simpleVariableName(component);
            FieldSpec.Builder field = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            componentImplementation.componentShard.componentFieldNames.claim(fieldName);
            return field.build();
        }));
    }

    ShardImplementation getComponentShard() {
        return this.componentShard;
    }

    public BindingGraph graph() {
        return this.componentShard.graph();
    }

    public ComponentDescriptor componentDescriptor() {
        return this.componentShard.componentDescriptor();
    }

    public ClassName name() {
        return this.componentShard.name();
    }

    public boolean isNested() {
        return this.name().enclosingClassName() != null;
    }

    private ComponentCreatorKind creatorKind() {
        Preconditions.checkState((boolean)this.componentDescriptor().hasCreator());
        return this.componentDescriptor().creatorDescriptor().map(ComponentCreatorDescriptor::kind).orElse(ComponentCreatorKind.BUILDER);
    }

    public ClassName getCreatorName() {
        return this.isNested() ? this.name().peerClass(this.componentNames.getCreatorName(this.componentDescriptor())) : this.name().nestedClass(this.creatorKind().typeName());
    }

    private static ClassName getComponentName(BindingGraph graph, Optional<ComponentImplementation> parent, ComponentNames componentNames) {
        if (!parent.isPresent()) {
            return ComponentNames.getRootComponentClassName(graph.componentDescriptor());
        }
        ComponentDescriptor parentDescriptor = parent.get().graph.componentDescriptor();
        ComponentDescriptor childDescriptor = graph.componentDescriptor();
        Preconditions.checkArgument((boolean)parentDescriptor.childComponents().contains((Object)childDescriptor), (String)"%s is not a child component of %s", (Object)childDescriptor.typeElement(), (Object)parentDescriptor.typeElement());
        String suffix = parent.get().name().simpleNames().size() > 2 ? "I" : "Impl";
        return parent.get().name().nestedClass(componentNames.get(childDescriptor) + suffix);
    }

    String getSubcomponentCreatorSimpleName(Key key) {
        return this.componentShard.getSubcomponentCreatorSimpleName(key);
    }

    boolean isTypeAccessible(TypeMirror type) {
        return this.componentShard.isTypeAccessible(type);
    }

    public void addField(FieldSpecKind fieldKind, FieldSpec fieldSpec) {
        this.componentShard.addField(fieldKind, fieldSpec);
    }

    public void addMethod(MethodSpecKind methodKind, MethodSpec methodSpec) {
        this.componentShard.addMethod(methodKind, methodSpec);
    }

    public void addType(TypeSpecKind typeKind, TypeSpec typeSpec) {
        this.componentShard.addType(typeKind, typeSpec);
    }

    void addTypeSupplier(Supplier<TypeSpec> typeSpecSupplier) {
        this.componentShard.addTypeSupplier(typeSpecSupplier);
    }

    void addInitialization(CodeBlock codeBlock) {
        this.componentShard.addInitialization(codeBlock);
    }

    void addComponentRequirementInitialization(CodeBlock codeBlock) {
        this.componentShard.addComponentRequirementInitialization(codeBlock);
    }

    void addCancellation(Key key, CodeBlock codeBlock) {
        this.componentShard.addCancellation(key, codeBlock);
    }

    String getUniqueFieldName(String name) {
        return this.componentShard.getUniqueFieldName(name);
    }

    public String getUniqueMethodName(String name) {
        return this.componentShard.getUniqueMethodName(name);
    }

    String getUniqueMethodName(BindingRequest request) {
        return this.componentShard.getUniqueMethodName(request);
    }

    public String getParameterName(ComponentRequirement requirement, String baseName) {
        return this.componentShard.getParameterName(requirement, baseName);
    }

    public void claimMethodName(CharSequence name) {
        this.componentShard.claimMethodName(name);
    }

    public TypeSpec generate() {
        return this.componentShard.generate();
    }

    private static ImmutableList<ParameterSpec> makeFinal(List<ParameterSpec> parameters) {
        return (ImmutableList)parameters.stream().map(param -> param.toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build()).collect(DaggerStreams.toImmutableList());
    }

    public final class ShardImplementation {
        private final ClassName name;
        private final UniqueNameSet componentFieldNames = new UniqueNameSet();
        private final UniqueNameSet componentMethodNames = new UniqueNameSet();
        private final List<CodeBlock> initializations = new ArrayList<CodeBlock>();
        private final Map<Key, CodeBlock> cancellations = new LinkedHashMap<Key, CodeBlock>();
        private final List<CodeBlock> componentRequirementInitializations = new ArrayList<CodeBlock>();
        private final Map<ComponentRequirement, String> componentRequirementParameterNames = new HashMap<ComponentRequirement, String>();
        private final ListMultimap<FieldSpecKind, FieldSpec> fieldSpecsMap = MultimapBuilder.enumKeys(FieldSpecKind.class).arrayListValues().build();
        private final ListMultimap<MethodSpecKind, MethodSpec> methodSpecsMap = MultimapBuilder.enumKeys(MethodSpecKind.class).arrayListValues().build();
        private final ListMultimap<TypeSpecKind, TypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(TypeSpecKind.class).arrayListValues().build();
        private final List<Supplier<TypeSpec>> typeSuppliers = new ArrayList<Supplier<TypeSpec>>();

        private ShardImplementation(ClassName name) {
            this.name = name;
            if (ComponentImplementation.this.graph.componentDescriptor().isProduction()) {
                this.claimMethodName(ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME);
            }
        }

        public ComponentImplementation getComponentImplementation() {
            return ComponentImplementation.this;
        }

        public boolean isComponentShard() {
            return this == ComponentImplementation.this.componentShard;
        }

        public CodeBlock fieldReference() {
            return this.isComponentShard() ? ComponentImplementation.this.componentFieldReference() : CodeBlock.of((String)"$L.$N", (Object[])new Object[]{ComponentImplementation.this.componentFieldReference(), ComponentImplementation.this.shardFieldsByImplementation.get(this)});
        }

        public BindingGraph graph() {
            return ComponentImplementation.this.graph;
        }

        public ComponentDescriptor componentDescriptor() {
            return ComponentImplementation.this.graph.componentDescriptor();
        }

        public ClassName name() {
            return this.name;
        }

        String getSubcomponentCreatorSimpleName(Key key) {
            return ComponentImplementation.this.componentNames.getCreatorName(key);
        }

        boolean isTypeAccessible(TypeMirror type) {
            return Accessibility.isTypeAccessibleFrom(type, this.name.packageName());
        }

        public void addField(FieldSpecKind fieldKind, FieldSpec fieldSpec) {
            this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
        }

        public void addMethod(MethodSpecKind methodKind, MethodSpec methodSpec) {
            this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
        }

        public void addType(TypeSpecKind typeKind, TypeSpec typeSpec) {
            this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
        }

        void addTypeSupplier(Supplier<TypeSpec> typeSpecSupplier) {
            this.typeSuppliers.add(typeSpecSupplier);
        }

        void addInitialization(CodeBlock codeBlock) {
            this.initializations.add(codeBlock);
        }

        void addComponentRequirementInitialization(CodeBlock codeBlock) {
            this.componentRequirementInitializations.add(codeBlock);
        }

        void addCancellation(Key key, CodeBlock codeBlock) {
            this.cancellations.putIfAbsent(key, codeBlock);
        }

        String getUniqueFieldName(String name) {
            return this.componentFieldNames.getUniqueName(name);
        }

        public String getUniqueMethodName(String name) {
            return this.componentMethodNames.getUniqueName(name);
        }

        String getUniqueMethodName(BindingRequest request) {
            return this.uniqueMethodName(request, KeyVariableNamer.name(request.key()));
        }

        private String uniqueMethodName(BindingRequest request, String bindingName) {
            String baseMethodName = bindingName + (request.isRequestKind(RequestKind.INSTANCE) ? "" : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, request.kindName()));
            return this.getUniqueMethodName(baseMethodName);
        }

        public String getParameterName(ComponentRequirement requirement, String baseName) {
            return this.componentRequirementParameterNames.computeIfAbsent(requirement, r -> this.getUniqueFieldName(baseName));
        }

        public void claimMethodName(CharSequence name) {
            this.componentMethodNames.claim(name);
        }

        public TypeSpec generate() {
            TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.name);
            if (this.isComponentShard()) {
                TypeSpecs.addSupertype(builder, ComponentImplementation.this.graph.componentTypeElement());
                this.addConstructorAndInitializationMethods();
                if (ComponentImplementation.this.graph.componentDescriptor().isProduction()) {
                    TypeSpecs.addSupertype(builder, ComponentImplementation.this.elements.getTypeElement(CancellationListener.class));
                    this.addCancellationListenerImplementation();
                }
            }
            this.modifiers().forEach(xva$0 -> builder.addModifiers(new Modifier[]{xva$0}));
            this.fieldSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addFields(arg_0));
            this.methodSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethods(arg_0));
            this.typeSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addTypes(arg_0));
            this.typeSuppliers.stream().map(Supplier::get).forEach(arg_0 -> ((TypeSpec.Builder)builder).addType(arg_0));
            return builder.build();
        }

        private ImmutableSet<Modifier> modifiers() {
            if (!this.isComponentShard()) {
                return ImmutableSet.of((Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.FINAL));
            }
            if (ComponentImplementation.this.isNested()) {
                return ImmutableSet.of((Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.STATIC), (Object)((Object)Modifier.FINAL));
            }
            return ComponentImplementation.this.graph.componentTypeElement().getModifiers().contains((Object)Modifier.PUBLIC) ? ImmutableSet.of((Object)((Object)Modifier.PUBLIC), (Object)((Object)Modifier.FINAL)) : ImmutableSet.of((Object)((Object)Modifier.FINAL));
        }

        private void addConstructorAndInitializationMethods() {
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
            ImmutableList<ParameterSpec> parameters = this.constructorParameters();
            ComponentImplementation.this.componentFieldsByImplementation().forEach((componentImplementation, field) -> {
                if (componentImplementation.equals(ComponentImplementation.this)) {
                    this.addField(FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, field.toBuilder().initializer("this", new Object[0]).build());
                } else {
                    this.addField(FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, (FieldSpec)field);
                    constructor.addStatement("this.$1N = $1N", new Object[]{field});
                    constructor.addParameter(field.type, field.name, new Modifier[0]);
                }
            });
            constructor.addParameters(parameters);
            constructor.addCode(CodeBlocks.concat(this.componentRequirementInitializations));
            CodeBlock args = CodeBlocks.parameterNames(parameters);
            ImmutableList<MethodSpec> initializationMethods = this.createPartitionedMethods("initialize", (Iterable<ParameterSpec>)ComponentImplementation.makeFinal(parameters), this.initializations, (Function<String, MethodSpec.Builder>)((Function)methodName -> MethodSpec.methodBuilder((String)methodName).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]))));
            for (MethodSpec initializationMethod : initializationMethods) {
                constructor.addStatement("$N($L)", new Object[]{initializationMethod, args});
                this.addMethod(MethodSpecKind.INITIALIZE_METHOD, initializationMethod);
            }
            this.addMethod(MethodSpecKind.CONSTRUCTOR, constructor.build());
        }

        private void addCancellationListenerImplementation() {
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(MAY_INTERRUPT_IF_RUNNING_PARAM);
            ImmutableList cancellationStatements = ImmutableList.copyOf(this.cancellations.values()).reverse();
            if (cancellationStatements.size() < 100) {
                methodBuilder.addCode(CodeBlocks.concat((Iterable<CodeBlock>)cancellationStatements)).build();
            } else {
                ImmutableList<MethodSpec> cancelProducersMethods = this.createPartitionedMethods("cancelProducers", (Iterable<ParameterSpec>)ImmutableList.of((Object)MAY_INTERRUPT_IF_RUNNING_PARAM), (List<CodeBlock>)cancellationStatements, (Function<String, MethodSpec.Builder>)((Function)methodName -> MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE})));
                for (MethodSpec cancelProducersMethod : cancelProducersMethods) {
                    methodBuilder.addStatement("$N($N)", new Object[]{cancelProducersMethod, MAY_INTERRUPT_IF_RUNNING_PARAM});
                    this.addMethod(MethodSpecKind.CANCELLATION_LISTENER_METHOD, cancelProducersMethod);
                }
            }
            this.cancelParentStatement().ifPresent(arg_0 -> ((MethodSpec.Builder)methodBuilder).addCode(arg_0));
            this.addMethod(MethodSpecKind.CANCELLATION_LISTENER_METHOD, methodBuilder.build());
        }

        private Optional<CodeBlock> cancelParentStatement() {
            if (!this.shouldPropagateCancellationToParent()) {
                return Optional.empty();
            }
            return Optional.of(CodeBlock.builder().addStatement("$L.$N($N)", new Object[]{((ComponentImplementation)ComponentImplementation.this.parent.get()).componentFieldReference(), ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME, MAY_INTERRUPT_IF_RUNNING_PARAM}).build());
        }

        private boolean shouldPropagateCancellationToParent() {
            return ComponentImplementation.this.parent.isPresent() && ((ComponentImplementation)ComponentImplementation.this.parent.get()).componentDescriptor().cancellationPolicy().map(policy -> policy.fromSubcomponents().equals((Object)CancellationPolicy.Propagation.PROPAGATE)).orElse(false) != false;
        }

        private ImmutableList<MethodSpec> createPartitionedMethods(String methodName, Iterable<ParameterSpec> parameters, List<CodeBlock> statements, Function<String, MethodSpec.Builder> methodBuilderCreator) {
            return (ImmutableList)Lists.partition(statements, (int)100).stream().map(partition -> ((MethodSpec.Builder)methodBuilderCreator.apply((Object)this.getUniqueMethodName(methodName))).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameters(parameters).addCode(CodeBlocks.concat(partition)).build()).collect(DaggerStreams.toImmutableList());
        }

        private ImmutableList<ParameterSpec> constructorParameters() {
            Object map = new LinkedHashMap();
            if (ComponentImplementation.this.graph.componentDescriptor().hasCreator()) {
                map = Maps.toMap(ComponentImplementation.this.graph.componentRequirements(), ComponentRequirement::toParameterSpec);
            } else if (ComponentImplementation.this.graph.factoryMethod().isPresent()) {
                map = Maps.transformValues(ComponentImplementation.this.graph.factoryMethodParameters(), ParameterSpec::get);
            } else {
                throw new AssertionError((Object)"Expected either a component creator or factory method but found neither.");
            }
            return ImmutableList.copyOf(Maps.transformEntries((Map)map, this::renameParameter).values());
        }

        private ParameterSpec renameParameter(ComponentRequirement requirement, ParameterSpec parameter) {
            return ParameterSpec.builder((TypeName)parameter.type, (String)this.getParameterName(requirement, parameter.name), (Modifier[])new Modifier[0]).addAnnotations((Iterable)parameter.annotations).addModifiers((Iterable)parameter.modifiers).build();
        }
    }

    public static enum TypeSpecKind {
        PRESENT_FACTORY,
        COMPONENT_CREATOR,
        COMPONENT_PROVISION_FACTORY,
        SUBCOMPONENT;

    }

    public static enum MethodSpecKind {
        CONSTRUCTOR,
        BUILDER_METHOD,
        PRIVATE_METHOD,
        INITIALIZE_METHOD,
        COMPONENT_METHOD,
        MEMBERS_INJECTION_METHOD,
        ABSENT_OPTIONAL_METHOD,
        CANCELLATION_LISTENER_METHOD;

    }

    public static enum FieldSpecKind {
        COMPONENT_SHARD,
        COMPONENT_REQUIREMENT_FIELD,
        PRIVATE_METHOD_SCOPED_FIELD,
        PRIVATE_METHOD_CACHED_PROVIDER_FIELD,
        FRAMEWORK_FIELD,
        ABSENT_OPTIONAL_FIELD;

    }
}

