/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.MapKey;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.MapKeyValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.writing.AnnotationCreatorGenerator;
import dagger.internal.codegen.writing.UnwrappedMapKeyGenerator;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

final class MapKeyProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final Messager messager;
    private final DaggerTypes types;
    private final MapKeyValidator mapKeyValidator;
    private final AnnotationCreatorGenerator annotationCreatorGenerator;
    private final UnwrappedMapKeyGenerator unwrappedMapKeyGenerator;

    @Inject
    MapKeyProcessingStep(Messager messager, DaggerTypes types, MapKeyValidator mapKeyValidator, AnnotationCreatorGenerator annotationCreatorGenerator, UnwrappedMapKeyGenerator unwrappedMapKeyGenerator) {
        super(MoreElements::asType);
        this.messager = messager;
        this.types = types;
        this.mapKeyValidator = mapKeyValidator;
        this.annotationCreatorGenerator = annotationCreatorGenerator;
        this.unwrappedMapKeyGenerator = unwrappedMapKeyGenerator;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(MapKey.class);
    }

    @Override
    protected void process(TypeElement mapKeyAnnotationType, ImmutableSet<Class<? extends Annotation>> annotations) {
        ValidationReport<Element> mapKeyReport = this.mapKeyValidator.validate(mapKeyAnnotationType);
        mapKeyReport.printMessagesTo(this.messager);
        if (mapKeyReport.isClean()) {
            MapKey mapkey = mapKeyAnnotationType.getAnnotation(MapKey.class);
            if (!mapkey.unwrapValue()) {
                this.annotationCreatorGenerator.generate(mapKeyAnnotationType, this.messager);
            } else if (this.unwrappedValueKind(mapKeyAnnotationType).equals((Object)ElementKind.ANNOTATION_TYPE)) {
                this.unwrappedMapKeyGenerator.generate(mapKeyAnnotationType, this.messager);
            }
        }
    }

    private ElementKind unwrappedValueKind(TypeElement mapKeyAnnotationType) {
        DeclaredType unwrappedMapKeyType = MapKeys.getUnwrappedMapKeyType(MoreTypes.asDeclared(mapKeyAnnotationType.asType()), this.types);
        return unwrappedMapKeyType.asElement().getKind();
    }
}

