/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingGraphFactory;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptorFactory;
import dagger.internal.codegen.validation.BindingGraphValidator;
import dagger.internal.codegen.validation.ComponentCreatorValidator;
import dagger.internal.codegen.validation.ComponentDescriptorValidator;
import dagger.internal.codegen.validation.ComponentValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ComponentProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final ComponentDescriptorValidator componentDescriptorValidator;
    private final ComponentDescriptorFactory componentDescriptorFactory;
    private final BindingGraphFactory bindingGraphFactory;
    private final SourceFileGenerator<BindingGraph> componentGenerator;
    private final BindingGraphValidator bindingGraphValidator;

    @Inject
    ComponentProcessingStep(Messager messager, ComponentValidator componentValidator, ComponentCreatorValidator creatorValidator, ComponentDescriptorValidator componentDescriptorValidator, ComponentDescriptorFactory componentDescriptorFactory, BindingGraphFactory bindingGraphFactory, SourceFileGenerator<BindingGraph> componentGenerator, BindingGraphValidator bindingGraphValidator) {
        super(MoreElements::asType);
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.creatorValidator = creatorValidator;
        this.componentDescriptorValidator = componentDescriptorValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.componentGenerator = componentGenerator;
        this.bindingGraphValidator = bindingGraphValidator;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return Sets.union(ComponentAnnotation.allComponentAnnotations(), ComponentCreatorAnnotation.allCreatorAnnotations());
    }

    @Override
    protected void process(TypeElement element, ImmutableSet<Class<? extends Annotation>> annotations) {
        if (!Collections.disjoint(annotations, ComponentAnnotation.rootComponentAnnotations())) {
            this.processRootComponent(element);
        }
        if (!Collections.disjoint(annotations, ComponentAnnotation.subcomponentAnnotations())) {
            this.processSubcomponent(element);
        }
        if (!Collections.disjoint(annotations, ComponentCreatorAnnotation.allCreatorAnnotations())) {
            this.processCreator(element);
        }
    }

    private void processRootComponent(TypeElement component) {
        if (!this.isComponentValid(component)) {
            return;
        }
        ComponentDescriptor componentDescriptor = this.componentDescriptorFactory.rootComponentDescriptor(component);
        if (!this.isValid(componentDescriptor)) {
            return;
        }
        if (!this.validateFullBindingGraph(componentDescriptor)) {
            return;
        }
        BindingGraph bindingGraph = this.bindingGraphFactory.create(componentDescriptor, false);
        if (this.bindingGraphValidator.isValid(bindingGraph.topLevelBindingGraph())) {
            this.generateComponent(bindingGraph);
        }
    }

    private void processSubcomponent(TypeElement subcomponent) {
        if (!this.isComponentValid(subcomponent)) {
            return;
        }
        ComponentDescriptor subcomponentDescriptor = this.componentDescriptorFactory.subcomponentDescriptor(subcomponent);
        this.validateFullBindingGraph(subcomponentDescriptor);
    }

    private void generateComponent(BindingGraph bindingGraph) {
        this.componentGenerator.generate(bindingGraph, this.messager);
    }

    private void processCreator(Element creator) {
        this.creatorValidator.validate(MoreElements.asType(creator)).printMessagesTo(this.messager);
    }

    private boolean isComponentValid(Element component) {
        ValidationReport<TypeElement> report = this.componentValidator.validate(MoreElements.asType(component));
        report.printMessagesTo(this.messager);
        return report.isClean();
    }

    @CanIgnoreReturnValue
    private boolean validateFullBindingGraph(ComponentDescriptor componentDescriptor) {
        TypeElement component = componentDescriptor.typeElement();
        if (!this.bindingGraphValidator.shouldDoFullBindingGraphValidation(component)) {
            return true;
        }
        BindingGraph fullBindingGraph = this.bindingGraphFactory.create(componentDescriptor, true);
        return this.bindingGraphValidator.isValid(fullBindingGraph.topLevelBindingGraph());
    }

    private boolean isValid(ComponentDescriptor componentDescriptor) {
        ValidationReport<TypeElement> componentDescriptorReport = this.componentDescriptorValidator.validate(componentDescriptor);
        componentDescriptorReport.printMessagesTo(this.messager);
        return componentDescriptorReport.isClean();
    }
}

