/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.writing.FactoryGenerator;
import dagger.internal.codegen.writing.HjarSourceFileGenerator;
import dagger.internal.codegen.writing.MembersInjectorGenerator;
import dagger.internal.codegen.writing.ModuleGenerator;
import dagger.internal.codegen.writing.ModuleProxies;
import dagger.internal.codegen.writing.ProducerFactoryGenerator;
import javax.lang.model.element.TypeElement;

@Module
abstract class SourceFileGeneratorsModule {
    SourceFileGeneratorsModule() {
    }

    @Provides
    static SourceFileGenerator<ProvisionBinding> provisionBindingGenerator(FactoryGenerator generator, CompilerOptions compilerOptions) {
        return SourceFileGeneratorsModule.hjarWrapper(generator, compilerOptions);
    }

    @Provides
    static SourceFileGenerator<ProductionBinding> productionBindingGenerator(ProducerFactoryGenerator generator, CompilerOptions compilerOptions) {
        return SourceFileGeneratorsModule.hjarWrapper(generator, compilerOptions);
    }

    @Provides
    static SourceFileGenerator<MembersInjectionBinding> membersInjectionBindingGenerator(MembersInjectorGenerator generator, CompilerOptions compilerOptions) {
        return SourceFileGeneratorsModule.hjarWrapper(generator, compilerOptions);
    }

    @Provides
    static SourceFileGenerator<BindingGraph> bindingGraphGenerator(ComponentGenerator generator, CompilerOptions compilerOptions) {
        return SourceFileGeneratorsModule.hjarWrapper(generator, compilerOptions);
    }

    @Provides
    @ModuleGenerator
    static SourceFileGenerator<TypeElement> moduleProxyGenerator(ModuleProxies.ModuleConstructorProxyGenerator generator, CompilerOptions compilerOptions) {
        return SourceFileGeneratorsModule.hjarWrapper(generator, compilerOptions);
    }

    private static <T> SourceFileGenerator<T> hjarWrapper(SourceFileGenerator<T> generator, CompilerOptions compilerOptions) {
        return compilerOptions.headerCompilation() ? HjarSourceFileGenerator.wrap(generator) : generator;
    }
}

