/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.squareup.javapoet.AnnotationSpec;
import dagger.internal.GenerationOptions;
import dagger.internal.codegen.AutoValue_CompilerOptions;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.FeatureStatus;
import dagger.internal.codegen.ValidationType;
import dagger.producers.Produces;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;

@AutoValue
abstract class CompilerOptions {
    CompilerOptions() {
    }

    abstract boolean usesProducers();

    abstract boolean fastInit();

    abstract boolean formatGeneratedSource();

    abstract boolean writeProducerNameInToken();

    abstract Diagnostic.Kind nullableValidationKind();

    boolean doCheckForNulls() {
        return this.nullableValidationKind().equals((Object)Diagnostic.Kind.ERROR);
    }

    abstract Diagnostic.Kind privateMemberValidationKind();

    abstract Diagnostic.Kind staticMemberValidationKind();

    abstract boolean ignorePrivateAndStaticInjectionForComponent();

    abstract ValidationType scopeCycleValidationType();

    abstract boolean warnIfInjectionFactoryNotGeneratedUpstream();

    abstract boolean headerCompilation();

    abstract boolean aheadOfTimeSubcomponents();

    abstract boolean useGradleIncrementalProcessing();

    abstract ValidationType moduleBindingValidationType();

    abstract Diagnostic.Kind moduleHasDifferentScopesDiagnosticKind();

    abstract ValidationType explicitBindingConflictsWithInjectValidationType();

    static Builder builder() {
        return new AutoValue_CompilerOptions.Builder().headerCompilation(false).useGradleIncrementalProcessing(false);
    }

    static CompilerOptions create(ProcessingEnvironment processingEnv) {
        AutoValue_CompilerOptions.Builder builder = new AutoValue_CompilerOptions.Builder();
        for (Option option : Iterables.concat(EnumSet.allOf(Feature.class), EnumSet.allOf(Validation.class))) {
            option.set(builder, processingEnv);
        }
        return builder.build();
    }

    abstract Builder toBuilder();

    CompilerOptions withGenerationOptions(GenerationOptions generationOptions) {
        return this.toBuilder().fastInit(generationOptions.fastInit()).build();
    }

    AnnotationSpec toGenerationOptionsAnnotation() {
        return AnnotationSpec.builder(GenerationOptions.class).addMember("fastInit", "$L", new Object[]{this.fastInit()}).build();
    }

    private static String optionName(String enumName) {
        return "dagger." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, enumName);
    }

    static ImmutableSet<String> supportedOptions() {
        return Stream.of(Feature.values(), Validation.values()).flatMap(Arrays::stream).filter(Option::useCommandLineOption).map(Object::toString).collect(DaggerStreams.toImmutableSet());
    }

    private static class OptionParser<T extends Enum<T>> {
        private final Option<T> option;

        OptionParser(Option<T> option) {
            this.option = (Option)Preconditions.checkNotNull(option);
        }

        T parse(ProcessingEnvironment processingEnvironment) {
            String key = this.option.toString();
            Map<String, String> options = processingEnvironment.getOptions();
            if (options.containsKey(key)) {
                String stringValue = options.get(key);
                if (stringValue == null) {
                    processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Processor option -A" + key + " needs a value");
                } else {
                    try {
                        T value = Enum.valueOf(this.valueClass(), Ascii.toUpperCase((String)stringValue));
                        if (this.option.validValues().contains(value)) {
                            return value;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Processor option -A%s may only have the values %s (case insensitive), found: %s", key, this.option.validValues(), stringValue));
                }
            }
            return this.option.defaultValue();
        }

        private Class<T> valueClass() {
            return ((Enum)this.option.defaultValue()).getDeclaringClass();
        }
    }

    private static enum Validation implements Option<ValidationType>
    {
        DISABLE_INTER_COMPONENT_SCOPE_VALIDATION(Builder::scopeCycleValidationType),
        NULLABLE_VALIDATION((BiConsumer)Validation.kindSetter(Builder::nullableValidationKind), ValidationType.ERROR, new ValidationType[]{ValidationType.WARNING}){}
        ,
        PRIVATE_MEMBER_VALIDATION(Validation.kindSetter(Builder::privateMemberValidationKind), ValidationType.ERROR, ValidationType.WARNING),
        STATIC_MEMBER_VALIDATION(Validation.kindSetter(Builder::staticMemberValidationKind), ValidationType.ERROR, ValidationType.WARNING),
        MODULE_BINDING_VALIDATION(Builder::moduleBindingValidationType, ValidationType.NONE, ValidationType.ERROR, ValidationType.WARNING),
        MODULE_HAS_DIFFERENT_SCOPES_VALIDATION(Validation.kindSetter(Builder::moduleHasDifferentScopesDiagnosticKind), ValidationType.ERROR, ValidationType.WARNING),
        EXPLICIT_BINDING_CONFLICTS_WITH_INJECT(Builder::explicitBindingConflictsWithInjectValidationType, ValidationType.WARNING, ValidationType.ERROR, ValidationType.NONE);

        final OptionParser<ValidationType> parser = new OptionParser<ValidationType>(this);
        final ValidationType defaultType;
        final ImmutableSet<ValidationType> validTypes;
        final BiConsumer<Builder, ValidationType> setter;

        static BiConsumer<Builder, ValidationType> kindSetter(BiConsumer<Builder, Diagnostic.Kind> setter) {
            return (builder, validationType) -> setter.accept((Builder)builder, validationType.diagnosticKind().get());
        }

        private Validation(BiConsumer<Builder, ValidationType> setter) {
            this(setter, ValidationType.ERROR, ValidationType.WARNING, ValidationType.NONE);
        }

        private Validation(BiConsumer<Builder, ValidationType> setter, ValidationType defaultType, ValidationType ... moreValidTypes) {
            this.setter = setter;
            this.defaultType = defaultType;
            this.validTypes = Sets.immutableEnumSet((Enum)defaultType, (Enum[])moreValidTypes);
        }

        @Override
        public ValidationType defaultValue() {
            return this.defaultType;
        }

        @Override
        public Set<ValidationType> validValues() {
            return this.validTypes;
        }

        @Override
        public void set(Builder builder, ProcessingEnvironment processingEnvironment) {
            this.setter.accept(builder, this.parser.parse(processingEnvironment));
        }

        public String toString() {
            return CompilerOptions.optionName(this.name());
        }
    }

    private static enum Feature implements Option<FeatureStatus>
    {
        HEADER_COMPILATION(Builder::headerCompilation){

            @Override
            boolean isEnabled(ProcessingEnvironment processingEnvironment) {
                return processingEnvironment.getOptions().containsKey(this.toString());
            }

            @Override
            public String toString() {
                return "experimental_turbine_hjar";
            }
        }
        ,
        FAST_INIT(Builder::fastInit),
        EXPERIMENTAL_ANDROID_MODE((builder, ignoredValue) -> {}){

            @Override
            public void set(Builder builder, ProcessingEnvironment processingEnvironment) {
                this.noLongerRecognizedWarning(processingEnvironment);
            }
        }
        ,
        FORMAT_GENERATED_SOURCE(Builder::formatGeneratedSource, FeatureStatus.ENABLED),
        WRITE_PRODUCER_NAME_IN_TOKEN(Builder::writeProducerNameInToken),
        WARN_IF_INJECTION_FACTORY_NOT_GENERATED_UPSTREAM(Builder::warnIfInjectionFactoryNotGeneratedUpstream),
        IGNORE_PRIVATE_AND_STATIC_INJECTION_FOR_COMPONENT(Builder::ignorePrivateAndStaticInjectionForComponent),
        EXPERIMENTAL_AHEAD_OF_TIME_SUBCOMPONENTS(Builder::aheadOfTimeSubcomponents),
        FLOATING_BINDS_METHODS((builder, ignoredValue) -> {}){

            @Override
            public void set(Builder builder, ProcessingEnvironment processingEnvironment) {
                this.noLongerRecognizedWarning(processingEnvironment);
            }
        }
        ,
        USE_GRADLE_INCREMENTAL_PROCESSING(Builder::useGradleIncrementalProcessing){

            @Override
            boolean isEnabled(ProcessingEnvironment processingEnvironment) {
                return processingEnvironment.getOptions().containsKey(this.toString());
            }

            @Override
            public String toString() {
                return "dagger.gradle.incremental";
            }
        }
        ,
        USES_PRODUCERS(Builder::usesProducers){

            @Override
            boolean isEnabled(ProcessingEnvironment processingEnvironment) {
                return processingEnvironment.getElementUtils().getTypeElement(Produces.class.getCanonicalName()) != null;
            }

            @Override
            public boolean useCommandLineOption() {
                return false;
            }
        };

        final OptionParser<FeatureStatus> parser = new OptionParser<FeatureStatus>(this);
        final FeatureStatus defaultValue;
        final BiConsumer<Builder, Boolean> setter;

        private Feature(BiConsumer<Builder, Boolean> setter) {
            this(setter, FeatureStatus.DISABLED);
        }

        private Feature(BiConsumer<Builder, Boolean> setter, FeatureStatus defaultValue) {
            this.setter = setter;
            this.defaultValue = defaultValue;
        }

        @Override
        public FeatureStatus defaultValue() {
            return this.defaultValue;
        }

        @Override
        public Set<FeatureStatus> validValues() {
            return EnumSet.allOf(FeatureStatus.class);
        }

        @Override
        public void set(Builder builder, ProcessingEnvironment processingEnvironment) {
            this.setter.accept(builder, this.isEnabled(processingEnvironment));
        }

        boolean isEnabled(ProcessingEnvironment processingEnvironment) {
            return this.parser.parse(processingEnvironment).equals((Object)FeatureStatus.ENABLED);
        }

        public String toString() {
            return CompilerOptions.optionName(this.name());
        }

        void noLongerRecognizedWarning(ProcessingEnvironment processingEnvironment) {
            if (processingEnvironment.getOptions().containsKey(this.toString())) {
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, this.toString() + " is no longer a recognized option by Dagger");
            }
        }
    }

    private static interface Option<T extends Enum<T>> {
        public void set(Builder var1, ProcessingEnvironment var2);

        default public boolean useCommandLineOption() {
            return true;
        }

        public T defaultValue();

        public Set<T> validValues();
    }

    @AutoValue.Builder
    @CanIgnoreReturnValue
    static interface Builder {
        public Builder usesProducers(boolean var1);

        public Builder headerCompilation(boolean var1);

        public Builder fastInit(boolean var1);

        public Builder formatGeneratedSource(boolean var1);

        public Builder writeProducerNameInToken(boolean var1);

        public Builder nullableValidationKind(Diagnostic.Kind var1);

        public Builder privateMemberValidationKind(Diagnostic.Kind var1);

        public Builder staticMemberValidationKind(Diagnostic.Kind var1);

        public Builder ignorePrivateAndStaticInjectionForComponent(boolean var1);

        public Builder scopeCycleValidationType(ValidationType var1);

        public Builder warnIfInjectionFactoryNotGeneratedUpstream(boolean var1);

        public Builder aheadOfTimeSubcomponents(boolean var1);

        public Builder useGradleIncrementalProcessing(boolean var1);

        public Builder moduleBindingValidationType(ValidationType var1);

        public Builder moduleHasDifferentScopesDiagnosticKind(Diagnostic.Kind var1);

        public Builder explicitBindingConflictsWithInjectValidationType(ValidationType var1);

        @CheckReturnValue
        public CompilerOptions build();
    }
}

