/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.MemoizedSentinel;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.BindingVariableNamer;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.RequestKind;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class SingleCheckedMethodImplementation
extends BindingMethodImplementation {
    private final ComponentImplementation componentImplementation;
    private final ResolvedBindings resolvedBindings;
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final Supplier<FieldSpec> field = Suppliers.memoize(this::createField);

    SingleCheckedMethodImplementation(ComponentImplementation component, ResolvedBindings resolvedBindings, BindingRequest request, BindingExpression bindingExpression, DaggerTypes types) {
        super(component, resolvedBindings.contributionBinding(), request, bindingExpression, types);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)component);
        this.resolvedBindings = resolvedBindings;
        this.binding = resolvedBindings.contributionBinding();
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
    }

    @Override
    CodeBlock implementation(Supplier<CodeBlock> simpleBindingExpression) {
        String fieldExpression = ((FieldSpec)this.field.get()).name.equals("local") ? "this.local" : ((FieldSpec)this.field.get()).name;
        CodeBlock.Builder builder = CodeBlock.builder().addStatement("Object local = $N", new Object[]{fieldExpression});
        if (this.isNullable()) {
            builder.beginControlFlow("if (local instanceof $T)", new Object[]{MemoizedSentinel.class});
        } else {
            builder.beginControlFlow("if (local == null)", new Object[0]);
        }
        return builder.addStatement("local = $L", new Object[]{simpleBindingExpression.get()}).addStatement("$N = ($T) local", new Object[]{fieldExpression, this.returnType()}).endControlFlow().addStatement("return ($T) local", new Object[]{this.returnType()}).build();
    }

    private FieldSpec createField() {
        String name = this.componentImplementation.getUniqueFieldName(this.request.isRequestKind(RequestKind.INSTANCE) ? BindingVariableNamer.name(this.binding) : FrameworkField.forResolvedBindings(this.resolvedBindings, Optional.empty()).name());
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.fieldType(), (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE});
        if (this.isNullable()) {
            builder.initializer("new $T()", new Object[]{MemoizedSentinel.class});
        }
        FieldSpec field = builder.build();
        this.componentImplementation.addField(ComponentImplementation.FieldSpecKind.PRIVATE_METHOD_SCOPED_FIELD, field);
        return field;
    }

    private TypeName fieldType() {
        if (this.isNullable()) {
            return TypeName.OBJECT;
        }
        TypeName returnType = TypeName.get((TypeMirror)this.returnType());
        return returnType.isPrimitive() ? returnType.box() : returnType;
    }

    private boolean isNullable() {
        return this.request.isRequestKind(RequestKind.INSTANCE) && this.binding.isNullable();
    }
}

