/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.MethodBindingExpression;
import dagger.internal.codegen.ModifiableBindingType;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class ModifiableConcreteMethodBindingExpression
extends MethodBindingExpression {
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final ModifiableBindingType modifiableBindingType;
    private final BindingMethodImplementation methodImplementation;
    private final ComponentImplementation componentImplementation;
    private final boolean bindingCannotBeModified;
    private Optional<String> methodName = Optional.empty();

    ModifiableConcreteMethodBindingExpression(ContributionBinding binding, BindingRequest request, ModifiableBindingType modifiableBindingType, BindingMethodImplementation methodImplementation, ComponentImplementation componentImplementation, boolean bindingCannotBeModified, DaggerTypes types) {
        super(request, methodImplementation, componentImplementation, types);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.modifiableBindingType = (ModifiableBindingType)((Object)Preconditions.checkNotNull((Object)((Object)modifiableBindingType)));
        this.methodImplementation = (BindingMethodImplementation)Preconditions.checkNotNull((Object)methodImplementation);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.bindingCannotBeModified = bindingCannotBeModified;
    }

    @Override
    protected void addMethod() {
        if (this.methodName.isPresent()) {
            return;
        }
        if (this.supertypeModifiableBindingMethod().isPresent()) {
            this.methodName = this.supertypeModifiableBindingMethod().map(method -> method.methodSpec().name);
            return;
        }
        this.methodName = Optional.of(this.componentImplementation.getUniqueMethodName(this.request, this.binding));
        this.componentImplementation.addModifiableBindingMethod(this.modifiableBindingType, this.request, this.methodImplementation.returnType(), MethodSpec.methodBuilder((String)this.methodName.get()).addModifiers(new Modifier[]{this.bindingCannotBeModified ? Modifier.PRIVATE : Modifier.PROTECTED}).returns(TypeName.get((TypeMirror)this.methodImplementation.returnType())).addCode(this.methodImplementation.body()).build(), this.bindingCannotBeModified);
    }

    @Override
    protected String methodName() {
        Preconditions.checkState((boolean)this.methodName.isPresent(), (Object)"addMethod() must be called before methodName().");
        return this.methodName.get();
    }
}

