/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.AutoValue_DuplicateBindingsValidator_SourceAndRequest;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingDeclarationFormatter;
import dagger.internal.codegen.BindingNode;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.Optionals;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class DuplicateBindingsValidator
implements BindingGraphPlugin {
    private static final Comparator<BindingDeclaration> BINDING_DECLARATION_COMPARATOR = Comparator.comparing(declaration -> declaration.contributingModule().isPresent() ? declaration.contributingModule() : declaration.bindingTypeElement(), Optionals.emptiesLast(Comparator.comparing(type -> type.getQualifiedName().toString()))).thenComparing(declaration -> declaration.bindingElement(), Optionals.emptiesLast(Comparator.comparing(element -> element.getSimpleName().toString()).thenComparing(element -> element.asType().toString())));
    private static final Equivalence<Binding> IGNORING_COMPONENT_PATH = new Equivalence<Binding>(){

        protected boolean doEquivalent(Binding a, Binding b) {
            return a.bindingElement().equals(b.bindingElement()) && a.contributingModule().equals(b.contributingModule());
        }

        protected int doHash(Binding binding) {
            return Objects.hash(binding.bindingElement(), binding.contributingModule());
        }
    };
    private final BindingDeclarationFormatter bindingDeclarationFormatter;

    @Inject
    DuplicateBindingsValidator(BindingDeclarationFormatter bindingDeclarationFormatter) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
    }

    public String pluginName() {
        return "Dagger/DuplicateBindings";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        HashSet reportedDuplicateBindingSets = new HashSet();
        this.duplicateBindings(bindingGraph).forEach((sourceAndRequest, resolvedBindings) -> {
            if (reportedDuplicateBindingSets.add(DuplicateBindingsValidator.equivalentSetIgnoringComponentPath((ImmutableSet<Binding>)resolvedBindings))) {
                this.reportDuplicateBindings((ImmutableSet<Binding>)resolvedBindings, bindingGraph, diagnosticReporter);
            }
        });
    }

    private Map<SourceAndRequest, ImmutableSet<Binding>> duplicateBindings(BindingGraph bindingGraph) {
        ImmutableSetMultimap<SourceAndRequest, Binding> bindingsByDependencyRequest = bindingGraph.dependencyEdges().stream().filter(edge -> bindingGraph.network().incidentNodes(edge).target() instanceof Binding).collect(DaggerStreams.toImmutableSetMultimap(edge -> SourceAndRequest.create((BindingGraph.Node)bindingGraph.network().incidentNodes(edge).source(), edge.dependencyRequest()), edge -> (Binding)bindingGraph.network().incidentNodes(edge).target()));
        return Maps.transformValues((Map)Maps.filterValues((Map)bindingsByDependencyRequest.asMap(), bindings -> bindings.size() > 1), ImmutableSet::copyOf);
    }

    private void reportDuplicateBindings(ImmutableSet<Binding> duplicateBindings, BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        Binding oneBinding = (Binding)duplicateBindings.asList().get(0);
        diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)oneBinding, Iterables.any(duplicateBindings, binding -> binding.kind().isMultibinding()) ? this.incompatibleBindingsMessage(oneBinding.key(), duplicateBindings, bindingGraph) : this.duplicateBindingMessage(oneBinding.key(), duplicateBindings, bindingGraph));
    }

    private String duplicateBindingMessage(Key key, ImmutableSet<Binding> duplicateBindings, BindingGraph graph) {
        StringBuilder message = new StringBuilder().append(key).append(" is bound multiple times:");
        this.formatDeclarations(message, 1, (Iterable<? extends BindingDeclaration>)this.declarations(graph, (Set<Binding>)duplicateBindings));
        return message.toString();
    }

    private String incompatibleBindingsMessage(Key key, ImmutableSet<Binding> duplicateBindings, BindingGraph graph) {
        ImmutableSet multibindings = duplicateBindings.stream().filter(binding -> binding.kind().isMultibinding()).collect(DaggerStreams.toImmutableSet());
        Verify.verify((multibindings.size() == 1 ? 1 : 0) != 0, (String)"expected only one multibinding for %s: %s", (Object)key, multibindings);
        StringBuilder message = new StringBuilder();
        Formatter messageFormatter = new Formatter(message);
        messageFormatter.format("%s has incompatible bindings or declarations:\n", key);
        message.append("    ");
        Binding multibinding = (Binding)Iterables.getOnlyElement(multibindings);
        messageFormatter.format("%s bindings and declarations:", this.multibindingTypeString(multibinding));
        this.formatDeclarations(message, 2, (Iterable<? extends BindingDeclaration>)this.declarations(graph, (Set<Binding>)multibindings));
        Set uniqueBindings = Sets.filter(duplicateBindings, binding -> !binding.equals(multibinding));
        message.append('\n').append("    ").append("Unique bindings and declarations:");
        this.formatDeclarations(message, 2, Sets.filter(this.declarations(graph, uniqueBindings), declaration -> !(declaration instanceof MultibindingDeclaration)));
        return message.toString();
    }

    private void formatDeclarations(StringBuilder builder, int indentLevel, Iterable<? extends BindingDeclaration> bindingDeclarations) {
        this.bindingDeclarationFormatter.formatIndentedList(builder, ImmutableList.copyOf(bindingDeclarations), indentLevel);
    }

    private ImmutableSet<BindingDeclaration> declarations(BindingGraph graph, Set<Binding> bindings) {
        return bindings.stream().flatMap(binding -> this.declarations(graph, (Binding)binding).stream()).distinct().sorted(BINDING_DECLARATION_COMPARATOR).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableSet<BindingDeclaration> declarations(BindingGraph graph, Binding binding) {
        ImmutableSet.Builder declarations = ImmutableSet.builder();
        BindingNode bindingNode = (BindingNode)binding;
        bindingNode.associatedDeclarations().forEach(arg_0 -> ((ImmutableSet.Builder)declarations).add(arg_0));
        if (this.bindingDeclarationFormatter.canFormat(bindingNode.delegate())) {
            declarations.add((Object)bindingNode.delegate());
        } else {
            graph.requestedBindings(binding).stream().flatMap(requestedBinding -> this.declarations(graph, (Binding)requestedBinding).stream()).forEach(arg_0 -> ((ImmutableSet.Builder)declarations).add(arg_0));
        }
        return declarations.build();
    }

    private String multibindingTypeString(Binding multibinding) {
        switch (multibinding.kind()) {
            case MULTIBOUND_MAP: {
                return "Map";
            }
            case MULTIBOUND_SET: {
                return "Set";
            }
        }
        throw new AssertionError(multibinding);
    }

    private static ImmutableSet<Equivalence.Wrapper<Binding>> equivalentSetIgnoringComponentPath(ImmutableSet<Binding> resolvedBindings) {
        return resolvedBindings.stream().map(arg_0 -> IGNORING_COMPONENT_PATH.wrap(arg_0)).collect(DaggerStreams.toImmutableSet());
    }

    @AutoValue
    static abstract class SourceAndRequest {
        SourceAndRequest() {
        }

        abstract BindingGraph.Node source();

        abstract DependencyRequest request();

        static SourceAndRequest create(BindingGraph.Node source, DependencyRequest request) {
            return new AutoValue_DuplicateBindingsValidator_SourceAndRequest(source, request);
        }
    }
}

