/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.Preconditions;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentCreatorImplementation;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementExpression;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.Optionals;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class ComponentRequirementExpressions {
    private final Optional<ComponentRequirementExpressions> parent;
    private final Map<ComponentRequirement, ComponentRequirementExpression> componentRequirementExpressions = new HashMap<ComponentRequirement, ComponentRequirementExpression>();
    private final BindingGraph graph;
    private final ComponentImplementation componentImplementation;
    private final DaggerTypes types;
    private final DaggerElements elements;

    private ComponentRequirementExpressions(Optional<ComponentRequirementExpressions> parent, BindingGraph graph, ComponentImplementation componentImplementation, DaggerTypes types, DaggerElements elements) {
        this.parent = parent;
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.types = types;
        this.elements = elements;
    }

    ComponentRequirementExpressions(BindingGraph graph, ComponentImplementation componentImplementation, DaggerTypes types, DaggerElements elements) {
        this(Optional.empty(), graph, componentImplementation, types, elements);
    }

    ComponentRequirementExpressions forChildComponent(BindingGraph graph, ComponentImplementation componentImplementation) {
        return new ComponentRequirementExpressions(Optional.of(this), graph, componentImplementation, this.types, this.elements);
    }

    CodeBlock getExpression(ComponentRequirement componentRequirement, ClassName requestingClass) {
        return this.getExpression(componentRequirement).getExpression(requestingClass);
    }

    CodeBlock getExpressionDuringInitialization(ComponentRequirement componentRequirement, ClassName requestingClass) {
        return this.getExpression(componentRequirement).getExpressionDuringInitialization(requestingClass);
    }

    ComponentRequirementExpression getExpression(ComponentRequirement componentRequirement) {
        if (this.graph.componentRequirements().contains((Object)componentRequirement)) {
            return this.componentRequirementExpressions.computeIfAbsent(componentRequirement, this::createMethodOrField);
        }
        if (this.parent.isPresent()) {
            return this.parent.get().getExpression(componentRequirement);
        }
        throw new IllegalStateException("no component requirement expression found for " + componentRequirement);
    }

    private ComponentRequirementExpression createMethodOrField(ComponentRequirement requirement) {
        if (this.componentImplementation.isAbstract() && requirement.kind().isModule()) {
            return new ModifiableModule(requirement);
        }
        return this.createField(requirement);
    }

    private ComponentRequirementExpression createField(ComponentRequirement requirement) {
        Optional<ComponentCreatorImplementation> creatorImplementation = Optionals.firstPresent(this.componentImplementation.baseImplementation().flatMap(c -> c.creatorImplementation()), this.componentImplementation.creatorImplementation(), new Optional[0]);
        if (creatorImplementation.isPresent()) {
            FieldSpec builderField = (FieldSpec)creatorImplementation.get().builderFields().get((Object)requirement);
            return new BuilderField(requirement, this.componentImplementation, builderField);
        }
        if (this.graph.factoryMethod().isPresent() && this.graph.factoryMethodParameters().containsKey((Object)requirement)) {
            ParameterSpec factoryParameter = ParameterSpec.get((VariableElement)((VariableElement)this.graph.factoryMethodParameters().get((Object)requirement)));
            return new ComponentParameterField(requirement, this.componentImplementation, factoryParameter);
        }
        if (requirement.kind().isModule()) {
            return new ComponentInstantiableField(requirement, this.componentImplementation);
        }
        throw new AssertionError((Object)String.format("Can't create %s in %s", requirement, this.componentImplementation.name()));
    }

    private final class ModifiableModule
    implements ComponentRequirementExpression {
        private final ComponentRequirement module;
        private final Supplier<MemberSelect> method = Suppliers.memoize(this::methodSelect);

        private ModifiableModule(ComponentRequirement module) {
            com.google.common.base.Preconditions.checkArgument((boolean)module.kind().isModule());
            this.module = module;
        }

        @Override
        public CodeBlock getExpression(ClassName requestingClass) {
            return ((MemberSelect)this.method.get()).getExpressionFor(requestingClass);
        }

        private MemberSelect methodSelect() {
            String methodName = ComponentRequirementExpressions.this.componentImplementation.supertypeModifiableModuleMethodName(this.module).orElseGet(this::createMethod);
            return MemberSelect.localMethod(ComponentRequirementExpressions.this.componentImplementation.name(), methodName);
        }

        private String createMethod() {
            String methodName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, ComponentRequirementExpressions.this.componentImplementation.getUniqueMethodName(this.module.typeElement().getSimpleName().toString()));
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TypeName.get((TypeMirror)this.module.type()));
            if (ComponentRequirementExpressions.this.graph.componentDescriptor().creatorDescriptor().isPresent()) {
                methodBuilder.addStatement("return $L", new Object[]{ComponentRequirementExpressions.this.createField(this.module).getExpression(ComponentRequirementExpressions.this.componentImplementation.name())});
            } else {
                methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
            }
            ComponentRequirementExpressions.this.componentImplementation.addModifiableModuleMethod(this.module, methodBuilder.build());
            return methodName;
        }
    }

    private static final class ComponentParameterField
    extends AbstractField {
        private final ParameterSpec factoryParameter;

        private ComponentParameterField(ComponentRequirement componentRequirement, ComponentImplementation componentImplementation, ParameterSpec factoryParameter) {
            super(componentRequirement, componentImplementation);
            this.factoryParameter = (ParameterSpec)com.google.common.base.Preconditions.checkNotNull((Object)factoryParameter);
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = $T.checkNotNull($N);", (Object[])new Object[]{componentField, Preconditions.class, this.factoryParameter});
        }
    }

    private static final class ComponentInstantiableField
    extends AbstractField {
        private ComponentInstantiableField(ComponentRequirement componentRequirement, ComponentImplementation componentImplementation) {
            super(componentRequirement, componentImplementation);
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = new $T();", (Object[])new Object[]{componentField, componentField.type});
        }
    }

    private static final class BuilderField
    extends AbstractField {
        private final FieldSpec builderField;

        private BuilderField(ComponentRequirement componentRequirement, ComponentImplementation componentImplementation, FieldSpec builderField) {
            super(componentRequirement, componentImplementation);
            this.builderField = (FieldSpec)com.google.common.base.Preconditions.checkNotNull((Object)builderField);
        }

        @Override
        public CodeBlock getExpressionDuringInitialization(ClassName requestingClass) {
            if (((AbstractField)this).componentImplementation.name().equals((Object)requestingClass)) {
                return CodeBlock.of((String)"builder.$N", (Object[])new Object[]{this.builderField});
            }
            return this.getExpression(requestingClass);
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = builder.$N;", (Object[])new Object[]{componentField, this.builderField});
        }
    }

    private static abstract class AbstractField
    implements ComponentRequirementExpression {
        private final ComponentRequirement componentRequirement;
        private final ComponentImplementation componentImplementation;
        private final Supplier<MemberSelect> field = Suppliers.memoize(this::createField);

        private AbstractField(ComponentRequirement componentRequirement, ComponentImplementation componentImplementation) {
            this.componentRequirement = (ComponentRequirement)com.google.common.base.Preconditions.checkNotNull((Object)componentRequirement);
            this.componentImplementation = (ComponentImplementation)com.google.common.base.Preconditions.checkNotNull((Object)componentImplementation);
        }

        @Override
        public CodeBlock getExpression(ClassName requestingClass) {
            return ((MemberSelect)this.field.get()).getExpressionFor(requestingClass);
        }

        private MemberSelect createField() {
            String fieldName = this.componentImplementation.getUniqueFieldName(this.componentRequirement.variableName());
            FieldSpec field = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)this.componentRequirement.type()), (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
            this.componentImplementation.addField(ComponentImplementation.FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, field);
            this.componentImplementation.addComponentRequirementInitialization(this.fieldInitialization(field));
            return MemberSelect.localField(this.componentImplementation.name(), fieldName);
        }

        abstract CodeBlock fieldInitialization(FieldSpec var1);
    }
}

