/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.MethodBindingExpression;
import javax.lang.model.type.TypeMirror;

final class ComponentMethodBindingExpression
extends MethodBindingExpression {
    private final BindingMethodImplementation methodImplementation;
    private final ComponentImplementation componentImplementation;
    private final ComponentDescriptor.ComponentMethodDescriptor componentMethod;

    ComponentMethodBindingExpression(BindingRequest request, BindingMethodImplementation methodImplementation, ComponentImplementation componentImplementation, ComponentDescriptor.ComponentMethodDescriptor componentMethod, DaggerTypes types) {
        super(request, methodImplementation, componentImplementation, types);
        this.methodImplementation = (BindingMethodImplementation)Preconditions.checkNotNull((Object)methodImplementation);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.componentMethod = (ComponentDescriptor.ComponentMethodDescriptor)Preconditions.checkNotNull((Object)componentMethod);
    }

    @Override
    protected CodeBlock getComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return componentMethod.equals(this.componentMethod) && component.equals(this.componentImplementation) ? this.methodImplementation.bodyForComponentMethod(componentMethod) : super.getComponentMethodImplementation(componentMethod, component);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression expression = super.getDependencyExpression(requestingClass);
        TypeMirror methodReturnType = this.componentMethod.methodElement().getReturnType();
        return methodReturnType.getKind().isPrimitive() ? Expression.create(methodReturnType, expression.codeBlock()) : expression;
    }

    @Override
    protected void addMethod() {
    }

    @Override
    protected String methodName() {
        return this.componentMethod.methodElement().getSimpleName().toString();
    }
}

