/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.BindingVariableNamer;
import dagger.internal.codegen.ComponentCreatorImplementation;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.KeyVariableNamer;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.Optionals;
import dagger.internal.codegen.SubcomponentNames;
import dagger.internal.codegen.TypeSpecs;
import dagger.internal.codegen.UniqueNameSet;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class ComponentImplementation {
    private final ComponentDescriptor componentDescriptor;
    private final ClassName name;
    private final NestingKind nestingKind;
    private final boolean isAbstract;
    private final Optional<ComponentImplementation> superclassImplementation;
    private Optional<ComponentCreatorImplementation> creatorImplementation;
    private final Map<TypeElement, ComponentImplementation> childImplementations = new HashMap<TypeElement, ComponentImplementation>();
    private final TypeSpec.Builder component;
    private final SubcomponentNames subcomponentNames;
    private final UniqueNameSet componentFieldNames = new UniqueNameSet();
    private final UniqueNameSet componentMethodNames = new UniqueNameSet();
    private final List<CodeBlock> initializations = new ArrayList<CodeBlock>();
    private final List<CodeBlock> componentRequirementInitializations = new ArrayList<CodeBlock>();
    private final Set<Key> cancellableProducerKeys = new LinkedHashSet<Key>();
    private final ListMultimap<FieldSpecKind, FieldSpec> fieldSpecsMap = MultimapBuilder.enumKeys(FieldSpecKind.class).arrayListValues().build();
    private final ListMultimap<MethodSpecKind, MethodSpec> methodSpecsMap = MultimapBuilder.enumKeys(MethodSpecKind.class).arrayListValues().build();
    private final ListMultimap<TypeSpecKind, TypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(TypeSpecKind.class).arrayListValues().build();
    private final List<Supplier<TypeSpec>> switchingProviderSupplier = new ArrayList<Supplier<TypeSpec>>();
    private final ModifiableBindingMethods modifiableBindingMethods = new ModifiableBindingMethods();
    private final SetMultimap<BindingRequest, DependencyRequest> multibindingContributionsMade = HashMultimap.create();
    private Optional<MethodSpec> configureInitializationMethod = Optional.empty();
    private final Map<ComponentRequirement, String> modifiableModuleMethods = new LinkedHashMap<ComponentRequirement, String>();

    ComponentImplementation(ComponentDescriptor componentDescriptor, ClassName name, NestingKind nestingKind, Optional<ComponentImplementation> superclassImplementation, SubcomponentNames subcomponentNames, Modifier ... modifiers) {
        ComponentImplementation.checkName(name, nestingKind);
        this.componentDescriptor = componentDescriptor;
        this.name = name;
        this.nestingKind = nestingKind;
        this.isAbstract = Arrays.asList(modifiers).contains((Object)Modifier.ABSTRACT);
        this.superclassImplementation = superclassImplementation;
        this.component = TypeSpec.classBuilder((ClassName)name).addModifiers(modifiers);
        this.subcomponentNames = subcomponentNames;
    }

    ComponentImplementation(ComponentImplementation parent, ComponentDescriptor componentDescriptor, Optional<ComponentImplementation> superclassImplementation, Modifier ... modifiers) {
        this(componentDescriptor, parent.getSubcomponentName(componentDescriptor), NestingKind.MEMBER, superclassImplementation, parent.subcomponentNames, modifiers);
    }

    private static void checkName(ClassName name, NestingKind nestingKind) {
        switch (nestingKind) {
            case TOP_LEVEL: {
                Preconditions.checkArgument((name.enclosingClassName() == null ? 1 : 0) != 0, (String)"must be a top-level class name: %s", (Object)name);
                break;
            }
            case MEMBER: {
                Preconditions.checkNotNull((Object)name.enclosingClassName(), (String)"must not be a top-level class name: %s", (Object)name);
                break;
            }
            default: {
                throw new IllegalArgumentException("nestingKind must be TOP_LEVEL or MEMBER: " + (Object)((Object)nestingKind));
            }
        }
    }

    ComponentDescriptor componentDescriptor() {
        return this.componentDescriptor;
    }

    ClassName name() {
        return this.name;
    }

    boolean isNested() {
        return this.nestingKind.isNested();
    }

    boolean isAbstract() {
        return this.isAbstract;
    }

    Optional<ComponentImplementation> superclassImplementation() {
        return this.superclassImplementation;
    }

    Optional<ComponentImplementation> baseImplementation() {
        return this.superclassImplementation.isPresent() ? Optional.of(Optionals.rootmostValue(this, c -> c.superclassImplementation)) : Optional.empty();
    }

    Optional<MethodSpec> superConfigureInitializationMethod() {
        Optional<ComponentImplementation> currentSuper = this.superclassImplementation;
        while (currentSuper.isPresent()) {
            if (currentSuper.get().configureInitializationMethod.isPresent()) {
                return currentSuper.get().configureInitializationMethod;
            }
            currentSuper = currentSuper.get().superclassImplementation;
        }
        return Optional.empty();
    }

    Optional<MethodSpec> configureInitializationMethod() {
        return this.configureInitializationMethod;
    }

    void setConfigureInitializationMethod(MethodSpec method) {
        this.configureInitializationMethod = Optional.of(method);
        this.addMethod(MethodSpecKind.CONFIGURE_INITIALIZATION_METHOD, method);
    }

    void setCreatorImplementation(Optional<ComponentCreatorImplementation> creatorImplementation) {
        Preconditions.checkState((this.creatorImplementation == null ? 1 : 0) != 0, (Object)"setCreatorImplementation has already been called");
        this.creatorImplementation = creatorImplementation;
    }

    Optional<ComponentCreatorImplementation> creatorImplementation() {
        Preconditions.checkState((this.creatorImplementation != null ? 1 : 0) != 0, (Object)"setCreatorImplementation has not been called yet");
        return this.creatorImplementation;
    }

    ClassName getCreatorName() {
        return this.isNested() ? this.name.peerClass(this.subcomponentNames.get(this.componentDescriptor) + "Builder") : this.name.nestedClass("Builder");
    }

    ClassName getSubcomponentName(ComponentDescriptor childDescriptor) {
        Preconditions.checkArgument((boolean)this.componentDescriptor.childComponents().contains((Object)childDescriptor), (String)"%s is not a child component of %s", (Object)childDescriptor.typeElement(), (Object)this.componentDescriptor.typeElement());
        return this.name.nestedClass(this.subcomponentNames.get(childDescriptor) + "Impl");
    }

    String getSubcomponentName(Key key) {
        return this.subcomponentNames.get(key);
    }

    Optional<ComponentImplementation> childImplementation(ComponentDescriptor child) {
        return Optional.ofNullable(this.childImplementations.get(child.typeElement()));
    }

    boolean isTypeAccessible(TypeMirror type) {
        return Accessibility.isTypeAccessibleFrom(type, this.name.packageName());
    }

    void addSupertype(TypeElement supertype) {
        TypeSpecs.addSupertype(this.component, supertype);
    }

    void addSuperclass(ClassName className) {
        Preconditions.checkState((boolean)this.superclassImplementation.isPresent(), (String)"Setting the superclass for component [%s] when there is no superclass implementation.", (Object)this.name);
        this.component.superclass((TypeName)className);
    }

    void addField(FieldSpecKind fieldKind, FieldSpec fieldSpec) {
        this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
    }

    void addFields(FieldSpecKind fieldKind, Iterable<FieldSpec> fieldSpecs) {
        this.fieldSpecsMap.putAll((Object)fieldKind, fieldSpecs);
    }

    void addMethod(MethodSpecKind methodKind, MethodSpec methodSpec) {
        this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
    }

    void addMethods(MethodSpecKind methodKind, Iterable<MethodSpec> methodSpecs) {
        this.methodSpecsMap.putAll((Object)methodKind, methodSpecs);
    }

    void addModifiableBindingMethod(ModifiableBindingType type, BindingRequest request, TypeMirror returnType, MethodSpec methodSpec, boolean finalized) {
        this.modifiableBindingMethods.addMethod(type, request, returnType, methodSpec, finalized);
        this.methodSpecsMap.put((Object)MethodSpecKind.MODIFIABLE_BINDING_METHOD, (Object)methodSpec);
    }

    void registerModifiableBindingMethod(ModifiableBindingType type, BindingRequest request, TypeMirror returnType, MethodSpec methodSpec, boolean finalized) {
        this.modifiableBindingMethods.addMethod(type, request, returnType, methodSpec, finalized);
    }

    void addImplementedModifiableBindingMethod(ModifiableBindingMethods.ModifiableBindingMethod method) {
        this.modifiableBindingMethods.methodImplemented(method);
        this.methodSpecsMap.put((Object)MethodSpecKind.MODIFIABLE_BINDING_METHOD, (Object)method.methodSpec());
    }

    void addModifiableModuleMethod(ComponentRequirement module, MethodSpec method) {
        Preconditions.checkArgument((boolean)module.kind().isModule());
        Preconditions.checkState((this.modifiableModuleMethods.put(module, method.name) == null ? 1 : 0) != 0);
        this.methodSpecsMap.put((Object)MethodSpecKind.MODIFIABLE_BINDING_METHOD, (Object)method);
    }

    void addType(TypeSpecKind typeKind, TypeSpec typeSpec) {
        this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
    }

    void addTypes(TypeSpecKind typeKind, Iterable<TypeSpec> typeSpecs) {
        this.typeSpecsMap.putAll((Object)typeKind, typeSpecs);
    }

    void addChild(ComponentDescriptor child, ComponentImplementation childImplementation) {
        this.childImplementations.put(child.typeElement(), childImplementation);
        this.addType(TypeSpecKind.SUBCOMPONENT, childImplementation.generate().build());
    }

    void addSwitchingProvider(Supplier<TypeSpec> typeSpecSupplier) {
        this.switchingProviderSupplier.add(typeSpecSupplier);
    }

    void addInitialization(CodeBlock codeBlock) {
        this.initializations.add(codeBlock);
    }

    void addComponentRequirementInitialization(CodeBlock codeBlock) {
        this.componentRequirementInitializations.add(codeBlock);
    }

    void addCancellableProducerKey(Key key) {
        this.cancellableProducerKeys.add(key);
    }

    String getUniqueFieldName(String name) {
        return this.componentFieldNames.getUniqueName(name);
    }

    String getUniqueMethodName(String name) {
        return this.componentMethodNames.getUniqueName(name);
    }

    String getUniqueMethodName(BindingRequest request) {
        return this.uniqueMethodName(request, KeyVariableNamer.name(request.key()));
    }

    String getUniqueMethodName(BindingRequest request, ContributionBinding binding) {
        return this.uniqueMethodName(request, BindingVariableNamer.name(binding));
    }

    private String uniqueMethodName(BindingRequest request, String bindingName) {
        String baseMethodName = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, bindingName) + (request.isRequestKind(RequestKind.INSTANCE) ? "" : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, request.kindName()));
        return this.getUniqueMethodName(baseMethodName);
    }

    void claimMethodName(CharSequence name) {
        this.componentMethodNames.claim(name);
    }

    ImmutableList<CodeBlock> getInitializations() {
        return ImmutableList.copyOf(this.initializations);
    }

    ImmutableList<CodeBlock> getComponentRequirementInitializations() {
        return ImmutableList.copyOf(this.componentRequirementInitializations);
    }

    ImmutableList<Key> getCancellableProducerKeys() {
        Optional<ComponentImplementation> currentSuperImplementation = this.superclassImplementation;
        HashSet<Key> cancelledKeysFromSuperclass = new HashSet<Key>();
        while (currentSuperImplementation.isPresent()) {
            cancelledKeysFromSuperclass.addAll(currentSuperImplementation.get().cancellableProducerKeys);
            currentSuperImplementation = currentSuperImplementation.get().superclassImplementation;
        }
        return Sets.difference(this.cancellableProducerKeys, cancelledKeysFromSuperclass).immutableCopy().asList();
    }

    ImmutableList<ModifiableBindingMethods.ModifiableBindingMethod> getModifiableBindingMethods() {
        ImmutableList.Builder modifiableBindingMethodsBuilder = ImmutableList.builder();
        if (this.superclassImplementation.isPresent()) {
            ImmutableList<ModifiableBindingMethods.ModifiableBindingMethod> superclassModifiableBindingMethods = this.superclassImplementation.get().getModifiableBindingMethods();
            superclassModifiableBindingMethods.stream().filter(method -> !this.modifiableBindingMethods.finalized((ModifiableBindingMethods.ModifiableBindingMethod)method)).forEach(arg_0 -> ((ImmutableList.Builder)modifiableBindingMethodsBuilder).add(arg_0));
        }
        modifiableBindingMethodsBuilder.addAll(this.modifiableBindingMethods.getNonFinalizedMethods());
        return modifiableBindingMethodsBuilder.build();
    }

    ImmutableSet<String> getAllModifiableMethodNames() {
        ImmutableSet.Builder names = ImmutableSet.builder();
        this.modifiableBindingMethods.allMethods().forEach(method -> names.add((Object)method.methodSpec().name));
        names.addAll(this.modifiableModuleMethods.values());
        this.superclassImplementation.ifPresent(superclass -> names.addAll(superclass.getAllModifiableMethodNames()));
        return names.build();
    }

    Optional<ModifiableBindingMethods.ModifiableBindingMethod> getModifiableBindingMethod(BindingRequest request) {
        Optional<ModifiableBindingMethods.ModifiableBindingMethod> method = this.modifiableBindingMethods.getMethod(request);
        if (!method.isPresent() && this.superclassImplementation.isPresent()) {
            return this.superclassImplementation.get().getModifiableBindingMethod(request);
        }
        return method;
    }

    Optional<ModifiableBindingMethods.ModifiableBindingMethod> supertypeModifiableBindingMethod(BindingRequest request) {
        return this.superclassImplementation().flatMap(superImplementation -> superImplementation.getModifiableBindingMethod(request));
    }

    ImmutableMap<ComponentRequirement, String> getAllModifiableModuleMethods() {
        ImmutableMap.Builder methods = ImmutableMap.builder();
        methods.putAll(this.modifiableModuleMethods);
        this.superclassImplementation.ifPresent(superclass -> methods.putAll(superclass.getAllModifiableModuleMethods()));
        return methods.build();
    }

    Optional<String> supertypeModifiableModuleMethodName(ComponentRequirement module) {
        Preconditions.checkArgument((boolean)module.kind().isModule());
        if (!this.superclassImplementation.isPresent()) {
            return Optional.empty();
        }
        String methodName = this.superclassImplementation.get().modifiableModuleMethods.get(module);
        if (methodName == null) {
            return this.superclassImplementation.get().supertypeModifiableModuleMethodName(module);
        }
        return Optional.of(methodName);
    }

    TypeSpec.Builder generate() {
        this.fieldSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addFields(arg_0));
        this.methodSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addMethods(arg_0));
        this.typeSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addTypes(arg_0));
        this.switchingProviderSupplier.stream().map(Supplier::get).forEach(arg_0 -> ((TypeSpec.Builder)this.component).addType(arg_0));
        return this.component;
    }

    void registerImplementedMultibinding(ContributionBinding multibinding, BindingRequest bindingRequest) {
        Preconditions.checkArgument((boolean)multibinding.isSyntheticMultibinding());
        if (!this.multibindingContributionsMade.containsKey((Object)bindingRequest)) {
            this.multibindingContributionsMade.putAll((Object)bindingRequest, multibinding.dependencies());
        }
    }

    ImmutableSet<DependencyRequest> superclassContributionsMade(BindingRequest bindingRequest) {
        return this.superclassImplementation.map(s -> s.getAllMultibindingContributions(bindingRequest)).orElse(ImmutableSet.of());
    }

    private ImmutableSet<DependencyRequest> getAllMultibindingContributions(BindingRequest bindingRequest) {
        return ImmutableSet.copyOf((Collection)Sets.union((Set)this.multibindingContributionsMade.get((Object)bindingRequest), this.superclassContributionsMade(bindingRequest)));
    }

    static enum TypeSpecKind {
        PRESENT_FACTORY,
        COMPONENT_CREATOR,
        COMPONENT_PROVISION_FACTORY,
        SUBCOMPONENT;

    }

    static enum MethodSpecKind {
        CONSTRUCTOR,
        CONFIGURE_INITIALIZATION_METHOD,
        BUILDER_METHOD,
        PRIVATE_METHOD,
        INITIALIZE_METHOD,
        COMPONENT_METHOD,
        MEMBERS_INJECTION_METHOD,
        ABSENT_OPTIONAL_METHOD,
        MODIFIABLE_BINDING_METHOD,
        CANCELLATION_LISTENER_METHOD;

    }

    static enum FieldSpecKind {
        PRIVATE_METHOD_SCOPED_FIELD,
        COMPONENT_REQUIREMENT_FIELD,
        FRAMEWORK_FIELD,
        ABSENT_OPTIONAL_FIELD;

    }
}

