/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Lazy;
import dagger.Subcomponent;
import dagger.internal.codegen.AutoValue_ComponentDescriptor;
import dagger.internal.codegen.AutoValue_ComponentDescriptor_ComponentMethodDescriptor;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentCreatorDescriptor;
import dagger.internal.codegen.ComponentKind;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequestFactory;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.model.DependencyRequest;
import dagger.model.RequestKind;
import dagger.model.Scope;
import dagger.producers.CancellationPolicy;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@AutoValue
abstract class ComponentDescriptor {
    private final Supplier<ImmutableMap<TypeElement, ComponentDescriptor>> childComponentsByBuilderType = Suppliers.memoize(() -> this.childComponents().stream().filter(child -> child.creatorDescriptor().isPresent()).collect(DaggerStreams.toImmutableMap(child -> child.creatorDescriptor().get().typeElement(), child -> child)));
    private static final ImmutableSet<String> NON_CONTRIBUTING_OBJECT_METHOD_NAMES = ImmutableSet.of((Object)"toString", (Object)"hashCode", (Object)"clone", (Object)"getClass");

    ComponentDescriptor() {
    }

    abstract ComponentKind kind();

    abstract AnnotationMirror annotation();

    abstract TypeElement typeElement();

    abstract ImmutableSet<ComponentRequirement> dependencies();

    final ImmutableSet<ComponentRequirement> dependenciesAndConcreteModules() {
        return Stream.concat(this.moduleTypes().stream().filter(dep -> !dep.getModifiers().contains((Object)Modifier.ABSTRACT)).map(module -> ComponentRequirement.forModule(module.asType())), this.dependencies().stream()).collect(DaggerStreams.toImmutableSet());
    }

    abstract ImmutableSet<ModuleDescriptor> modules();

    final ImmutableSet<TypeElement> moduleTypes() {
        return this.modules().stream().map(ModuleDescriptor::moduleElement).collect(DaggerStreams.toImmutableSet());
    }

    abstract ImmutableMap<ExecutableElement, ComponentRequirement> dependenciesByDependencyMethod();

    final ComponentRequirement getDependencyThatDefinesMethod(Element method) {
        Preconditions.checkArgument((boolean)(method instanceof ExecutableElement), (String)"method must be an executable element: %s", (Object)method);
        return (ComponentRequirement)Preconditions.checkNotNull((Object)((ComponentRequirement)this.dependenciesByDependencyMethod().get((Object)method)), (String)"no dependency implements %s", (Object)method);
    }

    abstract ImmutableSet<Scope> scopes();

    final ImmutableSet<ComponentDescriptor> childComponents() {
        return ImmutableSet.builder().addAll((Iterable)this.childComponentsDeclaredByFactoryMethods().values()).addAll((Iterable)this.childComponentsDeclaredByBuilderEntryPoints().values()).addAll(this.childComponentsDeclaredByModules()).build();
    }

    abstract ImmutableSet<ComponentDescriptor> childComponentsDeclaredByModules();

    abstract ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByFactoryMethods();

    final Optional<ComponentMethodDescriptor> getFactoryMethodForChildComponent(ComponentDescriptor childComponent) {
        return Optional.ofNullable((ComponentMethodDescriptor)this.childComponentsDeclaredByFactoryMethods().inverse().get((Object)childComponent));
    }

    abstract ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByBuilderEntryPoints();

    final ComponentDescriptor getChildComponentWithBuilderType(TypeElement builderType) {
        return (ComponentDescriptor)Preconditions.checkNotNull((Object)((ComponentDescriptor)((ImmutableMap)this.childComponentsByBuilderType.get()).get((Object)builderType)), (String)"no child component found for builder type %s", (Object)builderType.getQualifiedName());
    }

    abstract ImmutableSet<ComponentMethodDescriptor> componentMethods();

    Optional<ComponentMethodDescriptor> firstMatchingComponentMethod(BindingRequest request) {
        return this.componentMethods().stream().filter(method -> ComponentDescriptor.doesComponentMethodMatch(method, request)).findFirst();
    }

    private static boolean doesComponentMethodMatch(ComponentMethodDescriptor componentMethod, BindingRequest request) {
        return componentMethod.dependencyRequest().map(BindingRequest::bindingRequest).filter(request::equals).isPresent();
    }

    final ImmutableSet<ComponentMethodDescriptor> entryPointMethods() {
        return this.componentMethods().stream().filter(method -> method.dependencyRequest().isPresent()).collect(DaggerStreams.toImmutableSet());
    }

    final ImmutableSet<DependencyRequest> entryPoints() {
        if (this.kind().isForModuleValidation()) {
            return this.modules().stream().flatMap(module -> module.allBindingKeys().stream()).map(key -> key.toBuilder().multibindingContributionIdentifier(Optional.empty()).build()).map(key -> DependencyRequest.builder().key(key).kind(RequestKind.FUTURE).isNullable(true).build()).collect(DaggerStreams.toImmutableSet());
        }
        return this.entryPointMethods().stream().map(method -> method.dependencyRequest().get()).collect(DaggerStreams.toImmutableSet());
    }

    abstract Optional<ComponentCreatorDescriptor> creatorDescriptor();

    final boolean hasCreator() {
        return this.kind().isTopLevel() || this.creatorDescriptor().isPresent();
    }

    final Optional<CancellationPolicy> cancellationPolicy() {
        return this.kind().isProducer() ? Optional.ofNullable(this.typeElement().getAnnotation(CancellationPolicy.class)) : Optional.empty();
    }

    static boolean isComponentContributionMethod(DaggerElements elements, ExecutableElement method) {
        return method.getParameters().isEmpty() && !method.getReturnType().getKind().equals((Object)TypeKind.VOID) && !elements.getTypeElement(Object.class).equals(method.getEnclosingElement()) && !NON_CONTRIBUTING_OBJECT_METHOD_NAMES.contains((Object)method.getSimpleName().toString());
    }

    static boolean isComponentProductionMethod(DaggerElements elements, ExecutableElement method) {
        return ComponentDescriptor.isComponentContributionMethod(elements, method) && DaggerTypes.isFutureType(method.getReturnType());
    }

    static final class Factory {
        private final DaggerElements elements;
        private final DaggerTypes types;
        private final DependencyRequestFactory dependencyRequestFactory;
        private final ModuleDescriptor.Factory moduleDescriptorFactory;
        private final CompilerOptions compilerOptions;

        @Inject
        Factory(DaggerElements elements, DaggerTypes types, DependencyRequestFactory dependencyRequestFactory, ModuleDescriptor.Factory moduleDescriptorFactory, CompilerOptions compilerOptions) {
            this.elements = elements;
            this.types = types;
            this.dependencyRequestFactory = dependencyRequestFactory;
            this.moduleDescriptorFactory = moduleDescriptorFactory;
            this.compilerOptions = compilerOptions;
        }

        ComponentDescriptor forTypeElement(TypeElement typeElement) {
            Optional<ComponentKind> kind = ComponentKind.forAnnotatedElement(typeElement);
            Preconditions.checkArgument((boolean)kind.isPresent(), (String)"%s must have a component or subcomponent or module annotation", (Object)typeElement);
            if (!this.compilerOptions.aheadOfTimeSubcomponents()) {
                Preconditions.checkArgument((boolean)kind.get().isTopLevel(), (String)"%s must be a top-level component.", (Object)typeElement);
            }
            return this.create(typeElement, kind.get());
        }

        private ComponentDescriptor create(TypeElement typeElement, ComponentKind kind) {
            ImmutableList enclosedCreators;
            AnnotationMirror componentAnnotation = DaggerElements.getAnnotationMirror(typeElement, kind.annotation()).get();
            DeclaredType declaredComponentType = MoreTypes.asDeclared(typeElement.asType());
            ImmutableSet componentDependencies = kind.isTopLevel() && !kind.isForModuleValidation() ? ConfigurationAnnotations.getComponentDependencies(componentAnnotation).stream().map(ComponentRequirement::forDependency).collect(DaggerStreams.toImmutableSet()) : ImmutableSet.of();
            ImmutableMap.Builder dependenciesByDependencyMethod = ImmutableMap.builder();
            for (ComponentRequirement componentDependency : componentDependencies) {
                for (Object dependencyMethod : ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency.typeElement()))) {
                    if (!ComponentDescriptor.isComponentContributionMethod(this.elements, (ExecutableElement)dependencyMethod)) continue;
                    dependenciesByDependencyMethod.put(dependencyMethod, (Object)componentDependency);
                }
            }
            ImmutableSet modules = kind.isForModuleValidation() ? ImmutableSet.of((Object)typeElement) : ConfigurationAnnotations.getComponentModules(componentAnnotation).stream().map(MoreTypes::asTypeElement).collect(DaggerStreams.toImmutableSet());
            ImmutableSet<ModuleDescriptor> transitiveModules = this.moduleDescriptorFactory.transitiveModules((Iterable<TypeElement>)modules);
            ImmutableSet.Builder subcomponentsFromModules = ImmutableSet.builder();
            for (ModuleDescriptor module : transitiveModules) {
                for (SubcomponentDeclaration subcomponentDeclaration : module.subcomponentDeclarations()) {
                    TypeElement subcomponent = subcomponentDeclaration.subcomponentType();
                    subcomponentsFromModules.add((Object)this.create(subcomponent, ComponentKind.forAnnotatedElement(subcomponent).get()));
                }
            }
            ImmutableSet.Builder componentMethodsBuilder = ImmutableSet.builder();
            ImmutableBiMap.Builder subcomponentsByFactoryMethod = ImmutableBiMap.builder();
            ImmutableBiMap.Builder subcomponentsByBuilderMethod = ImmutableBiMap.builder();
            if (!kind.isForModuleValidation()) {
                ImmutableSet<ExecutableElement> unimplementedMethods = this.elements.getUnimplementedMethods(typeElement);
                for (ExecutableElement componentMethod : unimplementedMethods) {
                    ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredComponentType, componentMethod));
                    ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(typeElement, kind, componentMethod);
                    componentMethodsBuilder.add((Object)componentMethodDescriptor);
                    switch (componentMethodDescriptor.kind()) {
                        case SUBCOMPONENT: 
                        case PRODUCTION_SUBCOMPONENT: {
                            subcomponentsByFactoryMethod.put((Object)componentMethodDescriptor, (Object)this.create(MoreElements.asType(MoreTypes.asElement(resolvedMethod.getReturnType())), componentMethodDescriptor.kind().componentKind()));
                            break;
                        }
                        case SUBCOMPONENT_BUILDER: 
                        case PRODUCTION_SUBCOMPONENT_BUILDER: {
                            subcomponentsByBuilderMethod.put((Object)componentMethodDescriptor, (Object)this.create(MoreElements.asType(MoreTypes.asElement(resolvedMethod.getReturnType()).getEnclosingElement()), componentMethodDescriptor.kind().componentKind()));
                            break;
                        }
                    }
                }
            }
            Optional<ComponentCreatorDescriptor> creatorDescriptor = (enclosedCreators = kind.builderAnnotation().map(builderAnnotation -> ConfigurationAnnotations.enclosedAnnotatedTypes(typeElement, builderAnnotation)).orElse(ImmutableList.of())).isEmpty() ? Optional.empty() : Optional.of(ComponentCreatorDescriptor.create((DeclaredType)Iterables.getOnlyElement((Iterable)enclosedCreators), this.elements, this.types, this.dependencyRequestFactory));
            ImmutableSet scopes = Scopes.scopesOf(typeElement);
            if (kind.isProducer()) {
                scopes = ImmutableSet.builder().addAll(scopes).add((Object)Scopes.productionScope(this.elements)).build();
            }
            return new AutoValue_ComponentDescriptor(kind, componentAnnotation, typeElement, componentDependencies, transitiveModules, (ImmutableMap<ExecutableElement, ComponentRequirement>)dependenciesByDependencyMethod.build(), (ImmutableSet<Scope>)scopes, (ImmutableSet<ComponentDescriptor>)subcomponentsFromModules.build(), (ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByFactoryMethod.build(), (ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByBuilderMethod.build(), (ImmutableSet<ComponentMethodDescriptor>)componentMethodsBuilder.build(), creatorDescriptor);
        }

        private ComponentMethodDescriptor getDescriptorForComponentMethod(TypeElement componentElement, ComponentKind componentKind, ExecutableElement componentMethod) {
            ExecutableType resolvedComponentMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(componentElement.asType()), componentMethod));
            TypeMirror returnType = resolvedComponentMethod.getReturnType();
            if (returnType.getKind().equals((Object)TypeKind.DECLARED)) {
                if (MoreTypes.isTypeOf(Provider.class, returnType) || MoreTypes.isTypeOf(Lazy.class, returnType)) {
                    return ComponentMethodDescriptor.forProvision(componentMethod, this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                }
                if (!InjectionAnnotations.getQualifier(componentMethod).isPresent()) {
                    Element returnTypeElement = MoreTypes.asElement(returnType);
                    if (ConfigurationAnnotations.isSubcomponent(returnTypeElement)) {
                        return ComponentMethodDescriptor.forSubcomponent(MoreElements.isAnnotationPresent(returnTypeElement, Subcomponent.class) ? ComponentMethodKind.SUBCOMPONENT : ComponentMethodKind.PRODUCTION_SUBCOMPONENT, componentMethod);
                    }
                    if (ConfigurationAnnotations.isSubcomponentCreator(returnTypeElement)) {
                        DependencyRequest dependencyRequest = this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod);
                        return ComponentMethodDescriptor.forSubcomponentCreator(MoreElements.isAnnotationPresent(returnTypeElement, Subcomponent.Builder.class) ? ComponentMethodKind.SUBCOMPONENT_BUILDER : ComponentMethodKind.PRODUCTION_SUBCOMPONENT_BUILDER, dependencyRequest, componentMethod);
                    }
                }
            }
            if (componentMethod.getParameters().isEmpty() && !componentMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                switch (componentKind) {
                    case COMPONENT: 
                    case SUBCOMPONENT: {
                        return ComponentMethodDescriptor.forProvision(componentMethod, this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                    }
                    case PRODUCTION_COMPONENT: 
                    case PRODUCTION_SUBCOMPONENT: {
                        return ComponentMethodDescriptor.forProvision(componentMethod, this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, resolvedComponentMethod));
                    }
                }
                throw new AssertionError();
            }
            List<? extends TypeMirror> parameterTypes = resolvedComponentMethod.getParameterTypes();
            if (parameterTypes.size() == 1 && (returnType.getKind().equals((Object)TypeKind.VOID) || MoreTypes.equivalence().equivalent((Object)returnType, (Object)parameterTypes.get(0)))) {
                return ComponentMethodDescriptor.forMembersInjection(componentMethod, this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod));
            }
            throw new IllegalArgumentException("not a valid component method: " + componentMethod);
        }
    }

    static enum ComponentMethodKind {
        PROVISION,
        PRODUCTION,
        MEMBERS_INJECTION,
        SUBCOMPONENT,
        SUBCOMPONENT_BUILDER,
        PRODUCTION_SUBCOMPONENT,
        PRODUCTION_SUBCOMPONENT_BUILDER;


        ComponentKind componentKind() {
            switch (this) {
                case SUBCOMPONENT: 
                case SUBCOMPONENT_BUILDER: {
                    return ComponentKind.SUBCOMPONENT;
                }
                case PRODUCTION_SUBCOMPONENT: 
                case PRODUCTION_SUBCOMPONENT_BUILDER: {
                    return ComponentKind.PRODUCTION_SUBCOMPONENT;
                }
            }
            throw new IllegalStateException("no component associated with method " + (Object)((Object)this));
        }
    }

    @AutoValue
    static abstract class ComponentMethodDescriptor {
        ComponentMethodDescriptor() {
        }

        abstract ComponentMethodKind kind();

        abstract Optional<DependencyRequest> dependencyRequest();

        abstract ExecutableElement methodElement();

        static ComponentMethodDescriptor create(ComponentMethodKind kind, Optional<DependencyRequest> dependencyRequest, ExecutableElement methodElement) {
            return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(kind, dependencyRequest, methodElement);
        }

        static ComponentMethodDescriptor forProvision(ExecutableElement methodElement, DependencyRequest dependencyRequest) {
            return ComponentMethodDescriptor.create(ComponentMethodKind.PROVISION, Optional.of(dependencyRequest), methodElement);
        }

        static ComponentMethodDescriptor forMembersInjection(ExecutableElement methodElement, DependencyRequest dependencyRequest) {
            return ComponentMethodDescriptor.create(ComponentMethodKind.MEMBERS_INJECTION, Optional.of(dependencyRequest), methodElement);
        }

        static ComponentMethodDescriptor forSubcomponent(ComponentMethodKind kind, ExecutableElement methodElement) {
            return ComponentMethodDescriptor.create(kind, Optional.empty(), methodElement);
        }

        static ComponentMethodDescriptor forSubcomponentCreator(ComponentMethodKind kind, DependencyRequest dependencyRequestForBuilder, ExecutableElement methodElement) {
            return ComponentMethodDescriptor.create(kind, Optional.of(dependencyRequestForBuilder), methodElement);
        }

        TypeMirror resolvedReturnType(DaggerTypes types) {
            Preconditions.checkState((boolean)this.dependencyRequest().isPresent());
            TypeMirror returnType = this.methodElement().getReturnType();
            if (returnType.getKind().isPrimitive() || returnType.getKind().equals((Object)TypeKind.VOID)) {
                return returnType;
            }
            return BindingRequest.bindingRequest(this.dependencyRequest().get()).requestedType(this.dependencyRequest().get().key().type(), types);
        }
    }
}

