/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentCreatorDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.TypeSpecs;
import dagger.internal.codegen.UniqueNameSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ComponentCreatorImplementation {
    private final TypeSpec componentCreatorClass;
    private final ClassName name;
    private final ImmutableMap<ComponentRequirement, FieldSpec> builderFields;

    private ComponentCreatorImplementation(TypeSpec componentCreatorClass, ClassName name, ImmutableMap<ComponentRequirement, FieldSpec> builderFields) {
        this.componentCreatorClass = componentCreatorClass;
        this.name = name;
        this.builderFields = builderFields;
    }

    TypeSpec componentCreatorClass() {
        return this.componentCreatorClass;
    }

    ClassName name() {
        return this.name;
    }

    ImmutableMap<ComponentRequirement, FieldSpec> builderFields() {
        return this.builderFields;
    }

    static Optional<ComponentCreatorImplementation> create(ComponentImplementation componentImplementation, BindingGraph graph, Elements elements, Types types) {
        if (componentImplementation.superclassImplementation().isPresent() && componentImplementation.isAbstract()) {
            return Optional.empty();
        }
        return graph.componentDescriptor().hasCreator() ? Optional.of(new CreatorImplementationFactory(componentImplementation, graph, elements, types).create()) : Optional.empty();
    }

    private static final class CreatorImplementationFactory {
        static final String NOOP_BUILDER_METHOD_JAVADOC = "This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://google.github.io/dagger/unused-modules.\n";
        final BindingGraph graph;
        final TypeSpec.Builder componentCreatorClass;
        final ComponentImplementation componentImplementation;
        final Elements elements;
        final Types types;

        CreatorImplementationFactory(ComponentImplementation componentImplementation, BindingGraph graph, Elements elements, Types types) {
            this.componentImplementation = componentImplementation;
            this.componentCreatorClass = TypeSpec.classBuilder((ClassName)componentImplementation.getCreatorName());
            this.graph = graph;
            this.elements = elements;
            this.types = types;
        }

        ComponentCreatorImplementation create() {
            if (!this.componentImplementation.isNested()) {
                this.componentCreatorClass.addModifiers(new Modifier[]{Modifier.STATIC});
            }
            if (this.creatorDescriptor().isPresent()) {
                if (this.componentImplementation.isAbstract()) {
                    this.componentCreatorClass.addModifiers(new Modifier[]{this.componentImplementation.isNested() ? Modifier.PROTECTED : Modifier.PUBLIC});
                } else {
                    this.componentCreatorClass.addModifiers(new Modifier[]{Modifier.PRIVATE});
                }
                this.setSupertype();
            } else {
                this.componentCreatorClass.addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
            }
            ImmutableMap<ComponentRequirement, FieldSpec> builderFields = this.builderFields();
            if (this.componentImplementation.isAbstract()) {
                this.componentCreatorClass.addModifiers(new Modifier[]{Modifier.ABSTRACT});
            } else {
                this.componentCreatorClass.addModifiers(new Modifier[]{Modifier.FINAL});
                this.componentCreatorClass.addMethod(this.factoryMethod(builderFields));
            }
            if (!this.componentImplementation.baseImplementation().isPresent()) {
                this.componentCreatorClass.addFields((Iterable)builderFields.values());
            }
            this.componentCreatorClass.addMethods(this.builderMethods(builderFields));
            return new ComponentCreatorImplementation(this.componentCreatorClass.build(), this.componentImplementation.getCreatorName(), builderFields);
        }

        void setSupertype() {
            if (this.componentImplementation.baseImplementation().isPresent()) {
                this.componentCreatorClass.superclass((TypeName)this.componentImplementation.baseImplementation().get().getCreatorName());
            } else {
                TypeSpecs.addSupertype(this.componentCreatorClass, this.creatorDescriptor().get().typeElement());
            }
        }

        ImmutableMap<ComponentRequirement, FieldSpec> builderFields() {
            UniqueNameSet fieldNames = new UniqueNameSet();
            ImmutableMap.Builder builderFields = ImmutableMap.builder();
            Modifier modifier = this.componentImplementation.isAbstract() ? Modifier.PUBLIC : Modifier.PRIVATE;
            for (ComponentRequirement componentRequirement : this.componentRequirements()) {
                String name = fieldNames.getUniqueName(componentRequirement.variableName());
                builderFields.put((Object)componentRequirement, (Object)FieldSpec.builder((TypeName)TypeName.get((TypeMirror)componentRequirement.type()), (String)name, (Modifier[])new Modifier[]{modifier}).build());
            }
            return builderFields.build();
        }

        MethodSpec factoryMethod(ImmutableMap<ComponentRequirement, FieldSpec> builderFields) {
            MethodSpec.Builder factoryMethod;
            if (this.creatorDescriptor().isPresent()) {
                ExecutableElement factoryMethodElement = this.creatorDescriptor().get().factoryMethod();
                factoryMethod = MethodSpec.methodBuilder((String)factoryMethodElement.getSimpleName().toString()).addAnnotation(Override.class);
            } else {
                factoryMethod = MethodSpec.methodBuilder((String)"build");
            }
            factoryMethod.returns((TypeName)ClassName.get((TypeElement)this.graph.componentTypeElement())).addModifiers(new Modifier[]{Modifier.PUBLIC});
            builderFields.forEach((requirement, field) -> {
                switch (requirement.nullPolicy(this.elements, this.types)) {
                    case NEW: {
                        factoryMethod.beginControlFlow("if ($N == null)", new Object[]{field}).addStatement("this.$N = new $T()", new Object[]{field, field.type}).endControlFlow();
                        break;
                    }
                    case THROW: {
                        factoryMethod.addStatement("$T.checkBuilderRequirement($N, $T.class)", new Object[]{Preconditions.class, field, TypeNames.rawTypeName(field.type)});
                        break;
                    }
                    case ALLOW: {
                        break;
                    }
                    default: {
                        throw new AssertionError(requirement);
                    }
                }
            });
            factoryMethod.addStatement("return new $T(this)", new Object[]{this.componentImplementation.name()});
            return factoryMethod.build();
        }

        ImmutableSet<MethodSpec> builderMethods(ImmutableMap<ComponentRequirement, FieldSpec> builderFields) {
            ImmutableSet<ComponentRequirement> componentRequirements = this.componentRequirements();
            ImmutableSet.Builder methods = ImmutableSet.builder();
            if (this.creatorDescriptor().isPresent()) {
                boolean hasBaseCreatorImplementation = !this.componentImplementation.isAbstract() && this.componentImplementation.baseImplementation().isPresent();
                UniqueNameSet parameterNames = new UniqueNameSet();
                ComponentCreatorDescriptor creatorDescriptor = this.creatorDescriptor().get();
                for (ComponentRequirement requirement : creatorDescriptor.requirements()) {
                    ExecutableElement method = creatorDescriptor.elementForRequirement(requirement);
                    MethodSpec.Builder builderMethod = this.addBuilderMethodFromSpec(method);
                    VariableElement parameterElement = (VariableElement)Iterables.getOnlyElement(method.getParameters());
                    String parameterName = parameterNames.getUniqueName(parameterElement.getSimpleName());
                    TypeName argType = parameterElement.asType().getKind().isPrimitive() ? TypeName.get((TypeMirror)parameterElement.asType()) : TypeName.get((TypeMirror)requirement.type());
                    builderMethod.addParameter(argType, parameterName, new Modifier[0]);
                    if (componentRequirements.contains((Object)requirement)) {
                        if (hasBaseCreatorImplementation) continue;
                        builderMethod.addStatement("this.$N = $L", new Object[]{builderFields.get((Object)requirement), requirement.nullPolicy(this.elements, this.types).equals((Object)ComponentRequirement.NullPolicy.ALLOW) ? parameterName : CodeBlock.of((String)"$T.checkNotNull($L)", (Object[])new Object[]{Preconditions.class, parameterName})});
                        CreatorImplementationFactory.addBuilderMethodReturnStatementForSpec(method, builderMethod);
                    } else if (this.graph.ownedModuleTypes().contains((Object)requirement.typeElement())) {
                        if (hasBaseCreatorImplementation) continue;
                        builderMethod.addJavadoc(NOOP_BUILDER_METHOD_JAVADOC, new Object[0]);
                        CreatorImplementationFactory.addBuilderMethodReturnStatementForSpec(method, builderMethod);
                    } else {
                        builderMethod.addStatement("throw new $T($T.format($S, $T.class.getCanonicalName()))", new Object[]{UnsupportedOperationException.class, String.class, "%s cannot be set because it is inherited from the enclosing component", TypeNames.rawTypeName(TypeName.get((TypeMirror)requirement.type()))});
                    }
                    methods.add((Object)builderMethod.build());
                }
            } else {
                for (ComponentRequirement requirement : this.graph.componentDescriptor().dependenciesAndConcreteModules()) {
                    String componentRequirementName = SourceFiles.simpleVariableName(requirement.typeElement());
                    MethodSpec.Builder builderMethod = MethodSpec.methodBuilder((String)componentRequirementName).returns((TypeName)this.componentImplementation.getCreatorName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)requirement.type()), componentRequirementName, new Modifier[0]);
                    if (componentRequirements.contains((Object)requirement)) {
                        builderMethod.addStatement("this.$N = $T.checkNotNull($L)", new Object[]{builderFields.get((Object)requirement), Preconditions.class, componentRequirementName});
                    } else {
                        builderMethod.addStatement("$T.checkNotNull($L)", new Object[]{Preconditions.class, componentRequirementName});
                        builderMethod.addJavadoc("@deprecated This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://google.github.io/dagger/unused-modules.\n", new Object[0]);
                        builderMethod.addAnnotation(Deprecated.class);
                    }
                    builderMethod.addStatement("return this", new Object[0]);
                    methods.add((Object)builderMethod.build());
                }
            }
            return methods.build();
        }

        private ImmutableSet<ComponentRequirement> componentRequirements() {
            return !this.componentImplementation.superclassImplementation().isPresent() && this.componentImplementation.isAbstract() ? this.graph.possiblyNecessaryRequirements() : this.graph.componentRequirements();
        }

        MethodSpec.Builder addBuilderMethodFromSpec(ExecutableElement method) {
            TypeMirror returnType = method.getReturnType();
            MethodSpec.Builder builderMethod = MethodSpec.methodBuilder((String)method.getSimpleName().toString()).addAnnotation(Override.class).addModifiers((Iterable)Sets.difference(method.getModifiers(), (Set)ImmutableSet.of((Object)((Object)Modifier.ABSTRACT))));
            if (!returnType.getKind().equals((Object)TypeKind.VOID)) {
                builderMethod.returns((TypeName)this.componentImplementation.getCreatorName());
            }
            return builderMethod;
        }

        static void addBuilderMethodReturnStatementForSpec(ExecutableElement specMethod, MethodSpec.Builder builderMethod) {
            if (!specMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                builderMethod.addStatement("return this", new Object[0]);
            }
        }

        Optional<ComponentCreatorDescriptor> creatorDescriptor() {
            return this.graph.componentDescriptor().creatorDescriptor();
        }
    }
}

