/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingType;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.shaded.auto.common.MoreElements;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

abstract class MembersInjectionBinding
extends Binding {
    MembersInjectionBinding() {
    }

    public Optional<TypeElement> bindingElement() {
        return Optional.of(this.membersInjectedType());
    }

    abstract TypeElement membersInjectedType();

    abstract Optional<MembersInjectionBinding> unresolved();

    @Override
    public Optional<TypeElement> contributingModule() {
        return Optional.empty();
    }

    abstract ImmutableSortedSet<InjectionSite> injectionSites();

    @Override
    BindingType bindingType() {
        return BindingType.MEMBERS_INJECTION;
    }

    public BindingKind kind() {
        return BindingKind.MEMBERS_INJECTION;
    }

    public boolean isNullable() {
        return false;
    }

    boolean hasLocalInjectionSites() {
        return this.injectionSites().stream().anyMatch(injectionSite -> injectionSite.element().getEnclosingElement().equals(this.membersInjectedType()));
    }

    public final boolean isProduction() {
        return false;
    }

    static abstract class InjectionSite {
        InjectionSite() {
        }

        abstract Kind kind();

        abstract Element element();

        abstract ImmutableSet<DependencyRequest> dependencies();

        int indexAmongSiblingMembers() {
            return this.element().getEnclosingElement().getEnclosedElements().indexOf(this.element());
        }

        int indexAmongAtInjectMembersWithSameSimpleName() {
            return this.element().getEnclosingElement().getEnclosedElements().stream().filter(element -> MoreElements.isAnnotationPresent(element, Inject.class)).filter(element -> !element.getModifiers().contains((Object)Modifier.PRIVATE)).filter(element -> element.getSimpleName().equals(this.element().getSimpleName())).collect(Collectors.toList()).indexOf(this.element());
        }

        static enum Kind {
            FIELD,
            METHOD;

        }
    }
}

