/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.Preconditions;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentBuilder;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementField;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MemberSelect;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class ComponentRequirementFields {
    private final Optional<ComponentRequirementFields> parent;
    private final Map<ComponentRequirement, ComponentRequirementField> componentRequirementFields = new HashMap<ComponentRequirement, ComponentRequirementField>();
    private final BindingGraph graph;
    private final GeneratedComponentModel generatedComponentModel;
    private final Optional<ComponentBuilder> componentBuilder;

    private ComponentRequirementFields(Optional<ComponentRequirementFields> parent, BindingGraph graph, GeneratedComponentModel generatedComponentModel, Optional<ComponentBuilder> componentBuilder) {
        this.parent = parent;
        this.graph = graph;
        this.generatedComponentModel = generatedComponentModel;
        this.componentBuilder = componentBuilder;
    }

    ComponentRequirementFields(BindingGraph graph, GeneratedComponentModel generatedComponentModel, Optional<ComponentBuilder> componentBuilder) {
        this(Optional.empty(), graph, generatedComponentModel, componentBuilder);
    }

    ComponentRequirementFields forChildComponent(BindingGraph graph, GeneratedComponentModel generatedComponentModel, Optional<ComponentBuilder> componentBuilder) {
        return new ComponentRequirementFields(Optional.of(this), graph, generatedComponentModel, componentBuilder);
    }

    CodeBlock getExpression(ComponentRequirement componentRequirement, ClassName requestingClass) {
        return this.getField(componentRequirement).getExpression(requestingClass);
    }

    CodeBlock getExpressionDuringInitialization(ComponentRequirement componentRequirement, ClassName requestingClass) {
        return this.getField(componentRequirement).getExpressionDuringInitialization(requestingClass);
    }

    ComponentRequirementField getField(ComponentRequirement componentRequirement) {
        if (this.graph.componentRequirements().contains((Object)componentRequirement)) {
            return this.componentRequirementFields.computeIfAbsent(componentRequirement, this::create);
        }
        if (this.parent.isPresent()) {
            return this.parent.get().getField(componentRequirement);
        }
        throw new IllegalStateException("no component requirement field found for " + componentRequirement);
    }

    private ComponentRequirementField create(ComponentRequirement requirement) {
        if (this.componentBuilder.isPresent()) {
            FieldSpec builderField = (FieldSpec)this.componentBuilder.get().builderFields().get((Object)requirement);
            return new BuilderField(requirement, this.generatedComponentModel, builderField);
        }
        if (this.graph.factoryMethodParameters().containsKey((Object)requirement)) {
            ParameterSpec factoryParameter = ParameterSpec.get((VariableElement)((VariableElement)this.graph.factoryMethodParameters().get((Object)requirement)));
            return new ComponentParameterField(requirement, this.generatedComponentModel, factoryParameter);
        }
        if (this.graph.componentRequirements().contains((Object)requirement)) {
            return new ComponentInstantiableField(requirement, this.generatedComponentModel);
        }
        throw new AssertionError();
    }

    private static final class ComponentParameterField
    extends AbstractField {
        private final ParameterSpec factoryParameter;

        private ComponentParameterField(ComponentRequirement componentRequirement, GeneratedComponentModel generatedComponentModel, ParameterSpec factoryParameter) {
            super(componentRequirement, generatedComponentModel);
            this.factoryParameter = (ParameterSpec)com.google.common.base.Preconditions.checkNotNull((Object)factoryParameter);
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = $T.checkNotNull($N);", (Object[])new Object[]{componentField, Preconditions.class, this.factoryParameter});
        }
    }

    private static final class ComponentInstantiableField
    extends AbstractField {
        private ComponentInstantiableField(ComponentRequirement componentRequirement, GeneratedComponentModel generatedComponentModel) {
            super(componentRequirement, generatedComponentModel);
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = new $T();", (Object[])new Object[]{componentField, componentField.type});
        }
    }

    private static final class BuilderField
    extends AbstractField {
        private final FieldSpec builderField;

        private BuilderField(ComponentRequirement componentRequirement, GeneratedComponentModel generatedComponentModel, FieldSpec builderField) {
            super(componentRequirement, generatedComponentModel);
            this.builderField = (FieldSpec)com.google.common.base.Preconditions.checkNotNull((Object)builderField);
        }

        @Override
        public CodeBlock getExpressionDuringInitialization(ClassName requestingClass) {
            if (((AbstractField)this).generatedComponentModel.name().equals((Object)requestingClass)) {
                return CodeBlock.of((String)"builder.$N", (Object[])new Object[]{this.builderField});
            }
            return this.getExpression(requestingClass);
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = builder.$N;", (Object[])new Object[]{componentField, this.builderField});
        }
    }

    private static abstract class AbstractField
    implements ComponentRequirementField {
        private final ComponentRequirement componentRequirement;
        private final GeneratedComponentModel generatedComponentModel;
        private final Supplier<MemberSelect> field = Suppliers.memoize(this::createField);

        private AbstractField(ComponentRequirement componentRequirement, GeneratedComponentModel generatedComponentModel) {
            this.componentRequirement = (ComponentRequirement)com.google.common.base.Preconditions.checkNotNull((Object)componentRequirement);
            this.generatedComponentModel = (GeneratedComponentModel)com.google.common.base.Preconditions.checkNotNull((Object)generatedComponentModel);
        }

        @Override
        public CodeBlock getExpression(ClassName requestingClass) {
            return ((MemberSelect)this.field.get()).getExpressionFor(requestingClass);
        }

        @Override
        public CodeBlock getExpressionDuringInitialization(ClassName requestingClass) {
            return this.getExpression(requestingClass);
        }

        private MemberSelect createField() {
            String fieldName = this.generatedComponentModel.getUniqueFieldName(this.componentRequirement.variableName());
            FieldSpec field = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)this.componentRequirement.type()), (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
            this.generatedComponentModel.addField(GeneratedComponentModel.FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, field);
            this.generatedComponentModel.addInitialization(this.fieldInitialization(field));
            return MemberSelect.localField(this.generatedComponentModel.name(), fieldName);
        }

        abstract CodeBlock fieldInitialization(FieldSpec var1);
    }
}

