/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.Module;
import dagger.android.ContributesAndroidInjector;
import dagger.android.processor.AutoValue_AndroidInjectorDescriptor;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoValue
abstract class AndroidInjectorDescriptor {
    AndroidInjectorDescriptor() {
    }

    abstract ClassName injectedType();

    abstract ImmutableSet<AnnotationSpec> scopes();

    abstract ImmutableSet<ClassName> modules();

    abstract ClassName enclosingModule();

    abstract ExecutableElement method();

    private static final class AllTypesVisitor
    extends SimpleAnnotationValueVisitor8<ImmutableSet<TypeMirror>, Void> {
        private AllTypesVisitor() {
        }

        @Override
        public ImmutableSet<TypeMirror> visitArray(List<? extends AnnotationValue> values, Void aVoid) {
            return ImmutableSet.copyOf((Collection)values.stream().flatMap(v -> v.accept(this, null).stream()).collect(Collectors.toList()));
        }

        @Override
        public ImmutableSet<TypeMirror> visitType(TypeMirror a, Void aVoid) {
            return ImmutableSet.of((Object)a);
        }

        @Override
        protected ImmutableSet<TypeMirror> defaultAction(Object o, Void aVoid) {
            throw new AssertionError(o);
        }
    }

    static final class Validator {
        private final Types types;
        private final Elements elements;
        private final Messager messager;

        Validator(Types types, Elements elements, Messager messager) {
            this.types = types;
            this.elements = elements;
            this.messager = messager;
        }

        Optional<AndroidInjectorDescriptor> createIfValid(ExecutableElement method) {
            ErrorReporter reporter = new ErrorReporter(method, this.messager);
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                reporter.reportError("@ContributesAndroidInjector methods must be abstract");
            }
            if (!method.getParameters().isEmpty()) {
                reporter.reportError("@ContributesAndroidInjector methods cannot have parameters");
            }
            Builder builder = new AutoValue_AndroidInjectorDescriptor.Builder().method(method);
            TypeElement enclosingElement = MoreElements.asType(method.getEnclosingElement());
            if (!MoreElements.isAnnotationPresent(enclosingElement, Module.class)) {
                reporter.reportError("@ContributesAndroidInjector methods must be in a @Module");
            }
            builder.enclosingModule(ClassName.get((TypeElement)enclosingElement));
            TypeMirror injectedType = method.getReturnType();
            if (MoreTypes.asDeclared(injectedType).getTypeArguments().isEmpty()) {
                builder.injectedType(ClassName.get((TypeElement)MoreTypes.asTypeElement(injectedType)));
            } else {
                reporter.reportError("@ContributesAndroidInjector methods cannot return parameterized types");
            }
            AnnotationMirror annotation = (AnnotationMirror)MoreElements.getAnnotationMirror(method, ContributesAndroidInjector.class).get();
            for (TypeMirror module : AnnotationMirrors.getAnnotationValue(annotation, "modules").accept(new AllTypesVisitor(), null)) {
                if (MoreElements.isAnnotationPresent(MoreTypes.asElement(module), Module.class)) {
                    builder.modulesBuilder().add((Object)((ClassName)TypeName.get((TypeMirror)module)));
                    continue;
                }
                reporter.reportError(String.format("%s is not a @Module", module), annotation);
            }
            for (AnnotationMirror scope : AnnotationMirrors.getAnnotatedAnnotations(method, Scope.class)) {
                builder.scopesBuilder().add((Object)AnnotationSpec.get((AnnotationMirror)scope));
            }
            for (AnnotationMirror qualifier : AnnotationMirrors.getAnnotatedAnnotations(method, Qualifier.class)) {
                reporter.reportError("@ContributesAndroidInjector methods cannot have qualifiers", qualifier);
            }
            return reporter.hasError ? Optional.empty() : Optional.of(builder.build());
        }

        private static class ErrorReporter {
            private final Element subject;
            private final Messager messager;
            private boolean hasError;

            ErrorReporter(Element subject, Messager messager) {
                this.subject = subject;
                this.messager = messager;
            }

            void reportError(String error) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, error, this.subject);
            }

            void reportError(String error, AnnotationMirror annotation) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, error, this.subject, annotation);
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder injectedType(ClassName var1);

        abstract ImmutableSet.Builder<AnnotationSpec> scopesBuilder();

        abstract ImmutableSet.Builder<ClassName> modulesBuilder();

        abstract Builder enclosingModule(ClassName var1);

        abstract Builder method(ExecutableElement var1);

        abstract AndroidInjectorDescriptor build();
    }
}

