/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import android.util.Log;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.Nullable;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.BinaryKeysetReader;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetManager;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.LegacyKeysetSerialization;
import com.google.crypto.tink.TinkProtoParametersFormat;
import com.google.crypto.tink.integration.android.AndroidKeystoreKmsClient;
import com.google.crypto.tink.integration.android.SharedPrefKeysetWriter;
import com.google.crypto.tink.subtle.Hex;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.InlineMe;
import java.io.CharConversionException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.ProviderException;
import javax.annotation.concurrent.GuardedBy;

public final class AndroidKeysetManager {
    private static final Object lock = new Object();
    private static final String TAG = AndroidKeysetManager.class.getSimpleName();
    private final KeysetWriter writer;
    private final Aead masterAead;
    @GuardedBy(value="this")
    private KeysetManager keysetManager;

    private AndroidKeysetManager(Builder builder) {
        this.writer = new SharedPrefKeysetWriter(builder.context, builder.keysetName, builder.prefFileName);
        this.masterAead = builder.masterAead;
        this.keysetManager = builder.keysetManager;
    }

    public synchronized KeysetHandle getKeysetHandle() throws GeneralSecurityException {
        return this.keysetManager.getKeysetHandle();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public synchronized AndroidKeysetManager rotate(com.google.crypto.tink.proto.KeyTemplate keyTemplate) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.rotate(keyTemplate);
        AndroidKeysetManager.write(this.keysetManager.getKeysetHandle(), this.writer, this.masterAead);
        return this;
    }

    @CanIgnoreReturnValue
    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager add(com.google.crypto.tink.proto.KeyTemplate keyTemplate) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.add(keyTemplate);
        AndroidKeysetManager.write(this.keysetManager.getKeysetHandle(), this.writer, this.masterAead);
        return this;
    }

    @CanIgnoreReturnValue
    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager add(KeyTemplate keyTemplate) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.add(keyTemplate);
        AndroidKeysetManager.write(this.keysetManager.getKeysetHandle(), this.writer, this.masterAead);
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized AndroidKeysetManager setPrimary(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.setPrimary(keyId);
        AndroidKeysetManager.write(this.keysetManager.getKeysetHandle(), this.writer, this.masterAead);
        return this;
    }

    @Deprecated
    @InlineMe(replacement="this.setPrimary(keyId)")
    @CanIgnoreReturnValue
    public synchronized AndroidKeysetManager promote(int keyId) throws GeneralSecurityException {
        return this.setPrimary(keyId);
    }

    @CanIgnoreReturnValue
    public synchronized AndroidKeysetManager enable(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.enable(keyId);
        AndroidKeysetManager.write(this.keysetManager.getKeysetHandle(), this.writer, this.masterAead);
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized AndroidKeysetManager disable(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.disable(keyId);
        AndroidKeysetManager.write(this.keysetManager.getKeysetHandle(), this.writer, this.masterAead);
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized AndroidKeysetManager delete(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.delete(keyId);
        AndroidKeysetManager.write(this.keysetManager.getKeysetHandle(), this.writer, this.masterAead);
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized AndroidKeysetManager destroy(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.destroy(keyId);
        AndroidKeysetManager.write(this.keysetManager.getKeysetHandle(), this.writer, this.masterAead);
        return this;
    }

    public synchronized boolean isUsingKeystore() {
        return this.masterAead != null;
    }

    private static void write(KeysetHandle handle, KeysetWriter writer, Aead masterAead) throws GeneralSecurityException {
        try {
            if (masterAead != null) {
                LegacyKeysetSerialization.serializeEncryptedKeyset(handle, writer, masterAead, new byte[0]);
            } else {
                LegacyKeysetSerialization.serializeKeyset(handle, writer, InsecureSecretKeyAccess.get());
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    @ChecksSdkIntAtLeast(api=23)
    private static boolean isAtLeastM() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static final class Builder {
        private Context context = null;
        private String keysetName = null;
        private String prefFileName = null;
        private String masterKeyUri = null;
        private Aead masterAead = null;
        private boolean useKeystore = true;
        private KeyTemplate keyTemplate = null;
        private com.google.crypto.tink.proto.KeyTemplate keyTemplateProto = null;
        @GuardedBy(value="this")
        private KeysetManager keysetManager;

        @CanIgnoreReturnValue
        public Builder withSharedPref(Context context, String keysetName, String prefFileName) throws IOException {
            if (context == null) {
                throw new IllegalArgumentException("need an Android context");
            }
            if (keysetName == null) {
                throw new IllegalArgumentException("need a keyset name");
            }
            this.context = context;
            this.keysetName = keysetName;
            this.prefFileName = prefFileName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withMasterKeyUri(String val) {
            if (!val.startsWith("android-keystore://")) {
                throw new IllegalArgumentException("key URI must start with android-keystore://");
            }
            if (!this.useKeystore) {
                throw new IllegalArgumentException("cannot call withMasterKeyUri() after calling doNotUseKeystore()");
            }
            this.masterKeyUri = val;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withKeyTemplate(com.google.crypto.tink.proto.KeyTemplate val) {
            this.keyTemplateProto = val;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withKeyTemplate(KeyTemplate val) {
            this.keyTemplate = val;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder doNotUseKeystore() {
            this.masterKeyUri = null;
            this.useKeystore = false;
            return this;
        }

        @Nullable
        private static byte[] readKeysetFromPrefs(Context context, String keysetName, String prefFileName) throws IOException {
            if (keysetName == null) {
                throw new IllegalArgumentException("keysetName cannot be null");
            }
            Context appContext = context.getApplicationContext();
            SharedPreferences sharedPreferences = prefFileName == null ? PreferenceManager.getDefaultSharedPreferences((Context)appContext) : appContext.getSharedPreferences(prefFileName, 0);
            try {
                String keysetHex = sharedPreferences.getString(keysetName, null);
                if (keysetHex == null) {
                    return null;
                }
                return Hex.decode(keysetHex);
            }
            catch (ClassCastException | IllegalArgumentException ex) {
                throw new CharConversionException(String.format("can't read keyset; the pref value %s is not a valid hex string", keysetName));
            }
        }

        private KeysetManager readKeysetInCleartext(byte[] serializedKeyset) throws GeneralSecurityException, IOException {
            return KeysetManager.withKeysetHandle(LegacyKeysetSerialization.parseKeyset(BinaryKeysetReader.withBytes(serializedKeyset), InsecureSecretKeyAccess.get()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized AndroidKeysetManager build() throws GeneralSecurityException, IOException {
            if (this.keysetName == null) {
                throw new IllegalArgumentException("keysetName cannot be null");
            }
            if (this.keyTemplateProto != null && this.keyTemplate == null) {
                this.keyTemplate = KeyTemplate.createFrom(TinkProtoParametersFormat.parse(this.keyTemplateProto.toByteArray()));
            }
            Object object = lock;
            synchronized (object) {
                byte[] serializedKeyset = Builder.readKeysetFromPrefs(this.context, this.keysetName, this.prefFileName);
                if (serializedKeyset == null) {
                    if (this.masterKeyUri != null) {
                        this.masterAead = this.readOrGenerateNewMasterKey();
                    }
                    this.keysetManager = this.generateKeysetAndWriteToPrefs();
                } else {
                    this.keysetManager = this.masterKeyUri == null || !AndroidKeysetManager.isAtLeastM() ? this.readKeysetInCleartext(serializedKeyset) : this.readMasterkeyDecryptAndParseKeyset(serializedKeyset);
                }
                return new AndroidKeysetManager(this);
            }
        }

        @Nullable
        private Aead readOrGenerateNewMasterKey() throws GeneralSecurityException {
            boolean generated;
            if (!AndroidKeysetManager.isAtLeastM()) {
                Log.w((String)TAG, (String)"Android Keystore requires at least Android M");
                return null;
            }
            AndroidKeystoreKmsClient client = new AndroidKeystoreKmsClient();
            try {
                generated = AndroidKeystoreKmsClient.generateKeyIfNotExist(this.masterKeyUri);
            }
            catch (GeneralSecurityException | ProviderException ex) {
                Log.w((String)TAG, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)ex);
                return null;
            }
            try {
                return client.getAead(this.masterKeyUri);
            }
            catch (GeneralSecurityException | ProviderException ex) {
                if (!generated) {
                    throw new KeyStoreException(String.format("the master key %s exists but is unusable", this.masterKeyUri), ex);
                }
                Log.w((String)TAG, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)ex);
                return null;
            }
        }

        private KeysetManager generateKeysetAndWriteToPrefs() throws GeneralSecurityException, IOException {
            if (this.keyTemplate == null) {
                throw new GeneralSecurityException("cannot read or generate keyset");
            }
            KeysetHandle keysetHandle = KeysetHandle.generateNew(this.keyTemplate);
            SharedPrefKeysetWriter writer = new SharedPrefKeysetWriter(this.context, this.keysetName, this.prefFileName);
            AndroidKeysetManager.write(keysetHandle, writer, this.masterAead);
            return KeysetManager.withKeysetHandle(keysetHandle);
        }

        private KeysetManager readMasterkeyDecryptAndParseKeyset(byte[] serializedKeyset) throws GeneralSecurityException, IOException {
            try {
                this.masterAead = new AndroidKeystoreKmsClient().getAead(this.masterKeyUri);
            }
            catch (GeneralSecurityException | ProviderException keystoreException) {
                try {
                    KeysetManager manager = this.readKeysetInCleartext(serializedKeyset);
                    Log.w((String)TAG, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)keystoreException);
                    return manager;
                }
                catch (IOException unused) {
                    throw keystoreException;
                }
            }
            try {
                byte[] emptyAssociatedData = new byte[]{};
                return KeysetManager.withKeysetHandle(LegacyKeysetSerialization.parseEncryptedKeyset(BinaryKeysetReader.withBytes(serializedKeyset), this.masterAead, emptyAssociatedData));
            }
            catch (IOException | GeneralSecurityException ex) {
                try {
                    return this.readKeysetInCleartext(serializedKeyset);
                }
                catch (IOException unused) {
                    throw ex;
                }
            }
        }
    }
}

