/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.providers.xmemcached;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReconnectListener
implements MemcachedClientStateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconnectListener.class);
    private final Map<InetSocketAddress, Long> removedServers = new HashMap<InetSocketAddress, Long>();
    private final int maxAwayTime;

    ReconnectListener(int maxAwayTime) {
        this.maxAwayTime = maxAwayTime;
    }

    public void onConnected(final MemcachedClient memcachedClient, final InetSocketAddress inetSocketAddress) {
        Long removedTime = this.removedServers.get(inetSocketAddress);
        if (removedTime != null && System.currentTimeMillis() - removedTime >= TimeUnit.SECONDS.toMillis(this.maxAwayTime)) {
            LOGGER.info("Memcached server {} is back and will be flushed", (Object)inetSocketAddress);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        LOGGER.info("Flushing on memcached server {}", (Object)inetSocketAddress);
                        memcachedClient.flushAll(inetSocketAddress);
                        LOGGER.info("Memcached server {} flushed successfuly", (Object)inetSocketAddress);
                    }
                    catch (Exception e) {
                        LOGGER.error("An error occured while flushing {}", (Object)inetSocketAddress.toString(), (Object)e);
                    }
                }
            }).start();
        }
        this.removedServers.remove(inetSocketAddress);
    }

    public void onDisconnected(MemcachedClient memcachedClient, InetSocketAddress inetSocketAddress) {
        this.removedServers.put(inetSocketAddress, System.currentTimeMillis());
    }

    public void onException(MemcachedClient memcachedClient, Throwable throwable) {
    }

    public void onShutDown(MemcachedClient memcachedClient) {
    }

    public void onStarted(MemcachedClient memcachedClient) {
    }
}

