/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.spring;

import com.google.code.ssm.spring.SSMCache;
import com.google.code.ssm.spring.SSMCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedSSMCacheManager
extends SSMCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedSSMCacheManager.class);
    private char separator = (char)35;

    @Override
    public SSMCache getCache(String name) {
        SSMCache cache = super.getCache(name);
        if (cache != null) {
            return cache;
        }
        int index = name.lastIndexOf(this.getSeparator());
        if (index < 0) {
            return null;
        }
        String cacheName = name.substring(0, index);
        cache = super.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        Integer expiration = this.getExpiration(name, index);
        if (expiration == null || expiration < 0) {
            LOGGER.warn("Default expiration time will be used for cache '{}' because cannot parse '{}'", (Object)cacheName, (Object)name);
            return cache;
        }
        return new SSMCache(cache, (int)expiration);
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    private Integer getExpiration(String name, int separatorIndex) {
        Integer expiration = null;
        String expirationAsString = name.substring(separatorIndex + 1);
        try {
            expiration = Integer.parseInt(expirationAsString);
        }
        catch (NumberFormatException ex) {
            LOGGER.error(String.format("Cannnot separate expiration time from cache: '%s'", name), (Throwable)ex);
        }
        return expiration;
    }
}

