/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.graph;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Queue;

public final class GraphAdapterBuilder {
    private final Map<Type, InstanceCreator<?>> instanceCreators = new HashMap();
    private final ConstructorConstructor constructorConstructor = new ConstructorConstructor(Collections.emptyMap(), true, Collections.emptyList());

    @CanIgnoreReturnValue
    public GraphAdapterBuilder addType(Type type) {
        final ObjectConstructor objectConstructor = this.constructorConstructor.get(TypeToken.get((Type)type));
        InstanceCreator<Object> instanceCreator = new InstanceCreator<Object>(){

            public Object createInstance(Type type) {
                return objectConstructor.construct();
            }
        };
        return this.addType(type, instanceCreator);
    }

    @CanIgnoreReturnValue
    public GraphAdapterBuilder addType(Type type, InstanceCreator<?> instanceCreator) {
        if (type == null || instanceCreator == null) {
            throw new NullPointerException();
        }
        this.instanceCreators.put(type, instanceCreator);
        return this;
    }

    public void registerOn(GsonBuilder gsonBuilder) {
        HashMap instanceCreators = new HashMap(this.instanceCreators);
        Factory factory = new Factory(instanceCreators);
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)factory);
        for (Map.Entry entry : instanceCreators.entrySet()) {
            gsonBuilder.registerTypeAdapter((Type)entry.getKey(), (Object)factory);
        }
    }

    static class Factory
    implements TypeAdapterFactory,
    InstanceCreator<Object> {
        private final Map<Type, InstanceCreator<?>> instanceCreators;
        private final ThreadLocal<Graph> graphThreadLocal = new ThreadLocal();

        Factory(Map<Type, InstanceCreator<?>> instanceCreators) {
            this.instanceCreators = instanceCreators;
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!this.instanceCreators.containsKey(type.getType())) {
                return null;
            }
            final TypeAdapter typeAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            return new TypeAdapter<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(JsonWriter out, T value) throws IOException {
                    Element element;
                    if (value == null) {
                        out.nullValue();
                        return;
                    }
                    Graph graph = (Graph)graphThreadLocal.get();
                    boolean writeEntireGraph = false;
                    if (graph == null) {
                        writeEntireGraph = true;
                        graph = new Graph(new IdentityHashMap());
                    }
                    if ((element = (Element)graph.map.get(value)) == null) {
                        element = new Element(value, graph.nextName(), typeAdapter, null);
                        graph.map.put(value, element);
                        graph.queue.add(element);
                    }
                    if (writeEntireGraph) {
                        graphThreadLocal.set(graph);
                        try {
                            Element current;
                            out.beginObject();
                            while ((current = (Element)graph.queue.poll()) != null) {
                                out.name(current.id);
                                current.write(out);
                            }
                            out.endObject();
                        }
                        finally {
                            graphThreadLocal.remove();
                        }
                    } else {
                        out.value(element.id);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.NULL) {
                        in.nextNull();
                        return null;
                    }
                    String currentName = null;
                    Graph graph = (Graph)graphThreadLocal.get();
                    boolean readEntireGraph = false;
                    if (graph == null) {
                        graph = new Graph(new HashMap());
                        readEntireGraph = true;
                        in.beginObject();
                        while (in.hasNext()) {
                            String name = in.nextName();
                            if (currentName == null) {
                                currentName = name;
                            }
                            JsonElement element = (JsonElement)elementAdapter.read(in);
                            graph.map.put(name, new Element<Object>(null, name, typeAdapter, element));
                        }
                        in.endObject();
                    } else {
                        currentName = in.nextString();
                    }
                    if (readEntireGraph) {
                        graphThreadLocal.set(graph);
                    }
                    try {
                        Element element = (Element)graph.map.get(currentName);
                        if (element.value == null) {
                            element.typeAdapter = typeAdapter;
                            element.read(graph);
                        }
                        Object object = element.value;
                        return object;
                    }
                    finally {
                        if (readEntireGraph) {
                            graphThreadLocal.remove();
                        }
                    }
                }
            };
        }

        public Object createInstance(Type type) {
            Graph graph = this.graphThreadLocal.get();
            if (graph == null || graph.nextCreate == null) {
                throw new IllegalStateException("Unexpected call to createInstance() for " + type);
            }
            InstanceCreator<?> creator = this.instanceCreators.get(type);
            Object result = creator.createInstance(type);
            ((Element)graph.nextCreate).value = result;
            graph.nextCreate = null;
            return result;
        }
    }

    static class Element<T> {
        private final String id;
        private T value;
        private TypeAdapter<T> typeAdapter;
        private final JsonElement element;

        Element(T value, String id, TypeAdapter<T> typeAdapter, JsonElement element) {
            this.value = value;
            this.id = id;
            this.typeAdapter = typeAdapter;
            this.element = element;
        }

        void write(JsonWriter out) throws IOException {
            this.typeAdapter.write(out, this.value);
        }

        void read(Graph graph) {
            if (graph.nextCreate != null) {
                throw new IllegalStateException("Unexpected recursive call to read() for " + this.id);
            }
            graph.nextCreate = this;
            this.value = this.typeAdapter.fromJsonTree(this.element);
            if (this.value == null) {
                throw new IllegalStateException("non-null value deserialized to null: " + this.element);
            }
        }
    }

    static class Graph {
        private final Map<Object, Element<?>> map;
        private final Queue<Element<?>> queue = new ArrayDeque();
        private Element<Object> nextCreate;

        private Graph(Map<Object, Element<?>> map) {
            this.map = map;
        }

        public String nextName() {
            return "0x" + Integer.toHexString(this.map.size() + 1);
        }
    }
}

