/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.FBAppConf;
import java.io.Serializable;
import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FBWebSession
implements Serializable {
    private FBAppConf appConf;
    private String sessionKey;
    private Date sessionExpires;
    private Long userId;
    private String sessionSecret;
    private SortedMap<String, String> params;
    private boolean appUser;

    public FBWebSession(FBAppConf appConf) {
        this.appConf = appConf;
        this.params = new TreeMap<String, String>();
    }

    public FBAppConf getAppConf() {
        return this.appConf;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public boolean isExpired() {
        return this.sessionKey == null || this.sessionExpires == null || this.sessionExpires.getTime() <= System.currentTimeMillis();
    }

    public Date getSessionExpires() {
        return this.sessionExpires;
    }

    public void setSessionExpires(Date sessionExpires) {
        this.sessionExpires = sessionExpires;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getSessionSecret() {
        return this.sessionSecret;
    }

    public void setSessionSecret(String sessionSecret) {
        this.sessionSecret = sessionSecret;
    }

    public SortedMap<String, String> getParams() {
        return this.params;
    }

    public void setParams(SortedMap<String, String> params) {
        this.params = params;
    }

    public boolean isAppUser() {
        return this.appUser;
    }

    public void setAppUser(boolean appUser) {
        this.appUser = appUser;
    }

    public boolean update(String sessionKey, Date sessionExpires, Long userId, String sessionSecret, Boolean appUser) {
        boolean same = true;
        if (sessionKey != null && !ObjectUtils.equals((Object)this.sessionKey, (Object)sessionKey)) {
            this.sessionKey = sessionKey;
            same = false;
        }
        if (sessionExpires != null && !ObjectUtils.equals((Object)this.sessionExpires, (Object)sessionExpires)) {
            this.sessionExpires = sessionExpires;
            same = false;
        }
        if (userId != null && !ObjectUtils.equals((Object)this.userId, (Object)userId)) {
            this.userId = userId;
            same = false;
        }
        if (sessionSecret != null && !ObjectUtils.equals((Object)this.sessionSecret, (Object)sessionSecret)) {
            this.sessionSecret = sessionSecret;
            same = false;
        }
        if (appUser != null && !ObjectUtils.equals((Object)this.appUser, (Object)appUser)) {
            this.appUser = appUser;
            same = false;
        }
        return !same;
    }
}

