/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.BasicClientHelper;
import com.google.code.facebookapi.FacebookException;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonHelper {
    public static JSONObject toJson(Map<String, String> map) {
        return new JSONObject(map);
    }

    public static JSONArray toJsonListOfStrings(Collection<String> list) {
        return new JSONArray(list);
    }

    public static JSONArray toJsonListOfMaps(Collection<Map<String, String>> listOfMaps) {
        JSONArray out = new JSONArray();
        for (Map<String, String> map : listOfMaps) {
            out.put((Object)JsonHelper.toJson(map));
        }
        return out;
    }

    public static Object parseCallResult(Object rawResponse) throws FacebookException {
        if (rawResponse == null) {
            return null;
        }
        String jsonResp = (String)rawResponse;
        Object json = JsonHelper.jsonToJavaValue(jsonResp);
        if (json instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)json;
            try {
                if (jsonObj.has("error_code")) {
                    int code = jsonObj.getInt("error_code");
                    String message = null;
                    if (jsonObj.has("error_msg")) {
                        message = jsonObj.getString("error_msg");
                    }
                    throw new FacebookException(code, message);
                }
            }
            catch (JSONException ex) {
                throw BasicClientHelper.runtimeException((Exception)((Object)ex));
            }
        }
        return json;
    }

    public static Object jsonToJavaValue(String s) {
        String strValue;
        if (s.startsWith("[")) {
            try {
                return new JSONArray(s);
            }
            catch (JSONException ex) {
                throw BasicClientHelper.runtimeException((Exception)((Object)ex));
            }
        }
        if (s.startsWith("{")) {
            try {
                return new JSONObject(s);
            }
            catch (JSONException ex) {
                throw BasicClientHelper.runtimeException((Exception)((Object)ex));
            }
        }
        Object returnMe = JsonHelper.stringToValue(s);
        if (returnMe instanceof String && (strValue = (String)returnMe).length() > 1) {
            returnMe = strValue.trim().substring(1, strValue.length() - 1);
        }
        return returnMe;
    }

    public static Object stringToValue(String s) {
        if (s.equals("")) {
            return s;
        }
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s.equalsIgnoreCase("null")) {
            return JSONObject.NULL;
        }
        char b = s.charAt(0);
        if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
            if (b == '0') {
                if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(s.substring(2), 16));
                    }
                    catch (Exception e) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(s, 8));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            try {
                return new Integer(s);
            }
            catch (Exception e) {
                try {
                    return new Long(s);
                }
                catch (Exception f) {
                    try {
                        return new Double(s);
                    }
                    catch (Exception g) {
                        // empty catch block
                    }
                }
            }
        }
        return s;
    }
}

