/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.AttachmentMedia;
import com.google.code.facebookapi.AttachmentProperty;
import com.google.code.facebookapi.BasicClientHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attachment
implements Serializable {
    private String name;
    private String href;
    private String caption;
    private String description;
    private List<AttachmentProperty> properties;
    private AttachmentMedia media;
    private Map<String, String> additionalInfo;
    private JSONObject jsonAttachment;

    public JSONObject toJson() {
        this.jsonAttachment = new JSONObject();
        this.putJsonObject("name", this.name);
        this.putJsonObject("href", this.href);
        this.putJsonObject("caption", this.caption);
        this.putJsonObject("description", this.description);
        this.putJsonProperties();
        this.putJsonMedia();
        this.putJsonAdditionalInfo();
        return this.jsonAttachment;
    }

    private void putJsonObject(String key, Object value) {
        if (this.jsonAttachment == null) {
            return;
        }
        try {
            this.jsonAttachment.put(key, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void putJsonProperties() {
        if (this.properties == null || this.properties.isEmpty()) {
            return;
        }
        JSONObject jsonProperties = new JSONObject();
        for (AttachmentProperty link : this.properties) {
            try {
                if (StringUtils.isEmpty((String)link.getCaption())) continue;
                if (!StringUtils.isEmpty((String)link.getText()) && !StringUtils.isEmpty((String)link.getHref())) {
                    jsonProperties.put(link.getCaption(), (Object)link.toJson());
                    continue;
                }
                if (StringUtils.isEmpty((String)link.getText())) continue;
                jsonProperties.put(link.getCaption(), (Object)link.getText());
            }
            catch (JSONException exception) {
                throw BasicClientHelper.runtimeException((Exception)((Object)exception));
            }
        }
        this.putJsonObject("properties", jsonProperties);
    }

    private void putJsonMedia() {
        if (this.media == null) {
            return;
        }
        this.putJsonObject("media", this.media.toJson());
    }

    private void putJsonAdditionalInfo() {
        if (this.additionalInfo == null || this.additionalInfo.isEmpty()) {
            return;
        }
        for (String key : this.additionalInfo.keySet()) {
            this.putJsonObject(key, this.additionalInfo.get(key));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<AttachmentProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<AttachmentProperty> properties) {
        this.properties = properties;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public AttachmentMedia getMedia() {
        return this.media;
    }

    public void setMedia(AttachmentMedia media) {
        this.media = media;
    }
}

