/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.FacebookJaxbRestClient;
import com.google.code.facebookapi.FacebookJsonRestClient;
import com.google.code.facebookapi.FacebookParam;
import com.google.code.facebookapi.FacebookXmlRestClient;
import com.google.code.facebookapi.IFacebookRestClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookWebappHelper<T> {
    protected static Log log = LogFactory.getLog(FacebookWebappHelper.class);
    private HttpServletRequest request;
    private HttpServletResponse response;
    protected IFacebookRestClient<T> apiClient;
    protected String apiKey;
    protected String secret;
    protected Map<String, String> fbParams;
    protected Long user;
    private static String FACEBOOK_URL_PATTERN = "^https?://([^/]*\\.)?facebook\\.com(:\\d+)?/.*";

    @Deprecated
    public FacebookWebappHelper(HttpServletRequest request, HttpServletResponse response, String apiKey, String secret) {
        this(request, response, apiKey, secret, new FacebookXmlRestClient(apiKey, secret));
    }

    public static FacebookWebappHelper<Document> newInstanceXml(HttpServletRequest request, HttpServletResponse response, String apiKey, String secret) {
        return new FacebookWebappHelper<Document>(request, response, apiKey, secret, new FacebookXmlRestClient(apiKey, secret));
    }

    public static FacebookWebappHelper<Object> newInstanceJson(HttpServletRequest request, HttpServletResponse response, String apiKey, String secret) {
        return new FacebookWebappHelper<Object>(request, response, apiKey, secret, new FacebookJsonRestClient(apiKey, secret));
    }

    public static FacebookWebappHelper<Object> newInstanceJaxb(HttpServletRequest request, HttpServletResponse response, String apiKey, String secret) {
        return new FacebookWebappHelper<Object>(request, response, apiKey, secret, new FacebookJaxbRestClient(apiKey, secret));
    }

    public FacebookWebappHelper(HttpServletRequest request, HttpServletResponse response, String apiKey, String secret, IFacebookRestClient<T> apiClient) {
        String added;
        this.request = request;
        this.response = response;
        this.apiKey = apiKey;
        this.secret = secret;
        this.apiClient = apiClient;
        this.validateFbParams();
        String userS = this.fbParams.get(FacebookParam.USER.getSignatureName());
        String canvasUserS = this.fbParams.get(FacebookParam.CANVAS_USER.getSignatureName());
        String sessionKey = this.fbParams.get(FacebookParam.SESSION_KEY.getSignatureName());
        String expiresS = this.fbParams.get(FacebookParam.EXPIRES.getSignatureName());
        if (userS != null && sessionKey != null && expiresS != null) {
            apiClient.setCacheSession(sessionKey, Long.parseLong(userS), Long.parseLong(expiresS));
        } else if (canvasUserS != null) {
            apiClient.setCacheSession(null, Long.parseLong(canvasUserS), null);
        }
        String friends = this.fbParams.get("friends");
        if (friends != null && !friends.equals("")) {
            ArrayList<Long> friendsList = new ArrayList<Long>();
            for (String friend : friends.split(",")) {
                friendsList.add(Long.parseLong(friend));
            }
            apiClient.setCacheFriendsList(friendsList);
        }
        if ((added = this.fbParams.get("added")) != null) {
            apiClient.setCacheAppAdded(added.equals("1"));
        }
    }

    public IFacebookRestClient<T> getFacebookRestClient() {
        return this.apiClient;
    }

    public IFacebookRestClient<T> get_api_client() {
        return this.apiClient;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    private void validateFbParams() {
        this.fbParams = this.getValidFbParams(this._getRequestParams(), 172800, FacebookParam.SIGNATURE.toString());
        if (this.fbParams != null && !this.fbParams.isEmpty()) {
            String tmpSt = this.fbParams.get(FacebookParam.USER.getSignatureName());
            Long user_id = tmpSt != null ? Long.valueOf(tmpSt) : null;
            String session_key = this.fbParams.get(FacebookParam.SESSION_KEY.getSignatureName());
            tmpSt = this.fbParams.get(FacebookParam.EXPIRES.getSignatureName());
            Long expires = tmpSt != null ? Long.valueOf(tmpSt) : null;
            this.setUser(user_id, session_key, expires);
        } else {
            Map<String, String> cookieParams = this._getCookiesParams();
            this.fbParams = this.getValidFbParams(cookieParams, null, this.apiKey);
            if (this.fbParams != null && !this.fbParams.isEmpty()) {
                String tmpSt = this.fbParams.get(FacebookParam.USER.getSignatureName());
                Long user_id = tmpSt != null ? Long.valueOf(tmpSt) : null;
                String session_key = this.fbParams.get(FacebookParam.SESSION_KEY.getSignatureName());
                this.setUser(user_id, session_key, null);
            } else if (this.request.getParameter("auth_token") != null) {
                try {
                    this.doGetSession(this.request.getParameter("auth_token"));
                    this.setUser(this.apiClient.getCacheUserId(), this.apiClient.getCacheSessionKey(), this.apiClient.getCacheSessionExpires());
                }
                catch (Exception ex) {
                    log.warn((Object)("possible issue (might be ignorable): " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    public String doGetSession(String authToken) {
        try {
            return this.apiClient.auth_getSession(authToken);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setUser(Long user_id, String session_key, Long expires) {
        Map<String, String> cookiesInfo;
        String cookieUser;
        if (!(this.inFbCanvas() || (cookieUser = (cookiesInfo = this._getCookiesParams()).get(this.apiKey + "_user")) != null && cookieUser.equals(user_id + ""))) {
            TreeMap<String, String> cookies = new TreeMap<String, String>();
            cookies.put("user", user_id + "");
            cookies.put("session_key", session_key);
            String sig = FacebookWebappHelper.generateSig(cookies, this.secret);
            int age = 0;
            if (expires != null) {
                age = (int)(expires - System.currentTimeMillis() / 1000L);
            }
            for (Map.Entry entry : cookies.entrySet()) {
                this.addCookie(this.apiKey + "_" + (String)entry.getKey(), (String)entry.getValue(), age);
            }
            this.addCookie(this.apiKey, sig, age);
        }
        this.user = user_id;
    }

    private void addCookie(String key, String value, int age) {
        Cookie cookie = new Cookie(key, value);
        if (age > 0) {
            cookie.setMaxAge(age);
        }
        cookie.setPath(this.request.getContextPath());
        this.response.addCookie(cookie);
    }

    private Map<String, String> getValidFbParams(Map<String, String> params, Integer timeout, String namespace) {
        if (namespace == null) {
            namespace = "fb_sig";
        }
        String prefix = namespace + "_";
        int prefix_len = prefix.length();
        HashMap<String, String> fb_params = new HashMap<String, String>();
        for (Map.Entry<String, String> requestParam : params.entrySet()) {
            if (requestParam.getKey().indexOf(prefix) != 0) continue;
            fb_params.put(requestParam.getKey().substring(prefix_len), requestParam.getValue());
        }
        if (timeout != null) {
            if (!fb_params.containsKey(FacebookParam.TIME.getSignatureName())) {
                return Collections.emptyMap();
            }
            String tmpTime = (String)fb_params.get(FacebookParam.TIME.getSignatureName());
            if (tmpTime.indexOf(46) > 0) {
                tmpTime = tmpTime.substring(0, tmpTime.indexOf(46));
            }
            long time = Long.parseLong(tmpTime);
            if (System.currentTimeMillis() / 1000L - time > (long)timeout.intValue()) {
                return Collections.emptyMap();
            }
        }
        if (!params.containsKey(namespace) || !this.verifySignature(fb_params, params.get(namespace))) {
            return Collections.emptyMap();
        }
        return fb_params;
    }

    public void redirect(String url) {
        try {
            if (this.inFbCanvas()) {
                String out = "<fb:redirect url=\"" + url + "\"/>";
                this.response.getWriter().print(out);
                this.response.flushBuffer();
            } else if (url.matches(FACEBOOK_URL_PATTERN)) {
                String out = "<script type=\"text/javascript\">\ntop.location.href = \"" + url + "\";\n</script>";
                this.response.getWriter().print(out);
                this.response.flushBuffer();
            } else {
                this.response.sendRedirect(url);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean inFrame() {
        return this.fbParams.containsKey(FacebookParam.IN_CANVAS.getSignatureName()) || this.fbParams.containsKey(FacebookParam.IN_IFRAME.getSignatureName());
    }

    public boolean inFbCanvas() {
        return this.fbParams.containsKey(FacebookParam.IN_CANVAS.getSignatureName());
    }

    public boolean isAdded() {
        return "1".equals(this.fbParams.get(FacebookParam.ADDED.getSignatureName()));
    }

    public boolean isLogin() {
        return this.getUser() != null;
    }

    public Long get_loggedin_user() {
        return this.getUser();
    }

    public Long getUser() {
        return this.user;
    }

    private String currentUrl() {
        String url = this.request.getScheme() + "://" + this.request.getServerName();
        int port = this.request.getServerPort();
        if (port != 80) {
            url = url + ":" + port;
        }
        url = url + this.request.getRequestURI();
        return url;
    }

    public boolean requireLogin(String next) {
        if (this.isLogin()) {
            return false;
        }
        this.redirect(this.getLoginUrl(next, this.inFrame()));
        return true;
    }

    @Deprecated
    public boolean requireAdd(String next) {
        if (this.getUser() != null && this.isAdded()) {
            return false;
        }
        this.redirect(this.getAddUrl(next));
        return true;
    }

    public boolean requireFrame(String next) {
        if (!this.inFrame()) {
            this.redirect(this.getLoginUrl(next, true));
            return true;
        }
        return false;
    }

    public String getLoginUrl(String next, boolean canvas) {
        String url = FacebookWebappHelper.getFacebookUrl(null) + "/login.php?v=1.0&api_key=" + this.apiKey;
        try {
            url = url + (next != null ? "&next=" + URLEncoder.encode(next, "UTF-8") : "");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        url = url + (canvas ? "&canvas=true" : "");
        return url;
    }

    public String getAddUrl(String next) {
        String url = FacebookWebappHelper.getFacebookUrl(null) + "/add.php?api_key=" + this.apiKey;
        try {
            url = url + (next != null ? "&next=" + URLEncoder.encode(next, "UTF-8") : "");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public static String getFacebookUrl(String subDomain) {
        if (subDomain == null || subDomain.equals("")) {
            subDomain = "www";
        }
        return "http://" + subDomain + ".facebook.com";
    }

    public static String generateSig(Map<String, String> params, String secret) {
        TreeSet<String> keys = new TreeSet<String>(params.keySet());
        keys.remove(FacebookParam.SIGNATURE.toString());
        String str = "";
        for (String key : keys) {
            str = str + key + "=" + params.get(key);
        }
        str = str + secret;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes("UTF-8"));
            StringBuilder result = new StringBuilder();
            for (byte b : md.digest()) {
                result.append(Integer.toHexString((b & 0xF0) >>> 4));
                result.append(Integer.toHexString(b & 0xF));
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean verifySignature(Map<String, String> params, String expected_sig) {
        return FacebookWebappHelper.generateSig(params, this.secret).equals(expected_sig);
    }

    private Map<String, String> _getRequestParams() {
        HashMap<String, String> results = new HashMap<String, String>();
        Map map = this.request.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            results.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return results;
    }

    private Map<String, String> _getCookiesParams() {
        HashMap<String, String> results = new HashMap<String, String>();
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                results.put(cookie.getName(), cookie.getValue());
            }
        }
        return results;
    }
}

