/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.AllocationType;
import com.google.code.facebookapi.ApplicationProperty;
import com.google.code.facebookapi.ApplicationPropertySet;
import com.google.code.facebookapi.BatchQuery;
import com.google.code.facebookapi.BundleStoryTemplate;
import com.google.code.facebookapi.ErrorCode;
import com.google.code.facebookapi.ExtensibleClient;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.FacebookMethod;
import com.google.code.facebookapi.FacebookSignatureUtil;
import com.google.code.facebookapi.IFacebookMethod;
import com.google.code.facebookapi.IFacebookRestClient;
import com.google.code.facebookapi.IFeedImage;
import com.google.code.facebookapi.IPair;
import com.google.code.facebookapi.MarketListing;
import com.google.code.facebookapi.MarketListingCategory;
import com.google.code.facebookapi.MarketListingStatus;
import com.google.code.facebookapi.MarketListingSubcategory;
import com.google.code.facebookapi.MarketplaceListing;
import com.google.code.facebookapi.Metric;
import com.google.code.facebookapi.PageProfileField;
import com.google.code.facebookapi.Pair;
import com.google.code.facebookapi.Permission;
import com.google.code.facebookapi.PhotoTag;
import com.google.code.facebookapi.ProfileField;
import com.google.code.facebookapi.ProfileFieldItem;
import com.google.code.facebookapi.ProfileInfoField;
import com.google.code.facebookapi.TemplatizedAction;
import com.google.code.facebookapi.schema.Listing;
import com.google.code.facebookapi.schema.MarketplaceGetCategoriesResponse;
import com.google.code.facebookapi.schema.MarketplaceGetListingsResponse;
import com.google.code.facebookapi.schema.MarketplaceGetSubCategoriesResponse;
import com.google.code.facebookapi.schema.MarketplaceSearchResponse;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class FacebookRestClient
implements IFacebookRestClient<Document> {
    protected static Log log = LogFactory.getLog(FacebookRestClient.class);
    public static final String TARGET_API_VERSION = "1.0";
    public static final String ERROR_TAG = "error_response";
    public static final String FB_SERVER = "api.facebook.com/restserver.php";
    public static final String SERVER_ADDR = "http://api.facebook.com/restserver.php";
    public static final String HTTPS_SERVER_ADDR = "https://api.facebook.com/restserver.php";
    public static URL SERVER_URL = null;
    public static URL HTTPS_SERVER_URL = null;
    protected static JAXBContext JAXB_CONTEXT;
    private static final Map<FacebookMethod, String> RETURN_TYPES;
    protected final String _secret;
    protected final String _apiKey;
    protected URL _serverUrl;
    protected boolean namespaceAware = true;
    protected int _timeout;
    protected int _readTimeout;
    protected boolean _isDesktop = false;
    protected String cacheSessionKey;
    protected Long cacheUserId;
    protected Long cacheSessionExpires;
    protected String cacheSessionSecret;
    protected String rawResponse;
    protected boolean batchMode;
    protected List<BatchQuery> queries;
    protected String permissionsApiKey = null;
    protected Document cacheFriendsList;
    protected Boolean cacheAppAdded;
    public static final int NUM_AUTOAPPENDED_PARAMS = 6;
    protected File _uploadFile = null;
    protected static final String CRLF = "\r\n";
    protected static final String PREF = "--";
    protected static final int UPLOAD_BUFFER_SIZE = 512;
    public static final String MARKETPLACE_STATUS_DEFAULT = "DEFAULT";
    public static final String MARKETPLACE_STATUS_NOT_SUCCESS = "NOT_SUCCESS";
    public static final String MARKETPLACE_STATUS_SUCCESS = "SUCCESS";

    public FacebookRestClient(String apiKey, String secret) {
        this(SERVER_URL, apiKey, secret, null);
    }

    public FacebookRestClient(String apiKey, String secret, int connectionTimeout) {
        this(SERVER_URL, apiKey, secret, null, connectionTimeout);
    }

    public FacebookRestClient(String apiKey, String secret, String sessionKey) {
        this(SERVER_URL, apiKey, secret, sessionKey);
    }

    public FacebookRestClient(String apiKey, String secret, String sessionKey, int connectionTimeout) {
        this(SERVER_URL, apiKey, secret, sessionKey, connectionTimeout);
    }

    public FacebookRestClient(String serverAddr, String apiKey, String secret, String sessionKey) throws MalformedURLException {
        this(new URL(serverAddr), apiKey, secret, sessionKey);
    }

    public FacebookRestClient(String serverAddr, String apiKey, String secret, String sessionKey, int connectionTimeout) throws MalformedURLException {
        this(new URL(serverAddr), apiKey, secret, sessionKey, connectionTimeout);
    }

    public FacebookRestClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        this.cacheSessionKey = sessionKey;
        this._apiKey = apiKey;
        this._secret = secret;
        this._serverUrl = null != serverUrl ? serverUrl : SERVER_URL;
        this._timeout = -1;
        this._readTimeout = -1;
        this.batchMode = false;
        this.queries = new ArrayList<BatchQuery>();
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean v) {
        this.namespaceAware = v;
    }

    @Override
    public void beginPermissionsMode(String apiKey) {
        this.permissionsApiKey = apiKey;
    }

    @Override
    public void endPermissionsMode() {
        this.permissionsApiKey = null;
    }

    @Override
    public JAXBContext getJaxbContext() {
        return JAXB_CONTEXT;
    }

    @Override
    public void setJaxbContext(JAXBContext context) {
        JAXB_CONTEXT = context;
    }

    @Deprecated
    public String _getSessionKey() {
        return this.cacheSessionKey;
    }

    @Deprecated
    public void _setSessionKey(String key) {
        this.cacheSessionKey = key;
    }

    @Deprecated
    public Long _getExpires() {
        return this.cacheSessionExpires;
    }

    @Deprecated
    public void _setExpires(Long _expires) {
        this.cacheSessionExpires = _expires;
    }

    @Deprecated
    public Long _getUserId() {
        return this.cacheUserId;
    }

    @Deprecated
    public void _setUserId(Long id) {
        this.cacheUserId = id;
    }

    @Override
    public String getCacheSessionSecret() {
        return this.cacheSessionSecret;
    }

    public void setCacheSessionSecret(String cacheSessionSecret) {
        this.cacheSessionSecret = cacheSessionSecret;
    }

    @Override
    public void setCacheSession(String cacheSessionKey, Long cacheUserId, Long cacheSessionExpires) {
        this.setCacheSessionKey(cacheSessionKey);
        this.setCacheUserId(cacheUserId);
        this.setCacheSessionExpires(cacheSessionExpires);
    }

    @Override
    public Long getCacheSessionExpires() {
        return this.cacheSessionExpires;
    }

    public void setCacheSessionExpires(Long cacheSessionExpires) {
        this.cacheSessionExpires = cacheSessionExpires;
    }

    @Override
    public String getCacheSessionKey() {
        return this.cacheSessionKey;
    }

    public void setCacheSessionKey(String cacheSessionKey) {
        this.cacheSessionKey = cacheSessionKey;
    }

    @Override
    public Long getCacheUserId() {
        return this.cacheUserId;
    }

    public void setCacheUserId(Long cacheUserId) {
        this.cacheUserId = cacheUserId;
    }

    @Override
    public Document getCacheFriendsList() {
        return this.cacheFriendsList;
    }

    @Override
    public void setCacheFriendsList(List<Long> ids) {
        this.cacheFriendsList = FacebookRestClient.toFriendsGetResponse(ids);
    }

    public static Document toFriendsGetResponse(List<Long> ids) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElementNS("http://api.facebook.com/1.0/", "friends_get_response");
            root.setAttributeNS("http://api.facebook.com/1.0/", "friends_get_response", "http://api.facebook.com/1.0/ http://api.facebook.com/1.0/facebook.xsd");
            root.setAttribute("list", "true");
            for (Long id : ids) {
                Element uid = doc.createElement("uid");
                uid.appendChild(doc.createTextNode(Long.toString(id)));
                root.appendChild(uid);
            }
            doc.appendChild(root);
            return doc;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public FacebookRestClient(URL serverUrl, String apiKey, String secret, String sessionKey, int connectionTimeout) {
        this(serverUrl, apiKey, secret, sessionKey, connectionTimeout, -1);
        this._timeout = connectionTimeout;
    }

    public FacebookRestClient(URL serverUrl, String apiKey, String secret, String sessionKey, int connectionTimeout, int readTimeout) {
        this(serverUrl, apiKey, secret, sessionKey);
        this._timeout = connectionTimeout;
        this._readTimeout = readTimeout;
    }

    public String getResponseFormat() {
        return "xml";
    }

    @Override
    public boolean isDesktop() {
        return this._isDesktop;
    }

    @Override
    public void setIsDesktop(boolean isDesktop) {
        this._isDesktop = isDesktop;
    }

    public void printDom(Node n, String prefix) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("\n");
            ExtensibleClient.printDom(n, prefix, sb);
            log.debug((Object)sb.toString());
        }
    }

    private static CharSequence delimit(Collection<?> iterable) {
        if (iterable == null || iterable.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirst = false;
        for (Object item : iterable) {
            if (notFirst) {
                buffer.append(",");
            } else {
                notFirst = true;
            }
            buffer.append(item.toString());
        }
        return buffer;
    }

    protected static CharSequence delimit(Collection<Map.Entry<String, String>> entries, String delimiter, String equals, boolean doEncode) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirst = false;
        for (Map.Entry<String, String> entry : entries) {
            if (notFirst) {
                buffer.append(delimiter);
            } else {
                notFirst = true;
            }
            CharSequence value = entry.getValue();
            buffer.append(entry.getKey()).append(equals).append(doEncode ? FacebookRestClient.encode(value) : value);
        }
        return buffer;
    }

    protected Document callMethod(IFacebookMethod method, Pair<String, CharSequence> ... paramPairs) throws FacebookException, IOException {
        return this.callMethod(method, Arrays.asList(paramPairs));
    }

    @Override
    public void beginBatch() {
        this.batchMode = true;
        this.queries = new ArrayList<BatchQuery>();
    }

    @Override
    public List<? extends Object> executeBatch(boolean serial) throws FacebookException, IOException {
        this.batchMode = false;
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<BatchQuery> buffer = new ArrayList<BatchQuery>();
        while (!this.queries.isEmpty()) {
            buffer.add(this.queries.remove(0));
            if (buffer.size() != 15 && !this.queries.isEmpty()) continue;
            Document doc = this.batch_run(this.encodeMethods(buffer), serial);
            NodeList responses = doc.getElementsByTagName("batch_run_response_elt");
            for (int count = 0; count < responses.getLength(); ++count) {
                String response = FacebookRestClient.extractString(responses.item(count));
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document respDoc = builder.parse(new ByteArrayInputStream(response.getBytes("UTF-8")));
                    String type = RETURN_TYPES.get(((BatchQuery)buffer.get(count)).getMethod());
                    if (type.equals("default")) {
                        result.add(respDoc);
                        continue;
                    }
                    if (type.equals("string")) {
                        result.add(FacebookRestClient.extractString(respDoc));
                        continue;
                    }
                    if (type.equals("bool")) {
                        result.add(FacebookRestClient.extractBoolean(respDoc));
                        continue;
                    }
                    if (type.equals("int")) {
                        result.add(FacebookRestClient.extractInt(respDoc));
                        continue;
                    }
                    if (type.equals("long")) {
                        result.add(this.extractLong(respDoc));
                        continue;
                    }
                    result.add(null);
                    continue;
                }
                catch (Exception ignored) {
                    if (result.size() >= count + 1) continue;
                    result.add(null);
                }
            }
        }
        return result;
    }

    private String encodeMethods(List<BatchQuery> queries) throws FacebookException {
        JSONArray result = new JSONArray();
        for (BatchQuery query : queries) {
            if (query.getMethod().takesFile()) {
                throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "File upload API calls cannot be batched:  " + query.getMethod().methodName());
            }
            result.put((Object)FacebookRestClient.delimit(query.getParams().entrySet(), "&", "=", true));
        }
        return result.toString();
    }

    @Override
    public Document batch_run(String methods, boolean serial) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("method_feed", methods));
        if (serial) {
            params.add(new Pair<String, String>("serial_only", "1"));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.BATCH_RUN, params);
    }

    protected Document callMethod(IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException, IOException {
        boolean includeSession;
        this.rawResponse = null;
        TreeMap<String, String> params = new TreeMap<String, String>();
        if (this.permissionsApiKey != null) {
            params.put("call_as_apikey", this.permissionsApiKey);
        }
        params.put("method", method.methodName());
        params.put("api_key", this._apiKey);
        params.put("v", TARGET_API_VERSION);
        params.put("call_id", Long.toString(System.currentTimeMillis()));
        boolean bl = includeSession = method.requiresSession() && this.cacheSessionKey != null;
        if (includeSession) {
            params.put("session_key", this.cacheSessionKey);
        }
        for (Pair<String, CharSequence> p : paramPairs) {
            CharSequence oldVal = params.put((String)p.first, FacebookSignatureUtil.toString((CharSequence)p.second));
            if (oldVal == null) continue;
            log.warn((Object)("For parameter " + (String)p.first + ", overwrote old value " + oldVal + " with new value " + p.second + "."));
        }
        assert (!params.containsKey("sig"));
        String signature = this.generateSignature(FacebookSignatureUtil.convert(params.entrySet()), includeSession);
        params.put("sig", signature);
        if (this.batchMode) {
            boolean addToBatch = true;
            if (method.methodName().equals(FacebookMethod.USERS_GET_LOGGED_IN_USER.methodName())) {
                Exception trace = new Exception();
                StackTraceElement[] traceElems = trace.getStackTrace();
                int index = 0;
                for (StackTraceElement elem : traceElems) {
                    if (elem.getMethodName().indexOf("_") != -1) {
                        StackTraceElement caller = traceElems[index + 1];
                        if (!caller.getClassName().equals(this.getClass().getName()) || caller.getMethodName().startsWith("auth_")) break;
                        addToBatch = false;
                        break;
                    }
                    ++index;
                }
            }
            if (addToBatch) {
                this.queries.add(new BatchQuery(method, params));
            }
            return null;
        }
        try {
            String xmlResp;
            String line;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(this.namespaceAware);
            DocumentBuilder builder = factory.newDocumentBuilder();
            boolean doHttps = this.isDesktop() && FacebookMethod.AUTH_GET_SESSION.equals(method);
            boolean doEncode = true;
            InputStream data = method.takesFile() ? this.postFileRequest(method.methodName(), params, doEncode) : this.postRequest(method.methodName(), params, doHttps, doEncode);
            BufferedReader in = new BufferedReader(new InputStreamReader(data, "UTF-8"));
            StringBuilder buffer = new StringBuilder();
            boolean insideTagBody = false;
            while ((line = in.readLine()) != null) {
                if (method != FacebookMethod.BATCH_RUN) {
                    if (line.trim().startsWith("<") && line.contains(">")) {
                        insideTagBody = true;
                    }
                    if (line.trim().endsWith(">")) {
                        insideTagBody = false;
                    }
                    if (insideTagBody) {
                        line = line + ",";
                    }
                }
                buffer.append(line);
            }
            this.rawResponse = xmlResp = buffer.toString();
            Document doc = builder.parse(new ByteArrayInputStream(xmlResp.getBytes("UTF-8")));
            doc.normalizeDocument();
            FacebookRestClient.stripEmptyTextNodes(doc);
            this.printDom(doc, method.methodName() + "| ");
            NodeList errors = doc.getElementsByTagName(ERROR_TAG);
            if (errors.getLength() > 0) {
                int errorCode = Integer.parseInt(errors.item(0).getFirstChild().getFirstChild().getTextContent());
                String message = errors.item(0).getFirstChild().getNextSibling().getTextContent();
                if (log.isWarnEnabled()) {
                    StringBuilder sb = new StringBuilder("Facebook returns error code " + errorCode + "\n");
                    for (Map.Entry entry : params.entrySet()) {
                        sb.append("  - " + (String)entry.getKey() + " -> " + (String)entry.getValue() + "\n");
                    }
                    log.warn((Object)sb.toString());
                }
                throw new FacebookException(errorCode, message);
            }
            return doc;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Trouble configuring XML Parser", ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Trouble parsing XML from facebook", ex);
        }
    }

    @Override
    public String getRawResponse() {
        String result = this.rawResponse;
        this.rawResponse = null;
        return result;
    }

    private static void stripEmptyTextNodes(Node n) {
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node c = children.item(i);
            if (!c.hasChildNodes() && c.getNodeType() == 3 && c.getTextContent().trim().length() == 0) {
                n.removeChild(c);
                --i;
                --length;
                children = n.getChildNodes();
                continue;
            }
            FacebookRestClient.stripEmptyTextNodes(c);
        }
    }

    private String generateSignature(List<String> params, boolean requiresSession) {
        String secret = this.isDesktop() && requiresSession ? this.cacheSessionSecret : this._secret;
        return FacebookSignatureUtil.generateSignature(params, secret);
    }

    private static String encode(CharSequence target) {
        String result = target != null ? ((Object)target).toString() : "";
        try {
            result = URLEncoder.encode(result, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)("Unsuccessful attempt to encode '" + result + "' into UTF8"), (Throwable)ex);
        }
        return result;
    }

    private InputStream postRequest(CharSequence method, Map<String, String> params, boolean doHttps, boolean doEncode) throws IOException {
        URL serverUrl;
        String buffer = null == params ? "" : FacebookRestClient.delimit(params.entrySet(), "&", "=", doEncode);
        URL uRL = serverUrl = doHttps ? HTTPS_SERVER_URL : this._serverUrl;
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(method);
            sb.append(" POST: ");
            sb.append(serverUrl.toString());
            sb.append("?");
            sb.append((CharSequence)buffer);
            log.debug((Object)sb.toString());
        }
        HttpURLConnection conn = (HttpURLConnection)serverUrl.openConnection();
        if (this._timeout != -1) {
            conn.setConnectTimeout(this._timeout);
        }
        if (this._readTimeout != -1) {
            conn.setReadTimeout(this._readTimeout);
        }
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException ex) {
            log.error((Object)("Exception: " + ex.getMessage()), (Throwable)ex);
        }
        conn.setDoOutput(true);
        conn.connect();
        conn.getOutputStream().write(buffer.toString().getBytes());
        return conn.getInputStream();
    }

    @Override
    public Document profile_getFBML() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, new Pair[0]);
    }

    @Override
    public Document profile_getFBML(Long userId) throws FacebookException, IOException {
        if (userId != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML_NOSESSION, FacebookRestClient.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, new Pair[0]);
    }

    @Override
    public Document profile_getFBML(int type) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, FacebookRestClient.newPair("type", type));
    }

    @Override
    public Document profile_getFBML(int type, Long userId) throws FacebookException, IOException {
        if (userId != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML_NOSESSION, FacebookRestClient.newPair("type", type), FacebookRestClient.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, FacebookRestClient.newPair("type", type));
    }

    @Override
    public boolean fbml_refreshRefUrl(String url) throws FacebookException, IOException {
        return this.fbml_refreshRefUrl(new URL(url));
    }

    @Override
    public boolean fbml_refreshRefUrl(URL url) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_REF_URL, new Pair<String, String>("url", url.toString())));
    }

    @Override
    public boolean fbml_refreshImgSrc(String imageUrl) throws FacebookException, IOException {
        return this.fbml_refreshImgSrc(new URL(imageUrl));
    }

    @Override
    public boolean fbml_refreshImgSrc(URL imageUrl) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_IMG_SRC, new Pair<String, String>("url", imageUrl.toString())));
    }

    @Override
    public boolean feed_publishTemplatizedAction(String titleTemplate, String titleData, String bodyTemplate, String bodyData, String bodyGeneral, Collection<? extends IPair<? extends Object, URL>> pictures, String targetIds) throws FacebookException, IOException {
        return this.templatizedFeedHandler(null, FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, pictures, targetIds, null);
    }

    public boolean feed_publishTemplatizedAction(String titleTemplate, String titleData, String bodyTemplate, String bodyData, String bodyGeneral, Collection<? extends IPair<? extends Object, URL>> pictures, String targetIds, Long pageId) throws FacebookException, IOException {
        return this.templatizedFeedHandler(null, FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, pictures, targetIds, pageId);
    }

    @Override
    public boolean feed_PublishTemplatizedAction(TemplatizedAction action) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(action.getTitleTemplate(), action.getTitleParams(), action.getBodyTemplate(), action.getBodyParams(), action.getBodyGeneral(), action.getPictures(), action.getTargetIds(), action.getPageActorId());
    }

    protected boolean templatizedFeedHandler(Long actorId, FacebookMethod method, String titleTemplate, String titleData, String bodyTemplate, String bodyData, String bodyGeneral, Collection<? extends IPair<? extends Object, URL>> pictures, String targetIds, Long pageId) throws FacebookException, IOException {
        assert (pictures == null || pictures.size() <= 4);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(method.numParams());
        params.add(new Pair<String, String>("title_template", titleTemplate));
        if (titleData != null) {
            params.add(new Pair<String, String>("title_data", titleData));
        }
        if (bodyTemplate != null) {
            params.add(new Pair<String, String>("body_template", bodyTemplate));
            if (bodyData != null) {
                params.add(new Pair<String, String>("body_data", bodyData));
            }
        }
        if (bodyGeneral != null) {
            params.add(new Pair<String, String>("body_general", bodyGeneral));
        }
        if (pictures != null) {
            int count = 1;
            for (IPair<? extends Object, URL> iPair : pictures) {
                String url = iPair.getFirst().toString();
                if (url.startsWith("http://UID/")) {
                    url = url.substring("http://UID/".length());
                }
                params.add(new Pair<String, String>("image_" + count, url));
                if (iPair.getSecond() != null) {
                    params.add(new Pair<String, String>("image_" + count + "_link", ((Object)iPair.getSecond()).toString()));
                }
                ++count;
            }
        }
        if (targetIds != null) {
            params.add(new Pair<String, String>("target_ids", targetIds));
        }
        if (pageId != null) {
            params.add(new Pair<String, String>("page_actor_id", Long.toString(pageId)));
        }
        this.callMethod((IFacebookMethod)method, params);
        if (this.rawResponse == null) {
            return false;
        }
        return this.rawResponse.contains(">1<");
    }

    @Override
    public Document events_get(Long userId, Collection<Long> eventIds, Long startTime, Long endTime) throws FacebookException, IOException {
        boolean hasEnd;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.EVENTS_GET.numParams());
        boolean hasUserId = null != userId && 0L != userId;
        boolean hasEventIds = null != eventIds && !eventIds.isEmpty();
        boolean hasStart = null != startTime && 0L != startTime;
        boolean bl = hasEnd = null != endTime && 0L != endTime;
        if (hasUserId) {
            params.add(new Pair<String, String>("uid", Long.toString(userId)));
        }
        if (hasEventIds) {
            params.add(new Pair<String, CharSequence>("eids", FacebookRestClient.delimit(eventIds)));
        }
        if (hasStart) {
            params.add(new Pair<String, String>("start_time", startTime.toString()));
        }
        if (hasEnd) {
            params.add(new Pair<String, String>("end_time", endTime.toString()));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET, params);
    }

    @Override
    public Document events_getMembers(Number eventId) throws FacebookException, IOException {
        assert (null != eventId);
        return this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_MEMBERS, new Pair<String, String>("eid", eventId.toString()));
    }

    @Override
    public Document friends_areFriends(long userId1, long userId2) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, new Pair<String, String>("uids1", Long.toString(userId1)), new Pair<String, String>("uids2", Long.toString(userId2)));
    }

    @Override
    public Document friends_areFriends(Collection<Long> userIds1, Collection<Long> userIds2) throws FacebookException, IOException {
        assert (userIds1 != null && userIds2 != null);
        assert (!userIds1.isEmpty() && !userIds2.isEmpty());
        assert (userIds1.size() == userIds2.size());
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, new Pair<String, CharSequence>("uids1", FacebookRestClient.delimit(userIds1)), new Pair<String, CharSequence>("uids2", FacebookRestClient.delimit(userIds2)));
    }

    @Override
    public Document friends_get() throws FacebookException, IOException {
        if (this.cacheFriendsList == null) {
            this.cacheFriendsList = this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET, new Pair[0]);
        }
        return this.cacheFriendsList;
    }

    @Deprecated
    public List<Long> friends_getAsList() throws FacebookException, IOException {
        return FacebookRestClient.toFriendsList(this.friends_get());
    }

    public static List<Long> toFriendsList(Document doc) {
        NodeList uids = doc.getElementsByTagName("uid");
        ArrayList<Long> out = new ArrayList<Long>(uids.getLength());
        for (int i = 0; i < uids.getLength(); ++i) {
            out.add(Long.parseLong(uids.item(i).getFirstChild().getTextContent().trim()));
        }
        return out;
    }

    @Override
    public Document friends_getAppUsers() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_APP_USERS, new Pair[0]);
    }

    @Override
    public Document users_getStandardInfo(Collection<Long> userIds, Collection<ProfileField> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_STANDARD_INFO, new Pair<String, CharSequence>("uids", FacebookRestClient.delimit(userIds)), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    @Override
    public Document users_getStandardInfo(Collection<Long> userIds, Set<CharSequence> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_STANDARD_INFO, new Pair<String, CharSequence>("uids", FacebookRestClient.delimit(userIds)), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    @Override
    public Document users_getInfo(Collection<Long> userIds, Collection<ProfileField> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, new Pair<String, CharSequence>("uids", FacebookRestClient.delimit(userIds)), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    @Override
    public Document users_getInfo(Collection<Long> userIds, Set<CharSequence> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, new Pair<String, CharSequence>("uids", FacebookRestClient.delimit(userIds)), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    @Override
    public long users_getLoggedInUser() throws FacebookException, IOException {
        if (this.cacheUserId == null || this.batchMode) {
            Document d = this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_LOGGED_IN_USER, new Pair[0]);
            if (d == null) {
                return 0L;
            }
            this.cacheUserId = Long.parseLong(d.getFirstChild().getTextContent());
        }
        return this.cacheUserId;
    }

    @Override
    @Deprecated
    public boolean users_isAppAdded() throws FacebookException, IOException {
        if (this.cacheAppAdded == null) {
            this.cacheAppAdded = FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_ADDED, new Pair[0]));
        }
        return this.cacheAppAdded;
    }

    @Override
    public Boolean getCacheAppAdded() {
        return this.cacheAppAdded;
    }

    @Override
    public void setCacheAppAdded(Boolean value) {
        this.cacheAppAdded = value;
    }

    @Override
    public Document photos_get(Long subjId, Long albumId, Collection<Long> photoIds) throws FacebookException, IOException {
        boolean hasPhotoIds;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_GET.numParams());
        boolean hasUserId = null != subjId && 0L != subjId;
        boolean hasAlbumId = null != albumId && 0L != albumId;
        boolean bl = hasPhotoIds = null != photoIds && !photoIds.isEmpty();
        assert (hasUserId || hasAlbumId || hasPhotoIds);
        if (hasUserId) {
            params.add(new Pair<String, String>("subj_id", Long.toString(subjId)));
        }
        if (hasAlbumId) {
            params.add(new Pair<String, String>("aid", Long.toString(albumId)));
        }
        if (hasPhotoIds) {
            params.add(new Pair<String, CharSequence>("pids", FacebookRestClient.delimit(photoIds)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET, params);
    }

    public Document photos_get(Long albumId, Collection<Long> photoIds, boolean album) throws FacebookException, IOException {
        return this.photos_get((Long)null, albumId, (Collection)photoIds);
    }

    @Override
    public Document photos_get(Long subjId, Collection<Long> photoIds) throws FacebookException, IOException {
        return this.photos_get(subjId, (Long)null, (Collection)photoIds);
    }

    @Override
    public Document photos_get(Long subjId, Long albumId) throws FacebookException, IOException {
        return this.photos_get(subjId, albumId, (Collection)null);
    }

    @Override
    public Document photos_get(Collection<Long> photoIds) throws FacebookException, IOException {
        return this.photos_get((Long)null, (Long)null, (Collection)photoIds);
    }

    public Document photos_get(Long albumId, boolean album) throws FacebookException, IOException {
        return this.photos_get((Long)null, albumId, (Collection)null);
    }

    @Override
    public Document photos_get(Long subjId) throws FacebookException, IOException {
        return this.photos_get(subjId, (Long)null, (Collection)null);
    }

    @Override
    public Document photos_getAlbums(Long userId, Collection<Long> albumIds) throws FacebookException, IOException {
        boolean hasAlbumIds;
        boolean hasUserId = null != userId && userId != 0L;
        boolean bl = hasAlbumIds = null != albumIds && !albumIds.isEmpty();
        assert (hasUserId || hasAlbumIds);
        if (hasUserId) {
            return hasAlbumIds ? this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, new Pair<String, String>("uid", Long.toString(userId)), new Pair<String, CharSequence>("aids", FacebookRestClient.delimit(albumIds))) : this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, new Pair<String, String>("uid", Long.toString(userId)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, new Pair<String, CharSequence>("aids", FacebookRestClient.delimit(albumIds)));
    }

    @Override
    public Document photos_getAlbums(Long userId) throws FacebookException, IOException {
        return this.photos_getAlbums(userId, (Collection)null);
    }

    @Override
    public Document photos_getAlbums(Collection<Long> albumIds) throws FacebookException, IOException {
        return this.photos_getAlbums((Long)null, (Collection)albumIds);
    }

    @Override
    public Document photos_getTags(Collection<Long> photoIds) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_TAGS, new Pair<String, CharSequence>("pids", FacebookRestClient.delimit(photoIds)));
    }

    @Override
    public Document photos_createAlbum(String albumName) throws FacebookException, IOException {
        return this.photos_createAlbum(albumName, null, null);
    }

    @Override
    public Document photos_createAlbum(String name, String description, String location) throws FacebookException, IOException {
        assert (null != name && !"".equals(name));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_CREATE_ALBUM.numParams());
        params.add(new Pair<String, String>("name", name));
        if (null != description) {
            params.add(new Pair<String, String>("description", description));
        }
        if (null != location) {
            params.add(new Pair<String, String>("location", location));
        }
        return this.photos_createAlbum(FacebookMethod.PHOTOS_CREATE_ALBUM, params);
    }

    @Override
    public Document photos_addTags(Long photoId, Collection<PhotoTag> tags) throws FacebookException, IOException {
        assert (photoId > 0L);
        assert (null != tags && !tags.isEmpty());
        String tagStr = null;
        try {
            JSONArray jsonTags = new JSONArray();
            for (PhotoTag tag : tags) {
                jsonTags.put((Object)tag.jsonify());
            }
            tagStr = jsonTags.toString();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG, new Pair<String, String>("pid", photoId.toString()), new Pair<String, String>("tags", tagStr));
    }

    @Override
    public boolean photos_addTag(Long photoId, Long taggedUserId, Double xPct, Double yPct) throws FacebookException, IOException {
        return this.photos_addTag(photoId, xPct, yPct, taggedUserId, null);
    }

    @Override
    public boolean photos_addTag(Long photoId, CharSequence tagText, Double xPct, Double yPct) throws FacebookException, IOException {
        return this.photos_addTag(photoId, xPct, yPct, null, tagText);
    }

    private boolean photos_addTag(Long photoId, Double xPct, Double yPct, Long taggedUserId, CharSequence tagText) throws FacebookException, IOException {
        assert (null != photoId && !photoId.equals(0));
        assert (null != taggedUserId || null != tagText);
        assert (null != xPct && xPct >= 0.0 && xPct <= 100.0);
        assert (null != yPct && yPct >= 0.0 && yPct <= 100.0);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        Pair<String, String> tagData = taggedUserId != null ? new Pair<String, String>("tag_uid", taggedUserId.toString()) : new Pair<String, String>("tag_text", ((Object)tagText).toString());
        params.add(tagData);
        params.add(new Pair<String, String>("x", xPct.toString()));
        params.add(new Pair<String, String>("y", yPct.toString()));
        params.add(new Pair<String, String>("pid", photoId.toString()));
        return this.photos_addTag(FacebookMethod.PHOTOS_ADD_TAG, params);
    }

    @Override
    public Document photos_upload(File photo) throws FacebookException, IOException {
        return this.photos_upload(photo, null, null);
    }

    @Override
    public Document photos_upload(File photo, String caption) throws FacebookException, IOException {
        return this.photos_upload(photo, caption, null);
    }

    @Override
    public Document photos_upload(File photo, Long albumId) throws FacebookException, IOException {
        return this.photos_upload(photo, null, albumId);
    }

    @Override
    public Document photos_upload(File photo, String caption, Long albumId) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_UPLOAD.numParams());
        assert (photo.exists() && photo.canRead());
        this._uploadFile = photo;
        if (null != albumId) {
            params.add(new Pair<String, String>("aid", Long.toString(albumId)));
        }
        if (null != caption) {
            params.add(new Pair<String, String>("caption", caption));
        }
        return this.photos_upload(FacebookMethod.PHOTOS_UPLOAD, params);
    }

    @Override
    public Document groups_get(Long userId, Collection<Long> groupIds) throws FacebookException, IOException {
        boolean hasGroups;
        boolean bl = hasGroups = null != groupIds && !groupIds.isEmpty();
        if (null != userId) {
            return hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair<String, String>("uid", userId.toString()), new Pair<String, CharSequence>("gids", FacebookRestClient.delimit(groupIds))) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair<String, String>("uid", userId.toString()));
        }
        return hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair<String, CharSequence>("gids", FacebookRestClient.delimit(groupIds))) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair[0]);
    }

    @Override
    public Document groups_getMembers(Number groupId) throws FacebookException, IOException {
        assert (null != groupId);
        return this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET_MEMBERS, new Pair<String, String>("gid", groupId.toString()));
    }

    @Override
    public Document fql_query(CharSequence query) throws FacebookException, IOException {
        assert (null != query);
        return this.callMethod((IFacebookMethod)FacebookMethod.FQL_QUERY, new Pair<String, CharSequence>("query", query));
    }

    @Override
    public Document notifications_get() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_GET, new Pair[0]);
    }

    @Deprecated
    public URL notifications_sendRequest(Collection<Long> recipientIds, CharSequence type, CharSequence content, URL image, boolean isInvite) throws FacebookException, IOException {
        assert (null != recipientIds && !recipientIds.isEmpty());
        assert (null != type);
        assert (null != content);
        assert (null != image);
        Document d = this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_SEND_REQUEST, new Pair<String, CharSequence>("to_ids", FacebookRestClient.delimit(recipientIds)), new Pair<String, CharSequence>("type", type), new Pair<String, CharSequence>("content", content), new Pair<String, String>("image", image.toString()), new Pair<String, String>("invite", isInvite ? "1" : "0"));
        if (d == null) {
            return null;
        }
        String url = d.getFirstChild().getTextContent();
        return null == url || "".equals(url) ? null : new URL(url);
    }

    @Override
    @Deprecated
    public URL notifications_send(Collection<Long> recipientIds, CharSequence notification, CharSequence email) throws FacebookException, IOException {
        this.notifications_send(recipientIds, notification);
        return null;
    }

    public static boolean extractBoolean(Node doc) {
        if (doc == null) {
            return false;
        }
        String content = doc.getFirstChild().getTextContent();
        return "1".equals(content);
    }

    protected InputStream postFileRequest(String methodName, Map<String, String> params) throws IOException {
        return this.postFileRequest(methodName, params, true);
    }

    public InputStream postFileRequest(String methodName, Map<String, String> params, boolean doEncode) {
        assert (null != this._uploadFile);
        try {
            int i;
            BufferedInputStream bufin = new BufferedInputStream(new FileInputStream(this._uploadFile));
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            URLConnection con = this._serverUrl.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            con.setRequestProperty("MIME-version", TARGET_API_VERSION);
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            for (Map.Entry<String, String> entry : params.entrySet()) {
                out.writeBytes(PREF + boundary + CRLF);
                out.writeBytes("Content-disposition: form-data; name=\"" + entry.getKey() + "\"");
                out.writeBytes("\r\n\r\n");
                out.writeBytes(doEncode ? FacebookRestClient.encode(entry.getValue()) : entry.getValue().toString());
                out.writeBytes(CRLF);
            }
            out.writeBytes(PREF + boundary + CRLF);
            out.writeBytes("Content-disposition: form-data; filename=\"" + this._uploadFile.getName() + "\"" + CRLF);
            out.writeBytes("Content-Type: image/jpeg\r\n");
            out.writeBytes(CRLF);
            byte[] b = new byte[512];
            int byteCounter = 0;
            while (-1 != (i = bufin.read(b))) {
                byteCounter += i;
                out.write(b, 0, i);
            }
            out.writeBytes("\r\n--" + boundary + PREF + CRLF);
            out.flush();
            out.close();
            InputStream is = con.getInputStream();
            return is;
        }
        catch (Exception ex) {
            log.error((Object)("exception: " + ex), (Throwable)ex);
            return null;
        }
    }

    @Override
    public String auth_createToken() throws FacebookException, IOException {
        Document d = this.callMethod((IFacebookMethod)FacebookMethod.AUTH_CREATE_TOKEN, new Pair[0]);
        if (d == null) {
            return null;
        }
        return d.getFirstChild().getTextContent();
    }

    @Override
    public String auth_getSession(String authToken) throws FacebookException, IOException {
        Document d = this.callMethod((IFacebookMethod)FacebookMethod.AUTH_GET_SESSION, new Pair<String, String>("auth_token", authToken.toString()));
        if (d == null) {
            return null;
        }
        this.cacheSessionKey = d.getElementsByTagName("session_key").item(0).getFirstChild().getTextContent();
        this.cacheUserId = Long.parseLong(d.getElementsByTagName("uid").item(0).getFirstChild().getTextContent());
        this.cacheSessionExpires = Long.parseLong(d.getElementsByTagName("expires").item(0).getFirstChild().getTextContent());
        if (this._isDesktop) {
            this.cacheSessionSecret = d.getElementsByTagName("secret").item(0).getFirstChild().getTextContent();
        }
        return this.cacheSessionKey;
    }

    @Override
    public Object getResponsePOJO() {
        if (this.rawResponse == null) {
            return null;
        }
        if (JAXB_CONTEXT == null) {
            return null;
        }
        Object pojo = null;
        try {
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            pojo = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(this.rawResponse.getBytes("UTF-8")));
        }
        catch (JAXBException ex) {
            log.error((Object)"getResponsePOJO() - Could not unmarshall XML stream into POJO", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            log.error((Object)"getResponsePOJO() - Could not unmarshall XML stream into POJO", (Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"getResponsePOJO() - Could not unmarshall XML stream into POJO", (Throwable)ex);
        }
        return pojo;
    }

    @Override
    public String data_getUserPreference(Integer prefId) throws FacebookException, IOException {
        String result;
        if (prefId < 0 || prefId > 200) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The preference id must be an integer value from 0-200.");
        }
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_USER_PREFERENCE, new Pair<String, String>("pref_id", Integer.toString(prefId)));
        if (this.rawResponse == null || !this.rawResponse.contains("</data_getUserPreference_response>")) {
            return null;
        }
        if (this.rawResponse != null) {
            result = this.rawResponse.substring(0, this.rawResponse.indexOf("</data_getUserPreference_response>"));
            result = result.substring(result.indexOf("facebook.xsd\">") + "facebook.xsd\">".length());
        } else {
            result = null;
        }
        return this.reconstructValue(result);
    }

    @Override
    public Map<Integer, String> data_getUserPreferences() throws FacebookException, IOException {
        Document response = this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_USER_PREFERENCES, new Pair[0]);
        if (response == null) {
            return null;
        }
        TreeMap<Integer, String> results = new TreeMap<Integer, String>();
        NodeList ids = response.getElementsByTagName("pref_id");
        NodeList values = response.getElementsByTagName("value");
        for (int count = 0; count < ids.getLength(); ++count) {
            results.put(Integer.parseInt(ids.item(count).getFirstChild().getTextContent()), this.reconstructValue(values.item(count).getFirstChild().getTextContent()));
        }
        return results;
    }

    private void checkError() throws FacebookException {
        if (this.rawResponse.contains(ERROR_TAG)) {
            Integer code = Integer.parseInt(this.rawResponse.substring(this.rawResponse.indexOf("<error_code>") + "<error_code>".length(), this.rawResponse.indexOf("</error_code>") + "</error_code>".length()));
            throw new FacebookException(code, "The request could not be completed!");
        }
    }

    private String reconstructValue(String input) {
        if (input == null || "".equals(input)) {
            return null;
        }
        if (input.charAt(0) == '_') {
            return input.substring(1);
        }
        return input;
    }

    @Override
    public void data_setUserPreference(Integer prefId, String value) throws FacebookException, IOException {
        if (prefId < 0 || prefId > 200) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The preference id must be an integer value from 0-200.");
        }
        if (value != null && value.length() > 127) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The preference value cannot be longer than 128 characters.");
        }
        value = this.normalizePreferenceValue(value);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("pref_id", Integer.toString(prefId)));
        params.add(new Pair<String, String>("value", value));
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_USER_PREFERENCE, params);
        this.checkError();
    }

    @Override
    public void data_setUserPreferences(Map<Integer, String> values, boolean replace) throws FacebookException, IOException {
        JSONObject map = new JSONObject();
        for (Integer key : values.keySet()) {
            if (key < 0 || key > 200) {
                throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The preference id must be an integer value from 0-200.");
            }
            if (values.get(key) != null && values.get(key).length() > 127) {
                throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The preference value cannot be longer than 128 characters.");
            }
            try {
                map.put(Integer.toString(key), (Object)this.normalizePreferenceValue(values.get(key)));
            }
            catch (JSONException e) {
                FacebookException ex = new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "Error when translating {key=" + key + ", value=" + values.get(key) + "}to JSON!");
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("values", map.toString()));
        if (replace) {
            params.add(new Pair<String, String>("replace", "true"));
        }
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_USER_PREFERENCES, params);
        this.checkError();
    }

    private String normalizePreferenceValue(String input) {
        if (input == null) {
            return "0";
        }
        return "_" + input;
    }

    @Override
    public boolean sms_canSend() throws FacebookException, IOException {
        return this.sms_canSend(this.users_getLoggedInUser());
    }

    @Override
    public boolean sms_canSend(Long userId) throws FacebookException, IOException {
        this.callMethod((IFacebookMethod)FacebookMethod.SMS_CAN_SEND, new Pair<String, String>("uid", userId.toString()));
        if (this.rawResponse == null) {
            return false;
        }
        return this.rawResponse.contains(">0<");
    }

    @Override
    public Integer sms_send(String message, Integer smsSessionId, boolean makeNewSession) throws FacebookException, IOException {
        return this.sms_send(this.users_getLoggedInUser(), message, smsSessionId, makeNewSession);
    }

    @Override
    public Integer sms_send(Long userId, String message, Integer smsSessionId, boolean makeNewSession) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("uid", userId.toString()));
        params.add(new Pair<String, String>("message", message));
        if (smsSessionId != null) {
            params.add(new Pair<String, String>("session_id", smsSessionId.toString()));
        }
        if (makeNewSession) {
            params.add(new Pair<String, String>("req_session", "true"));
        }
        this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND, params);
        Integer response = null;
        if (this.rawResponse != null && this.rawResponse.indexOf("</sms") != -1 && makeNewSession) {
            String result = this.rawResponse.substring(0, this.rawResponse.indexOf("</sms"));
            result = result.substring(result.lastIndexOf(">") + 1);
            response = Integer.parseInt(result);
        }
        return response;
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear) throws FacebookException, IOException {
        return this.users_setStatus(newStatus, clear, false);
    }

    @Override
    public boolean fbml_setRefHandle(String handle, String markup) throws FacebookException, IOException {
        if (this._isDesktop) {
            return false;
        }
        if (handle == null || "".equals(handle)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The FBML handle may not be null or empty!");
        }
        if (markup == null) {
            markup = "";
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("handle", handle));
        params.add(new Pair<String, String>("fbml", markup));
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_SET_REF_HANDLE, params));
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, String attributes) throws FacebookException, IOException {
        MarketListing test;
        if (listingId == null) {
            listingId = 0L;
        }
        if (!(test = new MarketListing(attributes)).verify()) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The specified listing is invalid!");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("listing_id", listingId.toString()));
        if (showOnProfile) {
            params.add(new Pair<String, String>("show_on_profile", "true"));
        }
        params.add(new Pair<String, String>("listing_attrs", attributes));
        return this.marketplace_createListing(FacebookMethod.MARKET_CREATE_LISTING, params);
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, MarketListing listing) throws FacebookException, IOException {
        return this.marketplace_createListing(listingId, showOnProfile, listing.getAttribs());
    }

    @Override
    public Long marketplace_createListing(boolean showOnProfile, MarketListing listing) throws FacebookException, IOException {
        return this.marketplace_createListing((Long)0L, showOnProfile, listing.getAttribs());
    }

    public Long marketplace_createListing(Long listingId, boolean showOnProfile, JSONObject listing) throws FacebookException, IOException {
        return this.marketplace_createListing(listingId, showOnProfile, listing.toString());
    }

    public Long marketplace_createListing(boolean showOnProfile, JSONObject listing) throws FacebookException, IOException {
        return this.marketplace_createListing((Long)0L, showOnProfile, listing.toString());
    }

    @Override
    public List<String> marketplace_getCategories() throws FacebookException, IOException {
        this.callMethod((IFacebookMethod)FacebookMethod.MARKET_GET_CATEGORIES, new Pair[0]);
        if (this.rawResponse == null) {
            return null;
        }
        MarketplaceGetCategoriesResponse resp = (MarketplaceGetCategoriesResponse)this.getResponsePOJO();
        return resp.getMarketplaceCategory();
    }

    @Override
    public Document marketplace_getCategoriesObject() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKET_GET_CATEGORIES, new Pair[0]);
    }

    @Override
    public List<String> marketplace_getSubCategories() throws FacebookException, IOException {
        this.callMethod((IFacebookMethod)FacebookMethod.MARKET_GET_SUBCATEGORIES, new Pair[0]);
        if (this.rawResponse == null) {
            return null;
        }
        MarketplaceGetSubCategoriesResponse resp = (MarketplaceGetSubCategoriesResponse)this.getResponsePOJO();
        return resp.getMarketplaceSubcategory();
    }

    @Override
    public List<Listing> marketplace_getListings(List<Long> listingIds, List<Long> uids) throws FacebookException, IOException {
        String listings = this.stringify(listingIds);
        String users = this.stringify(uids);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (listings != null) {
            params.add(new Pair<String, String>("listing_ids", listings));
        }
        if (uids != null) {
            params.add(new Pair<String, String>("uids", users));
        }
        this.callMethod((IFacebookMethod)FacebookMethod.MARKET_GET_LISTINGS, params);
        if (this.rawResponse == null) {
            return null;
        }
        MarketplaceGetListingsResponse resp = (MarketplaceGetListingsResponse)this.getResponsePOJO();
        return resp.getListing();
    }

    private String stringify(List input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        String result = "";
        for (Object elem : input) {
            if (!"".equals(result)) {
                result = result + ",";
            }
            result = result + elem.toString();
        }
        return result;
    }

    @Override
    public List<Listing> marketplace_search(MarketListingCategory category, MarketListingSubcategory subcategory, String searchTerm) throws FacebookException, IOException {
        if ("".equals(searchTerm)) {
            searchTerm = null;
        }
        if (subcategory != null && category == null) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You cannot search by subcategory without also specifying a category!");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (category != null) {
            params.add(new Pair<String, String>("category", category.getName()));
        }
        if (subcategory != null) {
            params.add(new Pair<String, String>("subcategory", subcategory.getName()));
        }
        if (searchTerm != null) {
            params.add(new Pair<String, String>("query", searchTerm));
        }
        this.callMethod((IFacebookMethod)FacebookMethod.MARKET_SEARCH, params);
        if (this.rawResponse == null) {
            return null;
        }
        MarketplaceSearchResponse resp = (MarketplaceSearchResponse)this.getResponsePOJO();
        return resp.getListing();
    }

    @Override
    public boolean marketplace_removeListing(Long listingId, MarketListingStatus status) throws FacebookException, IOException {
        if (status == null) {
            status = MarketListingStatus.DEFAULT;
        }
        if (listingId == null) {
            return false;
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("listing_id", listingId.toString()));
        params.add(new Pair<String, String>("status", status.getName()));
        return this.marketplace_removeListing(FacebookMethod.MARKET_REMOVE_LISTING, params);
    }

    @Override
    public boolean users_clearStatus() throws FacebookException, IOException {
        return this.users_setStatus(null, true);
    }

    @Override
    @Deprecated
    public Long marketplace_editListing(Long listingId, Boolean showOnProfile, MarketplaceListing attrs) throws FacebookException, IOException {
        return this.marketplace_createListing(listingId, (boolean)showOnProfile, attrs.getAttribs());
    }

    @Override
    public Long marketplace_editListing(Long listingId, Boolean showOnProfile, MarketListing attrs) throws FacebookException, IOException {
        return this.marketplace_createListing(listingId, (boolean)showOnProfile, attrs);
    }

    @Override
    @Deprecated
    public Long marketplace_createListing(Boolean showOnProfile, MarketplaceListing attrs) throws FacebookException, IOException {
        return this.marketplace_createListing(null, (boolean)showOnProfile, attrs.getAttribs());
    }

    @Override
    @Deprecated
    public long auth_getUserId(String authToken) throws FacebookException, IOException {
        if (null == this.cacheSessionKey) {
            this.auth_getSession(authToken);
        }
        return this.users_getLoggedInUser();
    }

    @Override
    public boolean feed_publishTemplatizedAction(Long actorId, CharSequence titleTemplate) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(actorId, (CharSequence)(titleTemplate == null ? null : ((Object)titleTemplate).toString()), null, null, null, null, null, null);
    }

    @Override
    public boolean feed_publishTemplatizedAction(Long actorId, CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images) throws FacebookException, IOException {
        return this.feed_publishTemplatizedActionInternal(actorId, titleTemplate == null ? null : ((Object)titleTemplate).toString(), this.mapToJsonString(titleData), bodyTemplate == null ? null : ((Object)bodyTemplate).toString(), this.mapToJsonString(bodyData), bodyGeneral == null ? null : ((Object)bodyGeneral).toString(), images, targetIds, null);
    }

    private String mapToJsonString(Map<String, CharSequence> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        JSONObject titleDataJson = new JSONObject();
        for (String key : map.keySet()) {
            try {
                titleDataJson.put(key, (Object)map.get(key));
            }
            catch (Exception ignored) {}
        }
        return titleDataJson.toString();
    }

    private boolean feed_publishTemplatizedActionInternal(Long actor, String titleTemp, String titleData, String bodyTemp, String bodyData, String bodyGeneral, Collection<? extends IPair<? extends Object, URL>> images, Collection<Long> targetIds, Long pageId) throws FacebookException, IOException {
        if (targetIds != null && !targetIds.isEmpty()) {
            return this.templatizedFeedHandler(actor, FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, titleTemp, titleData, bodyTemp, bodyData, bodyGeneral, images, ((Object)FacebookRestClient.delimit(targetIds)).toString(), pageId);
        }
        return this.templatizedFeedHandler(actor, FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, titleTemp, titleData, bodyTemp, bodyData, bodyGeneral, images, null, pageId);
    }

    @Override
    @Deprecated
    public Document marketplace_getListings(Collection<Long> listingIds, Collection<Long> userIds) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.MARKETPLACE_GET_LISTINGS.numParams());
        if (null != listingIds && !listingIds.isEmpty()) {
            params.add(new Pair<String, CharSequence>("listing_ids", FacebookRestClient.delimit(listingIds)));
        }
        if (null != userIds && !userIds.isEmpty()) {
            params.add(new Pair<String, CharSequence>("uids", FacebookRestClient.delimit(userIds)));
        }
        assert (!params.isEmpty()) : "Either listingIds or userIds should be provided";
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_LISTINGS, params);
    }

    @Override
    public Document marketplace_getSubCategories(CharSequence category) throws FacebookException, IOException {
        if (category != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.MARKET_GET_SUBCATEGORIES, new Pair<String, CharSequence>("category", category));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKET_GET_SUBCATEGORIES, new Pair[0]);
    }

    @Override
    public boolean marketplace_removeListing(Long listingId) throws FacebookException, IOException {
        return this.marketplace_removeListing(listingId, MarketListingStatus.DEFAULT);
    }

    @Override
    @Deprecated
    public boolean marketplace_removeListing(Long listingId, CharSequence status) throws FacebookException, IOException {
        return this.marketplace_removeListing(listingId);
    }

    @Override
    @Deprecated
    public Document marketplace_search(CharSequence category, CharSequence subCategory, CharSequence query) throws FacebookException, IOException {
        if ("".equals(query)) {
            query = null;
        }
        if (subCategory != null && category == null) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You cannot search by subcategory without also specifying a category!");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (category != null) {
            params.add(new Pair<String, CharSequence>("category", category));
        }
        if (subCategory != null) {
            params.add(new Pair<String, CharSequence>("subcategory", subCategory));
        }
        if (query != null) {
            params.add(new Pair<String, CharSequence>("query", query));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKET_SEARCH, params);
    }

    @Override
    public boolean users_hasAppPermission(Permission perm) throws FacebookException, IOException {
        return this.users_hasAppPermission(perm, null);
    }

    @Override
    public boolean users_hasAppPermission(Permission perm, Long userId) throws FacebookException, IOException {
        if (userId != null) {
            return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_HAS_APP_PERMISSION_NOSESSION, FacebookRestClient.newPair("ext_perm", perm.getName()), FacebookRestClient.newPair("uid", userId)));
        }
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_HAS_APP_PERMISSION, FacebookRestClient.newPair("ext_perm", perm.getName())));
    }

    @Override
    public boolean users_setStatus(String status) throws FacebookException, IOException {
        return this.users_setStatus(status, false);
    }

    @Override
    public Document photos_getByAlbum(Long albumId, Collection<Long> photoIds) throws FacebookException, IOException {
        return this.photos_get((Long)null, albumId, (Collection)photoIds);
    }

    @Override
    public Document photos_getByAlbum(Long albumId) throws FacebookException, IOException {
        return this.photos_get((Long)null, albumId, (Collection)null);
    }

    public void sms_sendResponse(Integer userId, CharSequence response, Integer mobileSessionId) throws FacebookException, IOException {
        this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, new Pair<String, String>("uid", userId.toString()), new Pair<String, CharSequence>("message", response), new Pair<String, String>("session_id", mobileSessionId.toString()));
    }

    @Override
    public void sms_sendMessage(Long userId, CharSequence message) throws FacebookException, IOException {
        this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, new Pair<String, String>("uid", userId.toString()), new Pair<String, CharSequence>("message", message), new Pair<String, String>("req_session", "0"));
    }

    @Override
    public int sms_sendMessageWithSession(Long userId, CharSequence message) throws FacebookException, IOException {
        return FacebookRestClient.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, new Pair<String, String>("uid", userId.toString()), new Pair<String, CharSequence>("message", message), new Pair<String, String>("req_session", "1")));
    }

    public static int extractInt(Node doc) {
        if (doc == null) {
            return 0;
        }
        return Integer.parseInt(doc.getFirstChild().getTextContent());
    }

    @Override
    public Document pages_getInfo(Collection<Long> pageIds, EnumSet<PageProfileField> fields) throws FacebookException, IOException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        FacebookMethod method = null == this.cacheSessionKey ? FacebookMethod.PAGES_GET_INFO_NO_SESSION : FacebookMethod.PAGES_GET_INFO;
        return this.callMethod((IFacebookMethod)method, new Pair<String, CharSequence>("page_ids", FacebookRestClient.delimit(pageIds)), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    @Override
    public Document pages_getInfo(Collection<Long> pageIds, Set<CharSequence> fields) throws FacebookException, IOException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        FacebookMethod method = null == this.cacheSessionKey ? FacebookMethod.PAGES_GET_INFO_NO_SESSION : FacebookMethod.PAGES_GET_INFO;
        return this.callMethod((IFacebookMethod)method, new Pair<String, CharSequence>("page_ids", FacebookRestClient.delimit(pageIds)), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    @Override
    public Document pages_getInfo(Long userId, EnumSet<PageProfileField> fields) throws FacebookException, IOException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this.cacheUserId;
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, new Pair<String, String>("uid", userId.toString()), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    @Override
    public Document pages_getInfo(Long userId, Set<CharSequence> fields) throws FacebookException, IOException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this.cacheUserId;
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, new Pair<String, String>("uid", userId.toString()), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    @Override
    public boolean pages_isAppAdded(Long pageId) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_APP_ADDED, new Pair<String, String>("page_id", pageId.toString())));
    }

    @Override
    public boolean pages_isFan(Long pageId, Long userId) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, new Pair<String, String>("page_id", pageId.toString()), new Pair<String, String>("uid", userId.toString())));
    }

    @Override
    public boolean pages_isFan(Long pageId) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, new Pair<String, String>("page_id", pageId.toString())));
    }

    @Override
    public boolean pages_isAdmin(Long pageId) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_ADMIN, new Pair<String, String>("page_id", pageId.toString())));
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(Integer actorId, CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction((long)actorId, titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, targetIds, images);
    }

    @Override
    public void notifications_send(Collection<Long> recipientIds, CharSequence notification) throws FacebookException, IOException {
        this.notifications_send(recipientIds, ((Object)notification).toString(), false);
    }

    private Document notifications_sendEmail(CharSequence recipients, CharSequence subject, CharSequence email, CharSequence fbml) throws FacebookException, IOException {
        String paramValue;
        if (null == recipients || "".equals(recipients)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You must specify at least one recipient when sending an email!");
        }
        if ((null == email || "".equals(email)) && (null == fbml || "".equals(fbml))) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You cannot send an empty email!");
        }
        String paramName = "text";
        if (email == null || "".equals(((Object)email).toString())) {
            paramValue = ((Object)fbml).toString();
            paramName = "fbml";
        } else {
            paramValue = ((Object)email).toString();
        }
        FacebookMethod method = this.isDesktop() ? FacebookMethod.NOTIFICATIONS_SEND_EMAIL_SESSION : FacebookMethod.NOTIFICATIONS_SEND_EMAIL;
        Document d = subject != null && !"".equals(subject) ? this.callMethod((IFacebookMethod)method, new Pair<String, CharSequence>("recipients", recipients), new Pair<String, CharSequence>("subject", subject), new Pair<String, String>(paramName, paramValue)) : this.callMethod((IFacebookMethod)method, new Pair<String, CharSequence>("recipients", recipients), new Pair<String, String>(paramName, paramValue));
        return d;
    }

    @Override
    public Document notifications_sendEmail(Collection<Long> recipients, CharSequence subject, CharSequence email, CharSequence fbml) throws FacebookException, IOException {
        return this.notifications_sendEmail(FacebookRestClient.delimit(recipients), subject, email, fbml);
    }

    @Override
    public Document notifications_sendEmailToCurrentUser(String subject, String email, String fbml) throws FacebookException, IOException {
        Long currentUser = this.users_getLoggedInUser();
        return this.notifications_sendEmail(currentUser.toString(), (CharSequence)subject, (CharSequence)email, (CharSequence)fbml);
    }

    @Override
    public Document notifications_sendFbmlEmail(Collection<Long> recipients, String subject, String fbml) throws FacebookException, IOException {
        return this.notifications_sendEmail(FacebookRestClient.delimit(recipients), (CharSequence)subject, null, (CharSequence)fbml);
    }

    @Override
    public Document notifications_sendFbmlEmailToCurrentUser(String subject, String fbml) throws FacebookException, IOException {
        Long currentUser = this.users_getLoggedInUser();
        return this.notifications_sendEmail(currentUser.toString(), (CharSequence)subject, null, (CharSequence)fbml);
    }

    @Override
    public Document notifications_sendTextEmail(Collection<Long> recipients, String subject, String email) throws FacebookException, IOException {
        return this.notifications_sendEmail(FacebookRestClient.delimit(recipients), (CharSequence)subject, (CharSequence)email, null);
    }

    @Override
    public Document notifications_sendTextEmailToCurrentUser(String subject, String email) throws FacebookException, IOException {
        Long currentUser = this.users_getLoggedInUser();
        return this.notifications_sendEmail(currentUser.toString(), (CharSequence)subject, (CharSequence)email, null);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, boolean statusIncludesVerb) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (newStatus != null) {
            params.add(new Pair<String, String>("status", newStatus));
        }
        if (clear) {
            params.add(new Pair<String, String>("clear", "1"));
        }
        if (statusIncludesVerb) {
            params.add(new Pair<String, String>("status_includes_verb", "true"));
        }
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS, params));
    }

    @Override
    public void notifications_send(CharSequence notification) throws FacebookException, IOException {
        Long currentUser = this.users_getLoggedInUser();
        ArrayList<Long> coll = new ArrayList<Long>();
        coll.add(currentUser);
        this.notifications_send(coll, notification);
    }

    @Override
    @Deprecated
    public String notifications_sendEmailStr(Collection<Long> recipientIds, CharSequence subject, CharSequence fbml, CharSequence text) throws FacebookException, IOException {
        boolean hasFbml;
        if (null == recipientIds || recipientIds.isEmpty()) {
            throw new IllegalArgumentException("List of email recipients cannot be empty");
        }
        boolean hasText = null != text && 0 != text.length();
        boolean bl = hasFbml = null != fbml && 0 != fbml.length();
        if (!hasText && !hasFbml) {
            throw new IllegalArgumentException("Text and/or fbml must not be empty");
        }
        ArrayList<Pair<String, CharSequence>> args = new ArrayList<Pair<String, CharSequence>>(4);
        args.add(new Pair<String, CharSequence>("recipients", FacebookRestClient.delimit(recipientIds)));
        args.add(new Pair<String, CharSequence>("subject", subject));
        if (hasText) {
            args.add(new Pair<String, CharSequence>("text", text));
        }
        if (hasFbml) {
            args.add(new Pair<String, CharSequence>("fbml", fbml));
        }
        Document result = this.callMethod((IFacebookMethod)(this.isDesktop() ? FacebookMethod.NOTIFICATIONS_SEND_EMAIL_SESSION : FacebookMethod.NOTIFICATIONS_SEND_EMAIL), args);
        return FacebookRestClient.extractString(result);
    }

    @Override
    @Deprecated
    public String notifications_sendEmail(Collection<Long> recipientIds, CharSequence subject, CharSequence fbml) throws FacebookException, IOException {
        return this.notifications_sendEmailStr(recipientIds, subject, fbml, null);
    }

    @Override
    @Deprecated
    public String notifications_sendEmailPlain(Collection<Long> recipientIds, CharSequence subject, CharSequence text) throws FacebookException, IOException {
        return this.notifications_sendEmailStr(recipientIds, subject, null, text);
    }

    public static String extractString(Node d) {
        if (d == null) {
            return null;
        }
        return d.getFirstChild().getTextContent();
    }

    @Override
    public boolean admin_setAppProperties(Map<ApplicationProperty, String> properties) throws FacebookException, IOException {
        if (this._isDesktop) {
            return false;
        }
        if (properties == null || properties.isEmpty()) {
            return true;
        }
        JSONObject encoding1 = new JSONObject();
        JSONArray encoding2 = new JSONArray();
        for (ApplicationProperty property : properties.keySet()) {
            JSONObject temp = new JSONObject();
            if (property.getType().equals("string")) {
                try {
                    encoding1.put(property.getName(), (Object)properties.get((Object)property));
                    temp.put(property.getName(), (Object)properties.get((Object)property));
                    encoding2.put((Object)temp);
                }
                catch (JSONException ignored) {}
                continue;
            }
            String val = properties.get((Object)property);
            val = val == null || val.equals("") || val.equalsIgnoreCase("false") || val.equals("0") ? "0" : "1";
            try {
                encoding1.put(property.getName(), (Object)val);
                temp.put(property.getName(), (Object)val);
                encoding2.put((Object)temp);
            }
            catch (JSONException ignored) {}
        }
        try {
            Document d = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, new Pair<String, String>("properties", encoding1.toString()));
            return FacebookRestClient.extractBoolean(d);
        }
        catch (FacebookException e) {
            Document d = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, new Pair<String, String>("properties", encoding2.toString()));
            return FacebookRestClient.extractBoolean(d);
        }
    }

    @Override
    @Deprecated
    public JSONObject admin_getAppProperties(Collection<ApplicationProperty> properties) throws FacebookException, IOException {
        String json = this.admin_getAppPropertiesAsString(properties);
        if (json == null) {
            return null;
        }
        try {
            if (json.matches("\\{.*\\}")) {
                return new JSONObject(json);
            }
            JSONArray temp = new JSONArray(json);
            JSONObject result = new JSONObject();
            for (int count = 0; count < temp.length(); ++count) {
                JSONObject obj = (JSONObject)temp.get(count);
                Iterator it = obj.keys();
                while (it.hasNext()) {
                    String next = (String)it.next();
                    result.put(next, obj.get(next));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new FacebookException(ErrorCode.GEN_SERVICE_ERROR, "Failed to parse server response:  " + json);
        }
    }

    @Override
    public Map<ApplicationProperty, String> admin_getAppPropertiesMap(Collection<ApplicationProperty> properties) throws FacebookException, IOException {
        String[] parts;
        LinkedHashMap<ApplicationProperty, String> result = new LinkedHashMap<ApplicationProperty, String>();
        String json = this.admin_getAppPropertiesAsString(properties);
        if (json == null) {
            return null;
        }
        json = json.matches("\\{.*\\}") ? json.substring(1, json.lastIndexOf("}")) : json.substring(1, json.lastIndexOf("]"));
        for (String part : parts = json.split("\\,")) {
            this.parseFragment(part, result);
        }
        return result;
    }

    private void parseFragment(String fragment, Map<ApplicationProperty, String> result) {
        if (fragment.startsWith("{")) {
            fragment = fragment.substring(1, fragment.lastIndexOf("}"));
        }
        String keyString = fragment.substring(1);
        keyString = keyString.substring(0, keyString.indexOf(34));
        ApplicationProperty key = ApplicationProperty.getPropertyForString(keyString);
        String value = fragment.substring(fragment.indexOf(":") + 1).replaceAll("\\\\", "");
        if (key.getType().equals("string")) {
            result.put(key, value.substring(1, value.lastIndexOf(34)));
        } else if (value.equals("1")) {
            result.put(key, "true");
        } else {
            result.put(key, "false");
        }
    }

    @Override
    public String admin_getAppPropertiesAsString(Collection<ApplicationProperty> properties) throws FacebookException, IOException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'admin.getAppProperties'");
        }
        JSONArray props = new JSONArray();
        for (ApplicationProperty property : properties) {
            props.put((Object)property.getName());
        }
        Document d = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_APP_PROPERTIES, new Pair<String, String>("properties", props.toString()));
        return FacebookRestClient.extractString(d);
    }

    @Override
    public Document data_getCookies() throws FacebookException, IOException {
        return this.data_getCookies(this.users_getLoggedInUser(), null);
    }

    @Override
    public Document data_getCookies(Long userId) throws FacebookException, IOException {
        return this.data_getCookies(userId, null);
    }

    @Override
    public Document data_getCookies(String name) throws FacebookException, IOException {
        return this.data_getCookies(this.users_getLoggedInUser(), name);
    }

    @Override
    public Document data_getCookies(Long userId, CharSequence name) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> args = new ArrayList<Pair<String, CharSequence>>();
        args.add(new Pair<String, String>("uid", Long.toString(userId)));
        if (name != null && !"".equals(name)) {
            args.add(new Pair<String, CharSequence>("name", name));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_COOKIES, args);
    }

    @Override
    public boolean data_setCookie(String name, String value) throws FacebookException, IOException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, null, null);
    }

    @Override
    public boolean data_setCookie(String name, String value, String path) throws FacebookException, IOException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, null, path);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value) throws FacebookException, IOException {
        return this.data_setCookie(userId, name, value, null, null);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, CharSequence path) throws FacebookException, IOException {
        return this.data_setCookie(userId, name, value, null, path);
    }

    @Override
    public boolean data_setCookie(String name, String value, Long expires) throws FacebookException, IOException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, expires, null);
    }

    @Override
    public boolean data_setCookie(String name, String value, Long expires, String path) throws FacebookException, IOException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, expires, path);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, Long expires) throws FacebookException, IOException {
        return this.data_setCookie(userId, name, value, expires, null);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, Long expires, CharSequence path) throws FacebookException, IOException {
        if (name == null || "".equals(name)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The cookie name cannot be null or empty!");
        }
        if (value == null) {
            value = "";
        }
        ArrayList<Pair<String, CharSequence>> args = new ArrayList<Pair<String, CharSequence>>();
        args.add(new Pair<String, String>("uid", Long.toString(userId)));
        args.add(new Pair<String, CharSequence>("name", name));
        args.add(new Pair<String, CharSequence>("value", value));
        if (expires != null && expires > 0L) {
            args.add(new Pair<String, String>("expires", expires.toString()));
        }
        if (path != null && !"".equals(path)) {
            args.add(new Pair<String, CharSequence>("path", path));
        }
        Document doc = this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_COOKIE, args);
        return FacebookRestClient.extractBoolean(doc);
    }

    @Override
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(titleTemplate, null);
    }

    @Override
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Long pageActorId) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(titleTemplate, null, null, null, null, null, null, pageActorId);
    }

    @Override
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images, Long pageActorId) throws FacebookException, IOException {
        return this.feed_publishTemplatizedActionInternal(null, titleTemplate == null ? null : ((Object)titleTemplate).toString(), this.mapToJsonString(titleData), bodyTemplate == null ? null : ((Object)bodyTemplate).toString(), this.mapToJsonString(bodyData), bodyGeneral == null ? null : ((Object)bodyGeneral).toString(), images, targetIds, pageActorId);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, FacebookRestClient.toString(profileFbmlMarkup), FacebookRestClient.toString(profileActionFbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, FacebookRestClient.toString(profileFbmlMarkup), FacebookRestClient.toString(profileActionFbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, FacebookRestClient.toString(profileFbmlMarkup), FacebookRestClient.toString(profileActionFbmlMarkup), FacebookRestClient.toString(mobileFbmlMarkup), null);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, FacebookRestClient.toString(profileFbmlMarkup), FacebookRestClient.toString(profileActionFbmlMarkup), FacebookRestClient.toString(mobileFbmlMarkup), null);
    }

    @Override
    public boolean profile_setMobileFBML(CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, null, null, FacebookRestClient.toString(fbmlMarkup), null);
    }

    @Override
    public boolean profile_setMobileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, null, null, FacebookRestClient.toString(fbmlMarkup), null);
    }

    @Override
    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, null, FacebookRestClient.toString(fbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, null, FacebookRestClient.toString(fbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setProfileFBML(CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, FacebookRestClient.toString(fbmlMarkup), null, null, null);
    }

    @Override
    public boolean profile_setProfileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileId, FacebookRestClient.toString(fbmlMarkup), null, null, null);
    }

    @Override
    public boolean profile_setFBML(Long userId, String profileFbml, String actionFbml, String mobileFbml) throws FacebookException, IOException {
        return this.profile_setFBML(userId, profileFbml, actionFbml, mobileFbml, null);
    }

    @Override
    public boolean profile_setFBML(Long userId, String profileFbml, String actionFbml, String mobileFbml, String profileMain) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        FacebookRestClient.addParamIfNotBlank("uid", userId, params);
        FacebookRestClient.addParamIfNotBlank("profile", profileFbml, params);
        FacebookRestClient.addParamIfNotBlank("profile_action", actionFbml, params);
        FacebookRestClient.addParamIfNotBlank("mobile_fbml", mobileFbml, params);
        FacebookRestClient.addParamIfNotBlank("profile_main", profileMain, params);
        FacebookMethod method = this.isDesktop() || userId == null ? FacebookMethod.PROFILE_SET_FBML : FacebookMethod.PROFILE_SET_FBML_NOSESSION;
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)method, params));
    }

    @Override
    public Document friends_get(Long friendListId) throws FacebookException, IOException {
        FacebookMethod method = FacebookMethod.FRIENDS_GET;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(method.numParams());
        if (null != friendListId) {
            if (0L >= friendListId) {
                throw new IllegalArgumentException("given invalid friendListId " + friendListId.toString());
            }
            params.add(new Pair<String, String>("flid", friendListId.toString()));
        }
        return this.callMethod((IFacebookMethod)method, params);
    }

    @Override
    public Document friends_getLists() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_LISTS, new Pair[0]);
    }

    @Override
    public boolean admin_setAppProperties(ApplicationPropertySet properties) throws FacebookException, IOException {
        if (this._isDesktop) {
            return false;
        }
        if (null == properties || properties.isEmpty()) {
            throw new IllegalArgumentException("expecting a non-empty set of application properties");
        }
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, new Pair<String, String>("properties", properties.toJsonString())));
    }

    @Override
    public ApplicationPropertySet admin_getAppPropertiesAsSet(EnumSet<ApplicationProperty> properties) throws FacebookException, IOException {
        String propJson = this.admin_getAppPropertiesAsString(properties);
        return new ApplicationPropertySet(propJson);
    }

    @Override
    public Document application_getPublicInfo(Long applicationId, String applicationKey, String applicationCanvas) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (applicationId != null && applicationId > 0L) {
            params.add(new Pair<String, String>("application_id", Long.toString(applicationId)));
        } else if (applicationKey != null && !"".equals(applicationKey)) {
            params.add(new Pair<String, String>("application_api_key", applicationKey));
        } else if (applicationCanvas != null && !"".equals(applicationCanvas)) {
            params.add(new Pair<String, String>("application_canvas_name", applicationCanvas));
        } else {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You must specify at least on of {applicationId, applicationKey, applicationCanvas}");
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.APPLICATION_GET_PUBLIC_INFO, params);
    }

    @Override
    public Document application_getPublicInfoById(Long applicationId) throws FacebookException, IOException {
        return this.application_getPublicInfo(applicationId, null, null);
    }

    @Override
    public Document application_getPublicInfoByApiKey(String applicationKey) throws FacebookException, IOException {
        return this.application_getPublicInfo(null, applicationKey, null);
    }

    @Override
    public Document application_getPublicInfoByCanvasName(String applicationCanvas) throws FacebookException, IOException {
        return this.application_getPublicInfo(null, null, applicationCanvas);
    }

    @Override
    public int admin_getAllocation(String allocationType) throws FacebookException, IOException {
        return FacebookRestClient.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_ALLOCATION, new Pair<String, String>("integration_point_name", allocationType)));
    }

    @Override
    public int admin_getAllocation(AllocationType allocationType) throws FacebookException, IOException {
        return this.admin_getAllocation(allocationType.getName());
    }

    @Override
    @Deprecated
    public int admin_getNotificationAllocation() throws FacebookException, IOException {
        return this.admin_getAllocation("notifications_per_day");
    }

    @Override
    @Deprecated
    public int admin_getRequestAllocation() throws FacebookException, IOException {
        return this.admin_getAllocation("requests_per_day");
    }

    @Override
    @Deprecated
    public Document admin_getDailyMetrics(Set<Metric> metrics, Date start, Date end) throws FacebookException, IOException {
        return this.admin_getDailyMetrics((Set)metrics, start.getTime(), end.getTime());
    }

    @Override
    @Deprecated
    public Document admin_getDailyMetrics(Set<Metric> metrics, long start, long end) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        metrics.remove((Object)Metric.ACTIVE_USERS);
        if (metrics != null && !metrics.isEmpty()) {
            JSONArray metricsJson = new JSONArray();
            for (Metric metric : metrics) {
                metricsJson.put((Object)metric.getName());
            }
            params.add(new Pair<String, String>("metrics", metricsJson.toString()));
        }
        params.add(new Pair<String, String>("start_date", Long.toString(start / 1000L)));
        params.add(new Pair<String, String>("end_date", Long.toString(end / 1000L)));
        return this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_DAILY_METRICS, params);
    }

    @Override
    public Document admin_getMetrics(Set<Metric> metrics, Date start, Date end, long period) throws FacebookException, IOException {
        return this.admin_getMetrics((Set)metrics, start.getTime(), end.getTime(), period);
    }

    @Override
    public Document admin_getMetrics(Set<Metric> metrics, long start, long end, long period) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        metrics.remove((Object)Metric.DAILY_ACTIVE_USERS);
        if (metrics != null && !metrics.isEmpty()) {
            JSONArray metricsJson = new JSONArray();
            for (Metric metric : metrics) {
                metricsJson.put((Object)metric.getName());
            }
            params.add(new Pair<String, String>("metrics", metricsJson.toString()));
        }
        params.add(new Pair<String, String>("start_time", Long.toString(start / 1000L)));
        params.add(new Pair<String, String>("end_time", Long.toString(end / 1000L)));
        params.add(new Pair<String, String>("period", Long.toString(period)));
        return this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_METRICS, params);
    }

    @Override
    public Document permissions_checkGrantedApiAccess(String apiKey) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PERM_CHECK_GRANTED_API_ACCESS, new Pair<String, String>("permissions_apikey", apiKey));
    }

    @Override
    public Document permissions_checkAvailableApiAccess(String apiKey) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PERM_CHECK_AVAILABLE_API_ACCESS, new Pair<String, String>("permissions_apikey", apiKey));
    }

    @Override
    public boolean permissions_grantApiAccess(String apiKey, Set<FacebookMethod> methods) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (methods != null && !methods.isEmpty()) {
            JSONArray methodsJson = new JSONArray();
            for (FacebookMethod method : methods) {
                methodsJson.put((Object)method.methodName());
            }
            params.add(new Pair<String, String>("method_arr", methodsJson.toString()));
        }
        params.add(new Pair<String, String>("permissions_apikey", apiKey));
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PERM_GRANT_API_ACCESS, params));
    }

    @Override
    public boolean permissions_grantFullApiAccess(String apiKey) throws FacebookException, IOException {
        return this.permissions_grantApiAccess(apiKey, null);
    }

    @Override
    public boolean permissions_revokeApiAccess(String apiKey) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PERM_REVOKE_API_ACCESS, new Pair<String, String>("permissions_apikey", apiKey)));
    }

    @Override
    public String auth_promoteSession() throws FacebookException, IOException {
        return FacebookRestClient.extractString(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_PROMOTE_SESSION, new Pair[0]));
    }

    @Override
    public boolean auth_revokeAuthorization() throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_REVOKE_AUTHORIZATION, new Pair[0]));
    }

    @Override
    public boolean auth_expireSession() throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_EXPIRE_SESSION, new Pair[0]));
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, String attributes, Long userId) throws FacebookException, IOException {
        MarketListing test;
        if (listingId == null) {
            listingId = 0L;
        }
        if (!(test = new MarketListing(attributes)).verify()) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The specified listing is invalid!");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("listing_id", listingId.toString()));
        if (showOnProfile) {
            params.add(new Pair<String, String>("show_on_profile", "true"));
        }
        params.add(new Pair<String, String>("listing_attrs", attributes));
        params.add(new Pair<String, String>("uid", Long.toString(listingId)));
        return this.marketplace_createListing(FacebookMethod.MARKET_CREATE_LISTING_NOSESSION, params);
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, MarketListing listing, Long userId) throws FacebookException, IOException {
        return this.marketplace_createListing(listingId, showOnProfile, listing.getAttribs(), userId);
    }

    @Override
    public Long marketplace_createListing(boolean showOnProfile, MarketListing listing, Long userId) throws FacebookException, IOException {
        return this.marketplace_createListing((Long)0L, showOnProfile, listing.getAttribs(), userId);
    }

    @Override
    public boolean marketplace_removeListing(Long listingId, Long userId) throws FacebookException, IOException {
        return this.marketplace_removeListing(listingId, MarketListingStatus.DEFAULT, userId);
    }

    @Override
    public boolean marketplace_removeListing(Long listingId, MarketListingStatus status, Long userId) throws FacebookException, IOException {
        if (status == null) {
            status = MarketListingStatus.DEFAULT;
        }
        if (listingId == null) {
            return false;
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("listing_id", listingId.toString()));
        params.add(new Pair<String, String>("status", status.getName()));
        params.add(new Pair<String, String>("uid", Long.toString(userId)));
        return this.marketplace_removeListing(FacebookMethod.MARKET_REMOVE_LISTING_NOSESSION, params);
    }

    private boolean photos_addTag(Long photoId, Double xPct, Double yPct, Long taggedUserId, CharSequence tagText, Long userId) throws FacebookException, IOException {
        assert (null != photoId && !photoId.equals(0));
        assert (null != taggedUserId || null != tagText);
        assert (null != xPct && xPct >= 0.0 && xPct <= 100.0);
        assert (null != yPct && yPct >= 0.0 && yPct <= 100.0);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        Pair<String, String> tagData = taggedUserId != null ? new Pair<String, String>("tag_uid", taggedUserId.toString()) : new Pair<String, String>("tag_text", ((Object)tagText).toString());
        params.add(tagData);
        params.add(new Pair<String, String>("x", xPct.toString()));
        params.add(new Pair<String, String>("y", yPct.toString()));
        params.add(new Pair<String, String>("pid", photoId.toString()));
        params.add(new Pair<String, String>("owner_uid", Long.toString(userId)));
        return this.photos_addTag(FacebookMethod.PHOTOS_ADD_TAG_NOSESSION, params);
    }

    @Override
    public boolean photos_addTag(Long photoId, Long taggedUserId, Double pct, Double pct2, Long userId) throws FacebookException, IOException {
        return this.photos_addTag(photoId, pct, pct2, taggedUserId, null, userId);
    }

    @Override
    public boolean photos_addTag(Long photoId, CharSequence tagText, Double pct, Double pct2, Long userId) throws FacebookException, IOException {
        return this.photos_addTag(photoId, pct, pct2, null, tagText);
    }

    @Override
    public Document photos_createAlbum(String albumName, Long userId) throws FacebookException, IOException {
        return this.photos_createAlbum(albumName, null, null, userId);
    }

    @Override
    public Document photos_createAlbum(String name, String description, String location, Long userId) throws FacebookException, IOException {
        assert (null != name && !"".equals(name));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_CREATE_ALBUM.numParams());
        params.add(new Pair<String, String>("name", name));
        if (null != description) {
            params.add(new Pair<String, String>("description", description));
        }
        if (null != location) {
            params.add(new Pair<String, String>("location", location));
        }
        params.add(new Pair<String, String>("uid", Long.toString(userId)));
        return this.photos_createAlbum(FacebookMethod.PHOTOS_CREATE_ALBUM_NOSESSION, params);
    }

    @Override
    public Document photos_upload(Long userId, File photo) throws FacebookException, IOException {
        return this.photos_upload(userId, photo, null, null);
    }

    @Override
    public Document photos_upload(Long userId, File photo, String caption) throws FacebookException, IOException {
        return this.photos_upload(userId, photo, caption, null);
    }

    @Override
    public Document photos_upload(Long userId, File photo, Long albumId) throws FacebookException, IOException {
        return this.photos_upload(userId, photo, null, albumId);
    }

    @Override
    public Document photos_upload(Long userId, File photo, String caption, Long albumId) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_UPLOAD.numParams());
        assert (photo.exists() && photo.canRead());
        this._uploadFile = photo;
        if (null != albumId) {
            params.add(new Pair<String, String>("aid", Long.toString(albumId)));
        }
        if (null != caption) {
            params.add(new Pair<String, String>("caption", caption));
        }
        params.add(new Pair<String, String>("uid", Long.toString(userId)));
        return this.photos_upload(FacebookMethod.PHOTOS_UPLOAD_NOSESSION, params);
    }

    @Override
    @Deprecated
    public boolean users_isAppAdded(Long userId) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_ADDED_NOSESSION, FacebookRestClient.newPair("uid", userId)));
    }

    @Override
    public boolean users_isAppUser() throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER, new Pair[0]));
    }

    @Override
    public boolean users_isAppUser(Long userId) throws FacebookException, IOException {
        if (userId != null) {
            return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER_NOSESSION, FacebookRestClient.newPair("uid", userId)));
        }
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER, new Pair[0]));
    }

    @Override
    public boolean users_setStatus(String status, Long userId) throws FacebookException, IOException {
        return this.users_setStatus(status, false, userId);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, Long userId) throws FacebookException, IOException {
        return this.users_setStatus(newStatus, clear, false, userId);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, boolean statusIncludesVerb, Long userId) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (newStatus != null) {
            params.add(new Pair<String, String>("status", newStatus));
        }
        if (clear) {
            params.add(new Pair<String, String>("clear", "1"));
        }
        if (statusIncludesVerb) {
            params.add(new Pair<String, String>("status_includes_verb", "true"));
        }
        params.add(new Pair<String, String>("uid", userId.toString()));
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS_NOSESSION, params));
    }

    @Override
    public Document feed_getRegisteredTemplateBundleByID(Long id) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FEED_GET_TEMPLATE_BY_ID, new Pair<String, String>("template_bundle_id", Long.toString(id)));
    }

    @Override
    public Document feed_getRegisteredTemplateBundles() throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FEED_GET_TEMPLATES, new Pair[0]);
    }

    @Override
    public Boolean feed_publishUserAction(Long bundleId) throws FacebookException, IOException {
        return this.feed_publishUserAction(bundleId, null, null, null);
    }

    @Override
    public Boolean feed_publishUserAction(Long bundleId, Map<String, String> templateData, List<Long> targetIds, String bodyGeneral) throws FacebookException, IOException {
        return this.feed_publishUserAction(bundleId, templateData, null, targetIds, bodyGeneral, 0);
    }

    @Override
    public Long feed_registerTemplateBundle(String template) throws FacebookException, IOException {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(template);
        return this.feed_registerTemplateBundle(temp);
    }

    @Override
    public Long feed_registerTemplateBundle(Collection<String> templates) throws FacebookException, IOException {
        return this.feed_registerTemplateBundle(templates, null, null);
    }

    @Override
    public Long feed_registerTemplateBundle(Collection<String> templates, Collection<BundleStoryTemplate> shortTemplates, BundleStoryTemplate longTemplate) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        JSONArray templateArray = new JSONArray();
        for (String template : templates) {
            templateArray.put((Object)template);
        }
        params.add(new Pair<String, String>("one_line_story_templates", templateArray.toString()));
        if (shortTemplates != null && !shortTemplates.isEmpty()) {
            JSONArray shortArray = new JSONArray();
            for (BundleStoryTemplate template : shortTemplates) {
                shortArray.put((Object)template.toJson());
            }
            params.add(new Pair<String, String>("short_story_templates", shortArray.toString()));
        }
        if (longTemplate != null) {
            params.add(new Pair<String, String>("full_story_template", longTemplate.toJsonString()));
        }
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.FEED_REGISTER_TEMPLATE, params));
    }

    @Override
    @Deprecated
    public Long feed_registerTemplateBundle(String template, String shortTemplate, String longTemplate) throws FacebookException, IOException {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add(template);
        return this.feed_registerTemplateBundle(templates, null, null);
    }

    @Override
    public Document profile_getInfo(Long userId) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_INFO, new Pair<String, String>("uid", Long.toString(userId)));
    }

    @Override
    public Document profile_getInfoOptions(String field) throws FacebookException, IOException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_INFO_OPTIONS, new Pair<String, String>("field", field));
    }

    @Override
    public void profile_setInfo(Long userId, String title, boolean textOnly, List<ProfileInfoField> fields) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        JSONArray json = new JSONArray();
        params.add(new Pair<String, String>("uid", Long.toString(userId)));
        params.add(new Pair<String, String>("title", title));
        if (textOnly) {
            params.add(new Pair<String, String>("type", "1"));
        } else {
            params.add(new Pair<String, String>("type", "5"));
        }
        for (ProfileInfoField field : fields) {
            try {
                JSONObject innerJSON = new JSONObject();
                JSONArray fieldItems = new JSONArray();
                innerJSON.put("field", (Object)field.getFieldName());
                for (ProfileFieldItem item : field.getItems()) {
                    JSONObject itemJSON = new JSONObject();
                    for (String key : item.getMap().keySet()) {
                        itemJSON.put(key, (Object)item.getMap().get(key));
                    }
                    fieldItems.put((Object)itemJSON);
                }
                innerJSON.put("items", (Object)fieldItems);
                json.put((Object)innerJSON);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        params.add(new Pair<String, String>("info_fields", json.toString()));
        this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_SET_INFO, params);
    }

    @Override
    public void profile_setInfoOptions(ProfileInfoField field) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        JSONArray json = new JSONArray();
        params.add(new Pair<String, String>("field", field.getFieldName()));
        for (ProfileFieldItem item : field.getItems()) {
            JSONObject itemJSON = new JSONObject();
            for (String key : item.getMap().keySet()) {
                try {
                    itemJSON.put(key, (Object)item.getMap().get(key));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            json.put((Object)itemJSON);
        }
        params.add(new Pair<String, String>("options", json.toString()));
        this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_SET_INFO_OPTIONS, params);
    }

    @Override
    public Document photos_addTags(Long photoId, Collection<PhotoTag> tags, Long userId) throws FacebookException, IOException {
        assert (photoId > 0L);
        assert (null != tags && !tags.isEmpty());
        String tagStr = null;
        try {
            JSONArray jsonTags = new JSONArray();
            for (PhotoTag tag : tags) {
                jsonTags.put((Object)tag.jsonify());
            }
            tagStr = jsonTags.toString();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG_NOSESSION, new Pair<String, String>("pid", photoId.toString()), new Pair<String, String>("tags", tagStr), new Pair<String, String>("uid", Long.toString(userId)));
    }

    private Long marketplace_createListing(IFacebookMethod method, Collection<Pair<String, CharSequence>> params) throws FacebookException, IOException {
        this.callMethod(method, params);
        if (this.rawResponse == null) {
            return null;
        }
        String result = this.rawResponse.substring(0, this.rawResponse.indexOf("</marketplace"));
        result = result.substring(result.lastIndexOf(">") + 1);
        return Long.parseLong(result);
    }

    private boolean marketplace_removeListing(IFacebookMethod method, Collection<Pair<String, CharSequence>> params) throws FacebookException, IOException {
        this.callMethod(method, params);
        if (this.rawResponse == null) {
            return false;
        }
        return this.rawResponse.contains(">1<");
    }

    private boolean photos_addTag(IFacebookMethod method, Collection<Pair<String, CharSequence>> params) throws FacebookException, IOException {
        Document d = this.callMethod(method, params);
        return FacebookRestClient.extractBoolean(d);
    }

    private Document photos_createAlbum(IFacebookMethod method, ArrayList<Pair<String, CharSequence>> params) throws FacebookException, IOException {
        return this.callMethod(method, params);
    }

    private Document photos_upload(IFacebookMethod method, ArrayList<Pair<String, CharSequence>> params) throws FacebookException, IOException {
        return this.callMethod(method, params);
    }

    public static boolean addParam(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        return FacebookRestClient.addParam(name, Long.toString(value), params);
    }

    public static boolean addParamIfNotBlank(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        if (value != null) {
            return FacebookRestClient.addParamIfNotBlank(name, Long.toString(value), params);
        }
        return false;
    }

    public static boolean addParam(String name, CharSequence value, Collection<Pair<String, CharSequence>> params) {
        params.add(new Pair<String, CharSequence>(name, value));
        return true;
    }

    public static boolean addParamIfNotBlank(String name, CharSequence value, Collection<Pair<String, CharSequence>> params) {
        if (value != null && !"".equals(value)) {
            params.add(new Pair<String, CharSequence>(name, value));
            return true;
        }
        return false;
    }

    @Override
    public void setServerUrl(String newUrl) {
        String base = newUrl;
        if (base.startsWith("http")) {
            base = base.substring(base.indexOf("://") + 3);
        }
        try {
            String url = "http://" + base;
            this._serverUrl = new URL(url);
            this.setDefaultServerUrl(this._serverUrl);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public URL getDefaultServerUrl() {
        return SERVER_URL;
    }

    @Override
    public void setDefaultServerUrl(URL newUrl) {
        SERVER_URL = newUrl;
    }

    protected Long extractLong(Document doc) {
        if (doc == null) {
            return 0L;
        }
        return Long.parseLong(doc.getFirstChild().getTextContent());
    }

    @Override
    public Boolean liveMessage_send(Long recipient, String eventName, JSONObject message) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("recipient", Long.toString(recipient)));
        params.add(new Pair<String, String>("event_name", eventName));
        params.add(new Pair<String, String>("message", message.toString()));
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.LIVEMESSAGE_SEND, params));
    }

    @Override
    public boolean feed_deactivateTemplateBundleByID(Long bundleId) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("template_bundle_id", Long.toString(bundleId)));
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_DEACTIVATE_TEMPLATE_BUNDLE, params));
    }

    @Override
    public void notifications_send(Collection<Long> recipientIds, String notification, boolean isAppToUser) throws FacebookException, IOException {
        if (null == notification || "".equals(notification)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You cannot send an empty notification!");
        }
        Pair<String, String> type = new Pair<String, String>("type", isAppToUser ? "app_to_user" : "user_to_user");
        if (recipientIds != null && !recipientIds.isEmpty()) {
            this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_SEND, new Pair<String, CharSequence>("to_ids", FacebookRestClient.delimit(recipientIds)), new Pair<String, String>("notification", notification), type);
        } else {
            this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_SEND, new Pair<String, String>("notification", notification), type);
        }
    }

    @Override
    public Boolean feed_publishUserAction(Long bundleId, Map<String, String> templateData, List<IFeedImage> images, List<Long> targetIds, String bodyGeneral, int storySize) throws FacebookException, IOException {
        if (images != null && images.size() > 4) {
            throw new IllegalArgumentException("Maximum of 4 images allowed per feed item.");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(new Pair<String, String>("template_bundle_id", Long.toString(bundleId)));
        if (targetIds != null && !targetIds.isEmpty()) {
            params.add(new Pair<String, CharSequence>("target_ids", FacebookRestClient.delimit(targetIds)));
        }
        if (bodyGeneral != null && !"".equals(bodyGeneral)) {
            params.add(new Pair<String, String>("body_general", bodyGeneral));
        }
        JSONObject jsonTemplateData = new JSONObject();
        if (templateData != null && !templateData.isEmpty()) {
            for (String key : templateData.keySet()) {
                try {
                    jsonTemplateData.put(key, (Object)templateData.get(key));
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error constructing JSON object", exception);
                }
            }
        }
        if (images != null && !images.isEmpty()) {
            try {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < images.size(); ++i) {
                    IFeedImage image = images.get(i);
                    JSONObject jsonImage = new JSONObject();
                    jsonImage.put("src", (Object)image.getImageUrlString());
                    jsonImage.put("href", (Object)image.getLinkUrl().toExternalForm());
                    jsonArray.put(i, (Object)jsonImage);
                }
                jsonTemplateData.put("images", (Object)jsonArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error constructing JSON object", exception);
            }
        }
        if (jsonTemplateData.length() > 0) {
            params.add(new Pair<String, String>("template_data", jsonTemplateData.toString()));
        }
        return FacebookRestClient.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_PUBLISH_USER_ACTION, params));
    }

    private static Pair<String, CharSequence> newPair(String name, CharSequence value) {
        return new Pair<String, CharSequence>(name, value);
    }

    private static Pair<String, CharSequence> newPair(String name, Long value) {
        return new Pair<String, CharSequence>(name, Long.toString(value));
    }

    private static Pair<String, CharSequence> newPair(String name, Integer value) {
        return new Pair<String, CharSequence>(name, Integer.toString(value));
    }

    public static String toString(CharSequence cs) {
        return cs == null ? null : ((Object)cs).toString();
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((String)"com.google.code.facebookapi.schema");
            SERVER_URL = new URL(SERVER_ADDR);
            HTTPS_SERVER_URL = new URL(HTTPS_SERVER_ADDR);
        }
        catch (MalformedURLException ex) {
            log.error((Object)("MalformedURLException: " + ex.getMessage()), (Throwable)ex);
            System.exit(1);
        }
        catch (JAXBException ex) {
            JAXB_CONTEXT = null;
            log.error((Object)("Could not get JAXB context:  " + ex.getMessage()), (Throwable)ex);
        }
        RETURN_TYPES = new HashMap<FacebookMethod, String>();
        Method[] candidates = FacebookRestClient.class.getMethods();
        block3: for (FacebookMethod method : EnumSet.allOf(FacebookMethod.class)) {
            String name = method.methodName();
            name = name.substring(name.indexOf(".") + 1);
            name = name.replace(".", "_");
            for (Method candidate : candidates) {
                if (!candidate.getName().equalsIgnoreCase(name)) continue;
                String typeName = candidate.getReturnType().getName().toLowerCase();
                if (typeName.indexOf("document") != -1) {
                    RETURN_TYPES.put(method, "default");
                    continue block3;
                }
                if (typeName.indexOf("string") != -1) {
                    RETURN_TYPES.put(method, "string");
                    continue block3;
                }
                if (typeName.indexOf("bool") != -1) {
                    RETURN_TYPES.put(method, "bool");
                    continue block3;
                }
                if (typeName.indexOf("long") != -1) {
                    RETURN_TYPES.put(method, "long");
                    continue block3;
                }
                if (typeName.indexOf("int") != -1) {
                    RETURN_TYPES.put(method, "int");
                    continue block3;
                }
                if (typeName.indexOf("applicationpropertyset") != -1 || typeName.indexOf("list") != -1 || typeName.indexOf("url") != -1 || typeName.indexOf("map") != -1 || typeName.indexOf("object") != -1) {
                    RETURN_TYPES.put(method, "default");
                    continue block3;
                }
                RETURN_TYPES.put(method, "void");
                continue block3;
            }
        }
    }
}

