/*
 * Decompiled with CFR 0.152.
 */
package org.bn.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Module {
    private File[] moduleFiles = null;
    private String moduleName;
    private String outputDir;
    private String modulesPath;

    public Module(String modulesPath, String name, String outputDir) throws Exception {
        this.setModuleName(name);
        this.setOutputDir(outputDir);
        this.setModulesPath(modulesPath);
        this.loadTransformations();
    }

    private File createOutputFileForInput(File input) throws IOException {
        String fileName = input.getName().substring(0, input.getName().lastIndexOf(".")) + "." + this.getModuleName();
        File result = new File(this.getOutputDir(), fileName);
        if (!result.getParentFile().exists()) {
            result.getParentFile().mkdirs();
        }
        return result;
    }

    private void loadTransformations() throws Exception {
        File basePath = new File(this.getModulesPath() + File.separator + this.getModuleName());
        if (!basePath.isDirectory()) {
            throw new FileNotFoundException("Modules must be directory!");
        }
        this.moduleFiles = basePath.listFiles();
    }

    public void translate(InputStream stream) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        for (File file : this.moduleFiles) {
            if (!file.isFile()) continue;
            Transformer transformer = factory.newTransformer(new StreamSource(file));
            transformer.setErrorListener(new ErrorListener(){

                public void warning(TransformerException exception) {
                    System.err.println("[W] Warning:" + exception);
                }

                public void error(TransformerException exception) {
                    System.err.println("[!] Error:" + exception);
                }

                public void fatalError(TransformerException exception) {
                    System.err.println("[!!!] Fatal error:" + exception);
                }
            });
            File outputFile = this.createOutputFileForInput(file);
            transformer.transform(new StreamSource(stream), new StreamResult(outputFile));
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getModulesPath() {
        return this.modulesPath;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    private void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    private void setModulesPath(String modulesPath) {
        this.modulesPath = modulesPath;
    }

    private void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }
}

