/*
 * Decompiled with CFR 0.152.
 */
package org.bn.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.bn.compiler.CompilerArgs;
import org.bn.compiler.Module;
import org.bn.compiler.parser.ASNLexer;
import org.bn.compiler.parser.ASNParser;
import org.bn.compiler.parser.model.ASN1Model;
import org.bn.compiler.parser.model.ASNModule;
import org.lineargs.LineArgsParser;

public class Main {
    private static final String version = "1.6.0";
    private LineArgsParser parser = new LineArgsParser();
    private CompilerArgs arguments = null;

    private void createModel(OutputStream outputXml, String[] args, Module module) throws PropertyException, Exception, JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"org.bn.compiler.parser.model");
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ASN1Model model = this.createModelFromStream();
        model.runtimeArguments = args;
        if (module != null) {
            model.moduleDirectory = module.getModulesPath() + File.separator + module.getModuleName();
            model.outputDirectory = module.getOutputDir();
            model.moduleNS = this.arguments.getNamespace() != null ? this.arguments.getNamespace() : model.module.moduleIdentifier.name.toLowerCase();
        }
        marshaller.marshal((Object)model, outputXml);
    }

    private ASN1Model createModelFromStream() throws Exception {
        FileInputStream stream = new FileInputStream(this.arguments.getInputFileName());
        ASNLexer lexer = new ASNLexer(stream);
        ASNParser parser = new ASNParser(lexer);
        ASNModule module = new ASNModule();
        parser.module_definition(module);
        ASN1Model model = new ASN1Model();
        model.module = module;
        return model;
    }

    public static void main(String[] args) {
        try {
            System.out.println("BinaryNotes compiler v1.6.0");
            System.out.println("        (c) 2006-2011 Abdulla G. Abdurakhmanov");
            new Main().start(args);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void start(String[] args) throws Exception {
        if (args.length > 0) {
            this.arguments = (CompilerArgs)this.parser.parse(CompilerArgs.class, args);
            Module module = new Module(this.arguments.getModulesPath(), this.arguments.getModuleName(), this.arguments.getOutputDir());
            this.startForModule(module, args);
        } else {
            this.parser.printHelp(CompilerArgs.class, System.out);
        }
    }

    private void startForModule(Module module, String[] args) throws Exception {
        if (!this.arguments.getGenerateModelOnly().booleanValue()) {
            System.out.println("Current directory: " + new File(".").getCanonicalPath());
            System.out.println("Compiling file: " + this.arguments.getInputFileName());
            ByteArrayOutputStream outputXml = new ByteArrayOutputStream(65535);
            this.createModel(outputXml, args, module);
            ByteArrayInputStream stream = new ByteArrayInputStream(outputXml.toByteArray());
            module.translate(stream);
        } else {
            this.createModel(System.out, args, null);
        }
    }
}

