/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.blob;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.hash.WritableContents;
import java.io.IOException;
import java.io.OutputStream;

class WritableContentsBlob
implements Blob {
    private final WritableContents writableContents;
    private final boolean retryable;

    WritableContentsBlob(WritableContents writableContents, boolean retryable) {
        this.writableContents = writableContents;
        this.retryable = retryable;
    }

    @Override
    public BlobDescriptor writeTo(OutputStream outputStream) throws IOException {
        return Digests.computeDigest(this.writableContents, outputStream);
    }

    @Override
    public boolean isRetryable() {
        return this.retryable;
    }
}

