/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Optional;

public class PlatformChecker {
    static void checkManifestPlatform(BuildContext buildContext, ContainerConfigurationTemplate containerConfig) {
        EventHandlers eventHandlers = buildContext.getEventHandlers();
        Optional<Path> path = buildContext.getBaseImageConfiguration().getTarPath();
        String baseImageName = path.map(Path::toString).orElse(buildContext.getBaseImageConfiguration().getImage().toString());
        ImmutableSet<Platform> platforms = buildContext.getContainerConfiguration().getPlatforms();
        Verify.verify((!platforms.isEmpty() ? 1 : 0) != 0);
        if (platforms.size() != 1) {
            eventHandlers.dispatch(LogEvent.warn("platforms configured, but '" + baseImageName + "' is not a manifest list"));
        } else {
            Platform platform = (Platform)platforms.iterator().next();
            if (!(platform.getArchitecture().equals(containerConfig.getArchitecture()) && platform.getOs().equals(containerConfig.getOs()) || platform.getArchitecture().equals("amd64") && platform.getOs().equals("linux"))) {
                String warning = "the configured platform (%s/%s) doesn't match the platform (%s/%s) of the base image (%s)";
                eventHandlers.dispatch(LogEvent.warn(String.format(warning, platform.getArchitecture(), platform.getOs(), containerConfig.getArchitecture(), containerConfig.getOs(), baseImageName)));
            }
        }
    }
}

