/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RegistryAuthenticator {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final String realm;
    private final String service;
    private final String userAgent;

    static Optional<RegistryAuthenticator> fromAuthenticationMethod(String authenticationMethod, RegistryEndpointRequestProperties registryEndpointRequestProperties, String userAgent) throws RegistryAuthenticationFailedException {
        if (authenticationMethod.matches("^(?i)(basic) .*")) {
            return Optional.empty();
        }
        if (!authenticationMethod.matches("^(?i)(bearer) .*")) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(registryEndpointRequestProperties.getServerUrl(), registryEndpointRequestProperties.getImageName(), authenticationMethod, "Bearer");
        }
        Pattern realmPattern = Pattern.compile("realm=\"(.*?)\"");
        Matcher realmMatcher = realmPattern.matcher(authenticationMethod);
        if (!realmMatcher.find()) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(registryEndpointRequestProperties.getServerUrl(), registryEndpointRequestProperties.getImageName(), authenticationMethod, "realm");
        }
        String realm = realmMatcher.group(1);
        Pattern servicePattern = Pattern.compile("service=\"(.*?)\"");
        Matcher serviceMatcher = servicePattern.matcher(authenticationMethod);
        String service = serviceMatcher.find() ? serviceMatcher.group(1) : registryEndpointRequestProperties.getServerUrl();
        return Optional.of(new RegistryAuthenticator(realm, service, registryEndpointRequestProperties, userAgent));
    }

    private static RegistryAuthenticationFailedException newRegistryAuthenticationFailedException(String registry, String repository, String authenticationMethod, String authParam) {
        return new RegistryAuthenticationFailedException(registry, repository, "'" + authParam + "' was not found in the 'WWW-Authenticate' header, tried to parse: " + authenticationMethod);
    }

    RegistryAuthenticator(String realm, String service, RegistryEndpointRequestProperties registryEndpointRequestProperties, String userAgent) {
        this.realm = realm;
        this.service = service;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.userAgent = userAgent;
    }

    public Authorization authenticatePull(@Nullable Credential credential) throws RegistryAuthenticationFailedException {
        return this.authenticate(credential, "pull");
    }

    public Authorization authenticatePush(@Nullable Credential credential) throws RegistryAuthenticationFailedException {
        return this.authenticate(credential, "pull,push");
    }

    @VisibleForTesting
    String getServiceScopeRequestParameters(Map<String, String> repositoryScopes) {
        StringBuilder parameters = new StringBuilder("service=").append(this.service);
        for (Map.Entry<String, String> pair : repositoryScopes.entrySet()) {
            parameters.append("&scope=repository:").append(pair.getKey()).append(":").append(pair.getValue());
        }
        return parameters.toString();
    }

    @VisibleForTesting
    URL getAuthenticationUrl(@Nullable Credential credential, Map<String, String> repositoryScopes) throws MalformedURLException {
        return this.isOAuth2Auth(credential) ? new URL(this.realm) : new URL(this.realm + "?" + this.getServiceScopeRequestParameters(repositoryScopes));
    }

    @VisibleForTesting
    String getAuthRequestParameters(@Nullable Credential credential, Map<String, String> repositoryScopes) {
        String serviceScope = this.getServiceScopeRequestParameters(repositoryScopes);
        return this.isOAuth2Auth(credential) ? serviceScope + "&client_id=jib.da031fe481a93ac107a95a96462358f9&grant_type=refresh_token&refresh_token=" + ((Credential)Verify.verifyNotNull((Object)credential)).getPassword() : serviceScope;
    }

    @VisibleForTesting
    boolean isOAuth2Auth(@Nullable Credential credential) {
        return credential != null && credential.isOAuth2RefreshToken();
    }

    private Authorization authenticate(@Nullable Credential credential, String scope) throws RegistryAuthenticationFailedException {
        Authorization auth;
        if (this.registryEndpointRequestProperties.getSourceImageName() != null) {
            try {
                ImmutableMap scopes = ImmutableMap.of((Object)this.registryEndpointRequestProperties.getImageName(), (Object)scope, (Object)this.registryEndpointRequestProperties.getSourceImageName(), (Object)"pull");
                auth = this.authenticate(credential, (Map<String, String>)scopes);
                if (auth != null) {
                    return auth;
                }
            }
            catch (RegistryAuthenticationFailedException scopes) {
                // empty catch block
            }
        }
        ImmutableMap repositoryScopes = ImmutableMap.of((Object)this.registryEndpointRequestProperties.getImageName(), (Object)scope);
        auth = this.authenticate(credential, (Map<String, String>)repositoryScopes);
        return auth;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Authorization authenticate(@Nullable Credential credential, Map<String, String> repositoryScopes) throws RegistryAuthenticationFailedException {
        try (Connection connection = Connection.getConnectionFactory().apply(this.getAuthenticationUrl(credential, repositoryScopes));){
            Request.Builder requestBuilder = Request.builder().setHttpTimeout(JibSystemProperties.getHttpTimeout()).setUserAgent(this.userAgent);
            if (this.isOAuth2Auth(credential)) {
                String parameters = this.getAuthRequestParameters(credential, repositoryScopes);
                requestBuilder.setBody(new BlobHttpContent(Blobs.from(parameters), MediaType.FORM_DATA.toString()));
            } else if (credential != null) {
                requestBuilder.setAuthorization(Authorization.fromBasicCredentials(credential.getUsername(), credential.getPassword()));
            }
            Request request = requestBuilder.build();
            Response response = this.isOAuth2Auth(credential) ? connection.post(request) : connection.get(request);
            String responseString = CharStreams.toString((Readable)new InputStreamReader(response.getBody(), StandardCharsets.UTF_8));
            AuthenticationResponseTemplate responseJson = JsonTemplateMapper.readJson(responseString, AuthenticationResponseTemplate.class);
            if (responseJson.getToken() == null) {
                throw new RegistryAuthenticationFailedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), "Did not get token in authentication response from " + this.getAuthenticationUrl(credential, repositoryScopes) + "; parameters: " + this.getAuthRequestParameters(credential, repositoryScopes));
            }
            Authorization authorization = Authorization.fromBearerToken(responseJson.getToken());
            return authorization;
        }
        catch (IOException ex) {
            throw new RegistryAuthenticationFailedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), ex);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AuthenticationResponseTemplate
    implements JsonTemplate {
        @Nullable
        private String token;
        @Nullable
        private String access_token;

        private AuthenticationResponseTemplate() {
        }

        @Nullable
        private String getToken() {
            if (this.token != null) {
                return this.token;
            }
            return this.access_token;
        }
    }
}

