/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.UnexpectedBlobDigestException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;

class BlobPuller
implements RegistryEndpointProvider<Void> {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final DescriptorDigest blobDigest;
    private final OutputStream destinationOutputStream;
    private final Consumer<Long> blobSizeListener;
    private final Consumer<Long> writtenByteCountListener;

    BlobPuller(RegistryEndpointRequestProperties registryEndpointRequestProperties, DescriptorDigest blobDigest, OutputStream destinationOutputStream, Consumer<Long> blobSizeListener, Consumer<Long> writtenByteCountListener) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.blobDigest = blobDigest;
        this.destinationOutputStream = destinationOutputStream;
        this.blobSizeListener = blobSizeListener;
        this.writtenByteCountListener = writtenByteCountListener;
    }

    @Override
    public Void handleResponse(Response response) throws IOException, UnexpectedBlobDigestException {
        this.blobSizeListener.accept(response.getContentLength());
        try (NotifyingOutputStream outputStream = new NotifyingOutputStream(this.destinationOutputStream, this.writtenByteCountListener);){
            BlobDescriptor receivedBlobDescriptor = Digests.computeDigest(response.getBody(), (OutputStream)outputStream);
            if (!this.blobDigest.equals(receivedBlobDescriptor.getDigest())) {
                throw new UnexpectedBlobDigestException("The pulled BLOB has digest '" + receivedBlobDescriptor.getDigest() + "', but the request digest was '" + this.blobDigest + "'");
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
        return new URL(apiRouteBase + this.registryEndpointRequestProperties.getImageName() + "/blobs/" + this.blobDigest);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    public String getActionDescription() {
        return "pull BLOB for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName() + " with digest " + this.blobDigest;
    }
}

