/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.FilePermissions;
import com.google.cloud.tools.jib.api.ImageFormat;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class MavenRawConfiguration
implements RawConfiguration {
    private final JibPluginConfiguration jibPluginConfiguration;

    MavenRawConfiguration(JibPluginConfiguration jibPluginConfiguration) {
        this.jibPluginConfiguration = jibPluginConfiguration;
    }

    @Override
    public Optional<String> getFromImage() {
        return Optional.ofNullable(this.jibPluginConfiguration.getBaseImage());
    }

    @Override
    public AuthProperty getFromAuth() {
        return this.jibPluginConfiguration.getBaseImageAuth();
    }

    @Override
    public Optional<String> getFromCredHelper() {
        return Optional.ofNullable(this.jibPluginConfiguration.getBaseImageCredentialHelperName());
    }

    @Override
    public Optional<String> getToImage() {
        return Optional.ofNullable(this.jibPluginConfiguration.getTargetImage());
    }

    @Override
    public AuthProperty getToAuth() {
        return this.jibPluginConfiguration.getTargetImageAuth();
    }

    @Override
    public Optional<String> getToCredHelper() {
        return Optional.ofNullable(this.jibPluginConfiguration.getTargetImageCredentialHelperName());
    }

    @Override
    public Iterable<String> getToTags() {
        return this.jibPluginConfiguration.getTargetImageAdditionalTags();
    }

    @Override
    public Optional<List<String>> getEntrypoint() {
        return Optional.ofNullable(this.jibPluginConfiguration.getEntrypoint());
    }

    @Override
    public Optional<List<String>> getProgramArguments() {
        return Optional.ofNullable(this.jibPluginConfiguration.getArgs());
    }

    @Override
    public List<String> getExtraClasspath() {
        return this.jibPluginConfiguration.getExtraClasspath();
    }

    @Override
    public Optional<String> getMainClass() {
        return Optional.ofNullable(this.jibPluginConfiguration.getMainClass());
    }

    @Override
    public List<String> getJvmFlags() {
        return this.jibPluginConfiguration.getJvmFlags();
    }

    @Override
    public String getAppRoot() {
        return this.jibPluginConfiguration.getAppRoot();
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.jibPluginConfiguration.getEnvironment();
    }

    @Override
    public Map<String, String> getLabels() {
        return this.jibPluginConfiguration.getLabels();
    }

    @Override
    public List<String> getVolumes() {
        return this.jibPluginConfiguration.getVolumes();
    }

    @Override
    public List<String> getPorts() {
        return this.jibPluginConfiguration.getExposedPorts();
    }

    @Override
    public Optional<String> getUser() {
        return Optional.ofNullable(this.jibPluginConfiguration.getUser());
    }

    @Override
    public Optional<String> getWorkingDirectory() {
        return Optional.ofNullable(this.jibPluginConfiguration.getWorkingDirectory());
    }

    @Override
    public boolean getUseCurrentTimestamp() {
        return this.jibPluginConfiguration.getUseCurrentTimestamp();
    }

    @Override
    public boolean getAllowInsecureRegistries() {
        return this.jibPluginConfiguration.getAllowInsecureRegistries();
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.valueOf(this.jibPluginConfiguration.getFormat());
    }

    @Override
    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.jibPluginConfiguration.getProperty(propertyName));
    }

    @Override
    public List<Path> getExtraDirectories() {
        return MojoCommon.getExtraDirectories(this.jibPluginConfiguration);
    }

    @Override
    public Map<AbsoluteUnixPath, FilePermissions> getExtraDirectoryPermissions() {
        return MojoCommon.convertPermissionsList(this.jibPluginConfiguration.getExtraDirectoryPermissions());
    }
}

