/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenHelpfulSuggestionsBuilder;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenRawConfiguration;
import com.google.cloud.tools.jib.maven.MavenSettingsProxyProvider;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.JibBuildRunner;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="buildTar", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildTarMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "buildTar";
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Building image tarball failed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipped()) {
            this.getLog().info((CharSequence)"Skipping containerization because jib-maven-plugin: skip = true");
            return;
        }
        if (!this.isContainerizable()) {
            this.getLog().info((CharSequence)"Skipping containerization of this module (not specified in jib.containerize)");
            return;
        }
        if ("pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return;
        }
        try {
            MavenRawConfiguration mavenRawConfiguration = new MavenRawConfiguration(this);
            MavenProjectProperties projectProperties = MavenProjectProperties.getForProject(this.getProject(), this.getSession(), this.getLog());
            MavenHelpfulSuggestionsBuilder mavenHelpfulSuggestionsBuilder = new MavenHelpfulSuggestionsBuilder(HELPFUL_SUGGESTIONS_PREFIX, this);
            Path buildOutput = Paths.get(this.getProject().getBuild().getDirectory(), new String[0]);
            Path tarOutputPath = buildOutput.resolve("jib-image.tar");
            PluginConfigurationProcessor pluginConfigurationProcessor = PluginConfigurationProcessor.processCommonConfigurationForTarImage(mavenRawConfiguration, new MavenSettingsServerCredentials(this.getSession().getSettings(), this.getSettingsDecrypter()), projectProperties, tarOutputPath, mavenHelpfulSuggestionsBuilder.build());
            MavenSettingsProxyProvider.activateHttpAndHttpsProxies(this.getSession().getSettings(), this.getSettingsDecrypter());
            HelpfulSuggestions helpfulSuggestions = mavenHelpfulSuggestionsBuilder.setBaseImageReference(pluginConfigurationProcessor.getBaseImageReference()).setBaseImageHasConfiguredCredentials(pluginConfigurationProcessor.isBaseImageCredentialPresent()).setTargetImageReference(pluginConfigurationProcessor.getTargetImageReference()).build();
            try {
                JibBuildRunner.forBuildTar(tarOutputPath).writeImageDigest(buildOutput.resolve("jib-image.digest")).writeImageId(buildOutput.resolve("jib-image.id")).build(pluginConfigurationProcessor.getJibContainerBuilder(), pluginConfigurationProcessor.getContainerizer(), projectProperties::log, helpfulSuggestions);
            }
            finally {
                projectProperties.waitForLoggingThread();
                this.getLog().info((CharSequence)"");
            }
        }
        catch (InvalidAppRootException ex) {
            throw new MojoExecutionException("<container><appRoot> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidWorkingDirectoryException ex) {
            throw new MojoExecutionException("<container><workingDirectory> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidContainerVolumeException ex) {
            throw new MojoExecutionException("<container><volumes> is not an absolute Unix-style path: " + ex.getInvalidVolume(), (Exception)ex);
        }
        catch (IncompatibleBaseImageJavaVersionException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forIncompatibleBaseImageJavaVesionForMaven(ex.getBaseImageMajorJavaVersion(), ex.getProjectMajorJavaVersion()), (Exception)ex);
        }
        catch (InvalidImageReferenceException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forInvalidImageReference(ex.getInvalidReference()), (Exception)ex);
        }
        catch (CacheDirectoryCreationException | MainClassInferenceException | IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        catch (BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
    }
}

