/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.util.Base64;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class Authorization {
    private final String scheme;
    private final String token;

    public static Authorization fromBearerToken(String token) {
        return new Authorization("Bearer", token);
    }

    public static Authorization fromBasicCredentials(String username, String secret) {
        String credentials = username + ":" + secret;
        String token = Base64.encodeBase64String((byte[])credentials.getBytes(StandardCharsets.UTF_8));
        return new Authorization("Basic", token);
    }

    public static Authorization fromBasicToken(String token) {
        return new Authorization("Basic", token);
    }

    private Authorization(String scheme, String token) {
        this.scheme = scheme;
        this.token = token;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getToken() {
        return this.token;
    }

    public String toString() {
        return this.scheme + " " + this.token;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Authorization)) {
            return false;
        }
        Authorization otherAuthorization = (Authorization)other;
        return this.scheme.equals(otherAuthorization.scheme) && this.token.equals(otherAuthorization.token);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.token);
    }
}

