/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.docker.ImageTarball;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DockerClient {
    private static final Path DEFAULT_DOCKER_CLIENT = Paths.get("docker", new String[0]);
    private final Function<List<String>, ProcessBuilder> processBuilderFactory;

    public static Builder builder() {
        return new Builder();
    }

    public static DockerClient newDefaultClient() {
        return DockerClient.builder().build();
    }

    @VisibleForTesting
    static Function<List<String>, ProcessBuilder> defaultProcessBuilderFactory(String dockerExecutable, ImmutableMap<String, String> dockerEnvironment) {
        return dockerSubCommand -> {
            ArrayList<String> dockerCommand = new ArrayList<String>(1 + dockerSubCommand.size());
            dockerCommand.add(dockerExecutable);
            dockerCommand.addAll((Collection<String>)dockerSubCommand);
            ProcessBuilder processBuilder = new ProcessBuilder(dockerCommand);
            Map<String, String> environment = processBuilder.environment();
            environment.putAll((Map<String, String>)dockerEnvironment);
            return processBuilder;
        };
    }

    @VisibleForTesting
    DockerClient(Function<List<String>, ProcessBuilder> processBuilderFactory) {
        this.processBuilderFactory = processBuilderFactory;
    }

    private DockerClient(Path dockerExecutable, ImmutableMap<String, String> dockerEnvironment) {
        this(DockerClient.defaultProcessBuilderFactory(dockerExecutable.toString(), dockerEnvironment));
    }

    public static boolean isDefaultDockerInstalled() {
        return DockerClient.isDockerInstalled(DEFAULT_DOCKER_CLIENT);
    }

    public static boolean isDockerInstalled(Path dockerExecutable) {
        try {
            new ProcessBuilder(dockerExecutable.toString()).start();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public String load(ImageTarball imageTarball) throws InterruptedException, IOException {
        Process dockerProcess = this.docker("load");
        try (OutputStream stdin = dockerProcess.getOutputStream();){
            try {
                imageTarball.writeTo(stdin);
            }
            catch (IOException ex) {
                String error;
                try (InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);){
                    error = CharStreams.toString((Readable)stderr);
                }
                catch (IOException ignored) {
                    throw ex;
                }
                throw new IOException("'docker load' command failed with error: " + error, ex);
            }
        }
        var4_4 = null;
        try (InputStreamReader stdout = new InputStreamReader(dockerProcess.getInputStream(), StandardCharsets.UTF_8);){
            String output = CharStreams.toString((Readable)stdout);
            if (dockerProcess.waitFor() != 0) {
                InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    try {
                        throw new IOException("'docker load' command failed with output: " + CharStreams.toString((Readable)stderr));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    DockerClient.$closeResource(throwable, stderr);
                    throw throwable3;
                }
            }
            String string = output;
            return string;
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    public void tag(ImageReference originalImageReference, ImageReference newImageReference) throws IOException, InterruptedException {
        Process dockerProcess = this.docker("tag", originalImageReference.toString(), newImageReference.toString());
        if (dockerProcess.waitFor() != 0) {
            InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                try {
                    throw new IOException("'docker tag' command failed with error: " + CharStreams.toString((Readable)stderr));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                DockerClient.$closeResource(throwable, stderr);
                throw throwable3;
            }
        }
    }

    private Process docker(String ... subCommand) throws IOException {
        return this.processBuilderFactory.apply(Arrays.asList(subCommand)).start();
    }

    static /* synthetic */ Path access$000() {
        return DEFAULT_DOCKER_CLIENT;
    }

    public static class Builder {
        private Path dockerExecutable = DockerClient.access$000();
        private ImmutableMap<String, String> dockerEnvironment = ImmutableMap.of();

        private Builder() {
        }

        public Builder setDockerExecutable(Path dockerExecutable) {
            this.dockerExecutable = dockerExecutable;
            return this;
        }

        public Builder setDockerEnvironment(ImmutableMap<String, String> dockerEnvironment) {
            this.dockerEnvironment = dockerEnvironment;
            return this;
        }

        public DockerClient build() {
            return new DockerClient(this.dockerExecutable, this.dockerEnvironment);
        }
    }
}

