/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CacheStorageFiles;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.filesystem.LockFile;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.ManifestAndConfig;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.OCIManifestTemplate;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class CacheStorageReader {
    private final CacheStorageFiles cacheStorageFiles;

    CacheStorageReader(CacheStorageFiles cacheStorageFiles) {
        this.cacheStorageFiles = cacheStorageFiles;
    }

    Set<DescriptorDigest> fetchDigests() throws IOException, CacheCorruptedException {
        try (Stream<Path> layerDirectories = Files.list(this.cacheStorageFiles.getLayersDirectory());){
            List layerDirectoriesList = layerDirectories.collect(Collectors.toList());
            HashSet<DescriptorDigest> layerDigests = new HashSet<DescriptorDigest>(layerDirectoriesList.size());
            for (Path layerDirectory : layerDirectoriesList) {
                try {
                    layerDigests.add(DescriptorDigest.fromHash(layerDirectory.getFileName().toString()));
                }
                catch (DigestException ex) {
                    throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "Found non-digest file in layers directory", ex);
                }
            }
            HashSet<DescriptorDigest> hashSet = layerDigests;
            return hashSet;
        }
    }

    Optional<ManifestAndConfig> retrieveMetadata(ImageReference imageReference) throws IOException, CacheCorruptedException {
        Path imageDirectory = this.cacheStorageFiles.getImageDirectory(imageReference);
        Path manifestPath = imageDirectory.resolve("manifest.json");
        if (!Files.exists(manifestPath, new LinkOption[0])) {
            return Optional.empty();
        }
        Throwable throwable = null;
        try (LockFile ignored = LockFile.lock(imageDirectory.resolve("lock"));){
            ObjectNode node = (ObjectNode)new ObjectMapper().readValue(Files.newInputStream(manifestPath, new OpenOption[0]), ObjectNode.class);
            if (!node.has("schemaVersion")) {
                throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "Cannot find field 'schemaVersion' in manifest");
            }
            int schemaVersion = node.get("schemaVersion").asInt(-1);
            if (schemaVersion == -1) {
                throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "`schemaVersion` field is not an integer in manifest");
            }
            if (schemaVersion == 1) {
                Optional<ManifestAndConfig> optional = Optional.of(new ManifestAndConfig(JsonTemplateMapper.readJsonFromFile(manifestPath, V21ManifestTemplate.class), null));
                return optional;
            }
            if (schemaVersion == 2) {
                ManifestTemplate manifestTemplate;
                String mediaType = node.get("mediaType").asText();
                if ("application/vnd.docker.distribution.manifest.v2+json".equals(mediaType)) {
                    manifestTemplate = JsonTemplateMapper.readJsonFromFile(manifestPath, V22ManifestTemplate.class);
                } else if ("application/vnd.oci.image.manifest.v1+json".equals(mediaType)) {
                    manifestTemplate = JsonTemplateMapper.readJsonFromFile(manifestPath, OCIManifestTemplate.class);
                } else {
                    throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "Unknown manifest mediaType: " + mediaType);
                }
                Path configPath = imageDirectory.resolve("config.json");
                if (!Files.exists(configPath, new LinkOption[0])) {
                    throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "Manifest found, but missing container configuration");
                }
                ContainerConfigurationTemplate config = JsonTemplateMapper.readJsonFromFile(configPath, ContainerConfigurationTemplate.class);
                Optional<ManifestAndConfig> optional = Optional.of(new ManifestAndConfig(manifestTemplate, config));
                return optional;
            }
            try {
                throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "Unknown schemaVersion in manifest: " + schemaVersion + " - only 1 and 2 are supported");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    Optional<CachedLayer> retrieve(DescriptorDigest layerDigest) throws IOException, CacheCorruptedException {
        Path layerDirectory = this.cacheStorageFiles.getLayerDirectory(layerDigest);
        if (!Files.exists(layerDirectory, new LinkOption[0])) {
            return Optional.empty();
        }
        CachedLayer.Builder cachedLayerBuilder = CachedLayer.builder().setLayerDigest(layerDigest);
        try (Stream<Path> filesInLayerDirectory = Files.list(layerDirectory);){
            for (Path fileInLayerDirectory : filesInLayerDirectory.collect(Collectors.toList())) {
                if (!CacheStorageFiles.isLayerFile(fileInLayerDirectory)) continue;
                if (cachedLayerBuilder.hasLayerBlob()) {
                    throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "Multiple layer files found for layer with digest " + layerDigest.getHash() + " in directory: " + layerDirectory);
                }
                cachedLayerBuilder.setLayerBlob(Blobs.from(fileInLayerDirectory)).setLayerDiffId(this.cacheStorageFiles.getDiffId(fileInLayerDirectory)).setLayerSize(Files.size(fileInLayerDirectory));
            }
        }
        return Optional.of(cachedLayerBuilder.build());
    }

    Optional<DescriptorDigest> select(DescriptorDigest selector) throws CacheCorruptedException, IOException {
        Path selectorFile = this.cacheStorageFiles.getSelectorFile(selector);
        if (!Files.exists(selectorFile, new LinkOption[0])) {
            return Optional.empty();
        }
        String selectorFileContents = new String(Files.readAllBytes(selectorFile), StandardCharsets.UTF_8);
        try {
            return Optional.of(DescriptorDigest.fromHash(selectorFileContents));
        }
        catch (DigestException ex) {
            throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "Expected valid layer digest as contents of selector file `" + selectorFile + "` for selector `" + selector.getHash() + "`, but got: " + selectorFileContents);
        }
    }
}

