/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenHelpfulSuggestionsBuilder;
import com.google.cloud.tools.jib.maven.MavenJibLogger;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.PluginConfigurationProcessor;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsRunner;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="buildTar", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildTarMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "buildTar";
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Building image tarball failed";

    public void execute() throws MojoExecutionException {
        if (this.isSkipped()) {
            this.getLog().info((CharSequence)"Skipping containerization because jib-maven-plugin: skip = true");
            return;
        }
        if ("pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return;
        }
        MavenJibLogger mavenJibLogger = new MavenJibLogger(this.getLog());
        AbsoluteUnixPath appRoot = PluginConfigurationProcessor.getAppRootChecked(this);
        MavenProjectProperties mavenProjectProperties = MavenProjectProperties.getForProject(this.getProject(), this.getLog(), this.getExtraDirectory(), appRoot);
        try {
            MavenHelpfulSuggestionsBuilder mavenHelpfulSuggestionsBuilder = new MavenHelpfulSuggestionsBuilder(HELPFUL_SUGGESTIONS_PREFIX, this);
            ImageReference targetImage = ConfigurationPropertyValidator.getGeneratedTargetDockerTag(this.getTargetImage(), mavenJibLogger, this.getProject().getName(), this.getProject().getVersion(), mavenHelpfulSuggestionsBuilder.build());
            PluginConfigurationProcessor pluginConfigurationProcessor = PluginConfigurationProcessor.processCommonConfiguration(mavenJibLogger, this, mavenProjectProperties);
            BuildConfiguration buildConfiguration = pluginConfigurationProcessor.getBuildConfigurationBuilder().setBaseImageConfiguration(pluginConfigurationProcessor.getBaseImageConfigurationBuilder().build()).setTargetImageConfiguration(ImageConfiguration.builder(targetImage).build()).setContainerConfiguration(pluginConfigurationProcessor.getContainerConfigurationBuilder().build()).build();
            HelpfulSuggestions helpfulSuggestions = mavenHelpfulSuggestionsBuilder.setBaseImageReference(buildConfiguration.getBaseImageConfiguration().getImage()).setBaseImageHasConfiguredCredentials(pluginConfigurationProcessor.isBaseImageCredentialPresent()).setTargetImageReference(buildConfiguration.getTargetImageConfiguration().getImage()).build();
            BuildStepsRunner.forBuildTar(Paths.get(this.getProject().getBuild().getDirectory(), new String[0]).resolve("jib-image.tar"), buildConfiguration).build(helpfulSuggestions);
            this.getLog().info((CharSequence)"");
        }
        catch (CacheDirectoryCreationException | InvalidImageReferenceException | BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
    }
}

