/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class DockerClient {
    private final Function<List<String>, ProcessBuilder> processBuilderFactory;

    private static ProcessBuilder defaultProcessBuilder(List<String> dockerSubCommand) {
        ArrayList<String> dockerCommand = new ArrayList<String>(1 + dockerSubCommand.size());
        dockerCommand.add("docker");
        dockerCommand.addAll(dockerSubCommand);
        return new ProcessBuilder(dockerCommand);
    }

    public DockerClient() {
        this(DockerClient::defaultProcessBuilder);
    }

    @VisibleForTesting
    DockerClient(Function<List<String>, ProcessBuilder> processBuilderFactory) {
        this.processBuilderFactory = processBuilderFactory;
    }

    public boolean isDockerInstalled() {
        try {
            this.docker(new String[0]);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public String load(Blob imageTarballBlob) throws InterruptedException, IOException {
        Process dockerProcess = this.docker("load");
        try (OutputStream stdin = dockerProcess.getOutputStream();){
            try {
                imageTarballBlob.writeTo(stdin);
            }
            catch (IOException ex) {
                String error;
                try (InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);){
                    error = CharStreams.toString((Readable)stderr);
                }
                catch (IOException ignored) {
                    throw ex;
                }
                throw new IOException("'docker load' command failed with error: " + error, ex);
            }
        }
        var4_4 = null;
        try (InputStreamReader stdout = new InputStreamReader(dockerProcess.getInputStream(), StandardCharsets.UTF_8);){
            String output = CharStreams.toString((Readable)stdout);
            if (dockerProcess.waitFor() != 0) {
                throw new IOException("'docker load' command failed with output: " + output);
            }
            String string = output;
            return string;
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    public void tag(ImageReference originalImageReference, ImageReference newImageReference) throws IOException, InterruptedException {
        Process dockerProcess = this.docker("tag", originalImageReference.toString(), newImageReference.toString());
        if (dockerProcess.waitFor() != 0) {
            InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                try {
                    throw new IOException("'docker tag' command failed with error: " + CharStreams.toString((Readable)stderr));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                DockerClient.$closeResource(throwable, stderr);
                throw throwable3;
            }
        }
    }

    private Process docker(String ... subCommand) throws IOException {
        return this.processBuilderFactory.apply(Arrays.asList(subCommand)).start();
    }
}

