/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.GenericUrl;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.registry.RegistryEndpointProperties;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.net.MediaType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class BlobPusher {
    private final RegistryEndpointProperties registryEndpointProperties;
    private final DescriptorDigest blobDigest;
    private final Blob blob;

    BlobPusher(RegistryEndpointProperties registryEndpointProperties, DescriptorDigest blobDigest, Blob blob) {
        this.registryEndpointProperties = registryEndpointProperties;
        this.blobDigest = blobDigest;
        this.blob = blob;
    }

    RegistryEndpointProvider<String> initializer() {
        return new Initializer();
    }

    RegistryEndpointProvider<String> writer(URL location) {
        return new Writer(location);
    }

    RegistryEndpointProvider<Void> committer(URL location) {
        return new Committer(location);
    }

    private RegistryErrorException buildRegistryErrorException(String reason) {
        RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(this.getActionDescription());
        registryErrorExceptionBuilder.addReason(reason);
        return registryErrorExceptionBuilder.build();
    }

    private String getActionDescription() {
        return "push BLOB for " + this.registryEndpointProperties.getServerUrl() + "/" + this.registryEndpointProperties.getImageName() + " with digest " + this.blobDigest;
    }

    private String extractLocationHeader(Response response) throws RegistryErrorException {
        List<String> locationHeaders = response.getHeader("Location");
        if (locationHeaders.size() != 1) {
            throw this.buildRegistryErrorException("Expected 1 'Location' header, but found " + locationHeaders.size());
        }
        return locationHeaders.get(0);
    }

    private class Committer
    implements RegistryEndpointProvider<Void> {
        private final URL location;

        @Override
        @Nullable
        public BlobHttpContent getContent() {
            return null;
        }

        @Override
        public List<String> getAccept() {
            return Collections.emptyList();
        }

        @Override
        public Void handleResponse(Response response) {
            return null;
        }

        @Override
        public URL getApiRoute(String apiRouteBase) {
            return new GenericUrl(this.location).set("digest", (Object)BlobPusher.this.blobDigest).toURL();
        }

        @Override
        public String getHttpMethod() {
            return "PUT";
        }

        @Override
        public String getActionDescription() {
            return BlobPusher.this.getActionDescription();
        }

        private Committer(URL location) {
            this.location = location;
        }
    }

    private class Writer
    implements RegistryEndpointProvider<String> {
        private final URL location;

        @Override
        @Nullable
        public BlobHttpContent getContent() {
            return new BlobHttpContent(BlobPusher.this.blob, MediaType.OCTET_STREAM.toString());
        }

        @Override
        public List<String> getAccept() {
            return Collections.emptyList();
        }

        @Override
        public String handleResponse(Response response) throws RegistryException {
            return BlobPusher.this.extractLocationHeader(response);
        }

        @Override
        public URL getApiRoute(String apiRouteBase) {
            return this.location;
        }

        @Override
        public String getHttpMethod() {
            return "PATCH";
        }

        @Override
        public String getActionDescription() {
            return BlobPusher.this.getActionDescription();
        }

        private Writer(URL location) {
            this.location = location;
        }
    }

    private class Initializer
    implements RegistryEndpointProvider<String> {
        private Initializer() {
        }

        @Override
        @Nullable
        public BlobHttpContent getContent() {
            return null;
        }

        @Override
        public List<String> getAccept() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public String handleResponse(Response response) throws RegistryErrorException {
            switch (response.getStatusCode()) {
                case 201: {
                    return null;
                }
                case 202: {
                    return BlobPusher.this.extractLocationHeader(response);
                }
            }
            throw BlobPusher.this.buildRegistryErrorException("Received unrecognized status code " + response.getStatusCode());
        }

        @Override
        public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
            return new URL(apiRouteBase + BlobPusher.this.registryEndpointProperties.getImageName() + "/blobs/uploads/?mount=" + BlobPusher.this.blobDigest);
        }

        @Override
        public String getHttpMethod() {
            return "POST";
        }

        @Override
        public String getActionDescription() {
            return BlobPusher.this.getActionDescription();
        }
    }
}

