/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

class MavenSourceFilesConfiguration
implements SourceFilesConfiguration {
    private static final String DEPENDENCIES_PATH_ON_IMAGE = "/app/libs/";
    private static final String RESOURCES_PATH_ON_IMAGE = "/app/resources/";
    private static final String CLASSES_PATH_ON_IMAGE = "/app/classes/";
    private final ImmutableList<Path> dependenciesFiles;
    private final ImmutableList<Path> resourcesFiles;
    private final ImmutableList<Path> classesFiles;

    static MavenSourceFilesConfiguration getForProject(MavenProject project) throws IOException {
        return new MavenSourceFilesConfiguration(project);
    }

    private MavenSourceFilesConfiguration(MavenProject project) throws IOException {
        Path classesSourceDirectory = Paths.get(project.getBuild().getSourceDirectory(), new String[0]);
        Path classesOutputDirectory = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        ArrayList<Path> dependenciesFiles = new ArrayList<Path>();
        ArrayList resourcesFiles = new ArrayList();
        ArrayList classesFiles = new ArrayList();
        for (Artifact artifact : project.getArtifacts()) {
            dependenciesFiles.add(artifact.getFile().toPath());
        }
        try (Stream<Path> classFileStream = Files.list(classesOutputDirectory);){
            classFileStream.forEach(classFile -> {
                if (Files.isDirectory(classFile, new LinkOption[0]) && Files.exists(classesSourceDirectory.resolve(classesOutputDirectory.relativize((Path)classFile)), new LinkOption[0])) {
                    classesFiles.add(classFile);
                    return;
                }
                if (FileSystems.getDefault().getPathMatcher("glob:**.class").matches((Path)classFile)) {
                    classesFiles.add(classFile);
                    return;
                }
                resourcesFiles.add(classFile);
            });
        }
        this.dependenciesFiles = ImmutableList.sortedCopyOf(dependenciesFiles);
        this.resourcesFiles = ImmutableList.sortedCopyOf(resourcesFiles);
        this.classesFiles = ImmutableList.sortedCopyOf(classesFiles);
    }

    @Override
    public ImmutableList<Path> getDependenciesFiles() {
        return this.dependenciesFiles;
    }

    @Override
    public ImmutableList<Path> getResourcesFiles() {
        return this.resourcesFiles;
    }

    @Override
    public ImmutableList<Path> getClassesFiles() {
        return this.classesFiles;
    }

    @Override
    public String getDependenciesPathOnImage() {
        return DEPENDENCIES_PATH_ON_IMAGE;
    }

    @Override
    public String getResourcesPathOnImage() {
        return RESOURCES_PATH_ON_IMAGE;
    }

    @Override
    public String getClassesPathOnImage() {
        return CLASSES_PATH_ON_IMAGE;
    }
}

