/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.ListOfJsonTemplate;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class JsonTemplateMapper {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T extends JsonTemplate> T readJsonFromFile(Path jsonFile, Class<T> templateClass) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(Files.newInputStream(jsonFile, new OpenOption[0]), templateClass));
    }

    public static <T extends JsonTemplate> T readJson(String jsonString, Class<T> templateClass) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(jsonString, templateClass));
    }

    public static <T extends ListOfJsonTemplate> List<T> readListOfJson(String jsonString, Class<T> templateClass) throws IOException {
        return (List)objectMapper.readValue(jsonString, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, templateClass));
    }

    public static Blob toBlob(JsonTemplate template) {
        return JsonTemplateMapper.toBlob((Object)template);
    }

    public static Blob toBlob(ListOfJsonTemplate template) {
        return JsonTemplateMapper.toBlob(template.getList());
    }

    private static Blob toBlob(Object template) {
        return Blobs.from(outputStream -> objectMapper.writeValue(outputStream, template));
    }

    private JsonTemplateMapper() {
    }
}

