/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.builder.EntrypointBuilder;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

public class DockerContextGenerator {
    private final SourceFilesConfiguration sourceFilesConfiguration;
    @Nullable
    private String baseImage;
    private List<String> jvmFlags = Collections.emptyList();
    private String mainClass = "";
    private List<String> javaArguments = Collections.emptyList();

    public DockerContextGenerator(SourceFilesConfiguration sourceFilesConfiguration) {
        this.sourceFilesConfiguration = sourceFilesConfiguration;
    }

    public DockerContextGenerator setBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return this;
    }

    public DockerContextGenerator setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags = jvmFlags;
        return this;
    }

    public DockerContextGenerator setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public DockerContextGenerator setJavaArguments(List<String> javaArguments) {
        this.javaArguments = javaArguments;
        return this;
    }

    public void generate(Path targetDirectory) throws IOException {
        Preconditions.checkNotNull((Object)this.baseImage);
        try {
            Files.deleteIfExists(targetDirectory);
        }
        catch (DirectoryNotEmptyException ex) {
            MoreFiles.deleteDirectoryContents((Path)targetDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            Files.delete(targetDirectory);
        }
        Files.createDirectory(targetDirectory, new FileAttribute[0]);
        Path dependenciesDir = targetDirectory.resolve("libs");
        Path resourcesDIr = targetDirectory.resolve("resources");
        Path classesDir = targetDirectory.resolve("classes");
        Files.createDirectory(dependenciesDir, new FileAttribute[0]);
        Files.createDirectory(resourcesDIr, new FileAttribute[0]);
        Files.createDirectory(classesDir, new FileAttribute[0]);
        FileOperations.copy(this.sourceFilesConfiguration.getDependenciesFiles(), dependenciesDir);
        FileOperations.copy(this.sourceFilesConfiguration.getResourcesFiles(), resourcesDIr);
        FileOperations.copy(this.sourceFilesConfiguration.getClassesFiles(), classesDir);
        Files.write(targetDirectory.resolve("Dockerfile"), this.makeDockerfile().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @VisibleForTesting
    String makeDockerfile() throws IOException {
        Preconditions.checkNotNull((Object)this.baseImage);
        String dockerfileTemplate = Resources.toString((URL)Resources.getResource((String)"DockerfileTemplate"), (Charset)StandardCharsets.UTF_8);
        return dockerfileTemplate.replace("@@BASE_IMAGE@@", this.baseImage).replace("@@DEPENDENCIES_PATH_ON_IMAGE@@", this.sourceFilesConfiguration.getDependenciesPathOnImage()).replace("@@RESOURCES_PATH_ON_IMAGE@@", this.sourceFilesConfiguration.getResourcesPathOnImage()).replace("@@CLASSES_PATH_ON_IMAGE@@", this.sourceFilesConfiguration.getClassesPathOnImage()).replace("@@ENTRYPOINT@@", DockerContextGenerator.joinAsJsonArray(EntrypointBuilder.makeEntrypoint(this.sourceFilesConfiguration, this.jvmFlags, this.mainClass))).replace("@@CMD@@", DockerContextGenerator.joinAsJsonArray(this.javaArguments));
    }

    @VisibleForTesting
    static String joinAsJsonArray(List<String> items) {
        StringBuilder resultString = new StringBuilder("[");
        boolean firstComponent = true;
        for (String item : items) {
            if (!firstComponent) {
                resultString.append(',');
            }
            item = item.replaceAll("\"", Matcher.quoteReplacement("\\\""));
            resultString.append('\"').append(item).append('\"');
            firstComponent = false;
        }
        resultString.append(']');
        return resultString.toString();
    }
}

