/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.AsyncSteps;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePullStep;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildTarballAndLoadDockerStep;
import com.google.cloud.tools.jib.builder.steps.FinalizingStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushImageStep;
import com.google.cloud.tools.jib.builder.steps.PushLayersStep;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

public class StepsRunner {
    private final ListeningExecutorService listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private final BuildConfiguration buildConfiguration;
    private final SourceFilesConfiguration sourceFilesConfiguration;
    private final Cache baseLayersCache;
    private final Cache applicationLayersCache;
    @Nullable
    private RetrieveRegistryCredentialsStep retrieveBaseRegistryCredentialsStep;
    @Nullable
    private RetrieveRegistryCredentialsStep retrieveTargetRegistryCredentialsStep;
    @Nullable
    private AuthenticatePullStep authenticatePullStep;
    @Nullable
    private AuthenticatePushStep authenticatePushStep;
    @Nullable
    private PullBaseImageStep pullBaseImageStep;
    @Nullable
    private PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    @Nullable
    private ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    @Nullable
    private PushLayersStep pushBaseImageLayersStep;
    @Nullable
    private PushLayersStep pushApplicationLayersStep;
    @Nullable
    private BuildImageStep buildImageStep;
    @Nullable
    private PushContainerConfigurationStep pushContainerConfigurationStep;
    @Nullable
    private PushImageStep pushImageStep;
    @Nullable
    private BuildTarballAndLoadDockerStep buildTarballAndLoadDockerStep;

    public StepsRunner(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration, Cache baseLayersCache, Cache applicationLayersCache) {
        this.buildConfiguration = buildConfiguration;
        this.sourceFilesConfiguration = sourceFilesConfiguration;
        this.baseLayersCache = baseLayersCache;
        this.applicationLayersCache = applicationLayersCache;
    }

    public StepsRunner runRetrieveBaseRegistryCredentialsStep() {
        this.retrieveBaseRegistryCredentialsStep = RetrieveRegistryCredentialsStep.forBaseImage(this.listeningExecutorService, this.buildConfiguration);
        return this;
    }

    public StepsRunner runRetrieveTargetRegistryCredentialsStep() {
        this.retrieveTargetRegistryCredentialsStep = RetrieveRegistryCredentialsStep.forTargetImage(this.listeningExecutorService, this.buildConfiguration);
        return this;
    }

    public StepsRunner runAuthenticatePushStep() {
        this.authenticatePushStep = new AuthenticatePushStep(this.listeningExecutorService, this.buildConfiguration, (RetrieveRegistryCredentialsStep)Preconditions.checkNotNull((Object)this.retrieveTargetRegistryCredentialsStep));
        return this;
    }

    public StepsRunner runAuthenticatePullStep() {
        this.authenticatePullStep = new AuthenticatePullStep(this.listeningExecutorService, this.buildConfiguration, (RetrieveRegistryCredentialsStep)Preconditions.checkNotNull((Object)this.retrieveBaseRegistryCredentialsStep));
        return this;
    }

    public StepsRunner runPullBaseImageStep() {
        this.pullBaseImageStep = new PullBaseImageStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePullStep)Preconditions.checkNotNull((Object)this.authenticatePullStep));
        return this;
    }

    public StepsRunner runPullAndCacheBaseImageLayersStep() {
        this.pullAndCacheBaseImageLayersStep = new PullAndCacheBaseImageLayersStep(this.listeningExecutorService, this.buildConfiguration, this.baseLayersCache, (AuthenticatePullStep)Preconditions.checkNotNull((Object)this.authenticatePullStep), (PullBaseImageStep)Preconditions.checkNotNull((Object)this.pullBaseImageStep));
        return this;
    }

    public StepsRunner runPushBaseImageLayersStep() {
        this.pushBaseImageLayersStep = new PushLayersStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), (AsyncStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep));
        return this;
    }

    public StepsRunner runBuildAndCacheApplicationLayerSteps() {
        this.buildAndCacheApplicationLayerSteps = BuildAndCacheApplicationLayerStep.makeList(this.listeningExecutorService, this.buildConfiguration, this.sourceFilesConfiguration, this.applicationLayersCache);
        return this;
    }

    public StepsRunner runBuildImageStep(ImmutableList<String> entrypoint) {
        this.buildImageStep = new BuildImageStep(this.listeningExecutorService, this.buildConfiguration, (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)), entrypoint);
        return this;
    }

    public StepsRunner runPushContainerConfigurationStep() {
        this.pushContainerConfigurationStep = new PushContainerConfigurationStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public StepsRunner runPushApplicationLayersStep() {
        this.pushApplicationLayersStep = new PushLayersStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), AsyncSteps.immediate((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)));
        return this;
    }

    public StepsRunner runFinalizingPushStep() {
        new FinalizingStep(this.listeningExecutorService, this.buildConfiguration, Arrays.asList((AsyncStep)Preconditions.checkNotNull((Object)this.pushBaseImageLayersStep), (AsyncStep)Preconditions.checkNotNull((Object)this.pushApplicationLayersStep)), Collections.emptyList());
        return this;
    }

    public StepsRunner runFinalizingBuildStep() {
        new FinalizingStep(this.listeningExecutorService, this.buildConfiguration, Collections.singletonList((AsyncStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep)), (List)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps));
        return this;
    }

    public StepsRunner runPushImageStep() {
        this.pushImageStep = new PushImageStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), (PushLayersStep)Preconditions.checkNotNull((Object)this.pushBaseImageLayersStep), (PushLayersStep)Preconditions.checkNotNull((Object)this.pushApplicationLayersStep), (PushContainerConfigurationStep)Preconditions.checkNotNull((Object)this.pushContainerConfigurationStep), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public StepsRunner runBuildTarballAndLoadDockerStep() {
        this.buildTarballAndLoadDockerStep = new BuildTarballAndLoadDockerStep(this.listeningExecutorService, this.buildConfiguration, (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public void waitOnPushImageStep() throws ExecutionException, InterruptedException {
        ((PushImageStep)Preconditions.checkNotNull((Object)this.pushImageStep)).getFuture().get();
    }

    public void waitOnBuildTarballAndLoadDockerStep() throws ExecutionException, InterruptedException {
        ((BuildTarballAndLoadDockerStep)Preconditions.checkNotNull((Object)this.buildTarballAndLoadDockerStep)).getFuture().get();
    }
}

