/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write.context;

import com.google.cloud.spark.bigquery.write.context.IntermediateRecordWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;

public class AvroIntermediateRecordWriter
implements IntermediateRecordWriter {
    private final OutputStream outputStream;
    private final DatumWriter<GenericRecord> writer;
    private final DataFileWriter<GenericRecord> dataFileWriter;

    AvroIntermediateRecordWriter(Schema schema, OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        this.writer = new GenericDatumWriter(schema);
        this.dataFileWriter = new DataFileWriter(this.writer);
        this.dataFileWriter.create(schema, outputStream);
    }

    @Override
    public void write(GenericRecord record) throws IOException {
        this.dataFileWriter.append((Object)record);
    }

    @Override
    public void close() throws IOException {
        try {
            this.dataFileWriter.flush();
        }
        finally {
            this.dataFileWriter.close();
        }
    }
}

