/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.direct;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.ParameterMode;
import com.google.cloud.bigquery.connector.common.QueryParameterHelper;
import com.google.cloud.bigquery.connector.common.ReadSessionCreator;
import com.google.cloud.bigquery.connector.common.ReadSessionResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.direct.BigQueryPartition;
import com.google.cloud.spark.bigquery.direct.BigQueryRDDContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.util.Properties;

public class BigQueryRDDFactory {
    private static final Logger log = LoggerFactory.getLogger(BigQueryRDDFactory.class);
    private static final String QUERY_JOB_LABEL = "query_source";
    private static final String QUERY_PUSHDOWN_JOB_LABEL_VALUE = "spark_query_pushdown";
    private final BigQueryClient bigQueryClient;
    private final SparkBigQueryConfig options;
    private final BigQueryClientFactory bigQueryReadClientFactory;
    private final BigQueryTracerFactory bigQueryTracerFactory;
    private final SQLContext sqlContext;

    public BigQueryRDDFactory(BigQueryClient bigQueryClient, BigQueryClientFactory bigQueryReadClientFactory, BigQueryTracerFactory bigQueryTracerFactory, SparkBigQueryConfig options, SQLContext sqlContext) {
        this.bigQueryClient = bigQueryClient;
        this.options = options;
        this.bigQueryReadClientFactory = bigQueryReadClientFactory;
        this.bigQueryTracerFactory = bigQueryTracerFactory;
        this.sqlContext = sqlContext;
    }

    public RDD<InternalRow> buildScanFromSQL(String sql) {
        log.info("Materializing the following sql query to a BigQuery table: {}", (Object)sql);
        TableInfo actualTable = this.bigQueryClient.materializeQueryToTable(sql, this.options.getMaterializationExpirationTimeInMinutes(), (Map)ImmutableMap.builder().put((Object)QUERY_JOB_LABEL, (Object)QUERY_PUSHDOWN_JOB_LABEL_VALUE).build(), new QueryParameterHelper(ParameterMode.NONE, null, null));
        TableDefinition actualTableDefinition = actualTable.getDefinition();
        List<String> requiredColumns = actualTableDefinition.getSchema().getFields().stream().map(Field::getName).collect(Collectors.toList());
        log.info("Querying table {}, requiredColumns=[{}]", (Object)(actualTable.getTableId().getProject() + ":" + actualTable.getTableId().getDataset() + ":" + actualTable.getTableId().getTable()), (Object)requiredColumns.toString());
        ReadSessionCreator readSessionCreator = new ReadSessionCreator(this.options.toReadSessionCreatorConfig(), this.bigQueryClient, this.bigQueryReadClientFactory);
        return this.createRddFromTable(actualTable.getTableId(), readSessionCreator, requiredColumns.toArray(new String[0]), "");
    }

    public RDD<?> createRddFromTable(TableId tableId, ReadSessionCreator readSessionCreator, String[] requiredColumns, String filter) {
        ReadSessionResponse readSessionResponse = readSessionCreator.create(tableId, ImmutableList.copyOf((Object[])requiredColumns), BigQueryUtil.emptyIfNeeded((String)filter));
        ReadSession readSession = readSessionResponse.getReadSession();
        TableInfo actualTable = readSessionResponse.getReadTableInfo();
        List<BigQueryPartition> partitions = Streams.mapWithIndex(readSession.getStreamsList().stream(), (readStream, index) -> new BigQueryPartition(readStream.getName(), Math.toIntExact(index))).collect(Collectors.toList());
        log.info("Created read session for table '{}': {}", (Object)BigQueryUtil.friendlyTableName((TableId)tableId), (Object)readSession.getName());
        Set requiredColumnSet = Stream.of(requiredColumns).collect(Collectors.toSet());
        Schema prunedSchema = Schema.of((Iterable)SchemaConverters.from(SchemaConvertersConfiguration.from(this.options)).getSchemaWithPseudoColumns(actualTable).getFields().stream().filter(f -> requiredColumnSet.contains(f.getName())).collect(Collectors.toList()));
        return this.createRDD(this.sqlContext, partitions.toArray(new BigQueryPartition[0]), readSession, prunedSchema, requiredColumns, this.options, this.bigQueryReadClientFactory, this.bigQueryTracerFactory);
    }

    @VisibleForTesting
    RDD<InternalRow> createRDD(SQLContext sqlContext, Partition[] partitions, ReadSession readSession, Schema bqSchema, String[] columnsInOrder, SparkBigQueryConfig options, BigQueryClientFactory bigQueryClientFactory, BigQueryTracerFactory bigQueryTracerFactory) {
        String bigQueryRDDClassName = "com.google.cloud.spark.bigquery.direct.Scala213BigQueryRDD";
        String scalaVersion = Properties.versionNumberString();
        if (scalaVersion.compareTo("2.13") < 0) {
            bigQueryRDDClassName = "com.google.cloud.spark.bigquery.direct.PreScala213BigQueryRDD";
        }
        try {
            Class<?> clazz = Class.forName(bigQueryRDDClassName);
            Constructor<?> constructor = clazz.getConstructor(SparkContext.class, BigQueryRDDContext.class);
            RDD bigQueryRDD = (RDD)constructor.newInstance(sqlContext.sparkContext(), new BigQueryRDDContext(partitions, readSession, bqSchema, columnsInOrder, options, bigQueryClientFactory, bigQueryTracerFactory));
            return bigQueryRDD;
        }
        catch (Exception e) {
            throw new BigQueryConnectorException(String.format("Could not initialize a BigQuery RDD class of type [%s}", bigQueryRDDClassName), (Throwable)e);
        }
    }

    public long getNumBytes(TableDefinition tableDefinition) {
        TableDefinition.Type tableType = tableDefinition.getType();
        if (TableDefinition.Type.EXTERNAL == tableType || this.options.isViewsEnabled() && (TableDefinition.Type.VIEW == tableType || TableDefinition.Type.MATERIALIZED_VIEW == tableType)) {
            return this.sqlContext.sparkSession().sessionState().conf().defaultSizeInBytes();
        }
        StandardTableDefinition standardTableDefinition = (StandardTableDefinition)tableDefinition;
        return standardTableDefinition.getNumBytes();
    }
}

