/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.SupportedCustomDataType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;

public class SchemaConverters {
    static final DecimalType NUMERIC_SPARK_TYPE = DataTypes.createDecimalType((int)38, (int)9);
    static final int MAX_BIGQUERY_NESTED_DEPTH = 15;
    private static final int NUMERIC_MAX_LEFT_OF_DOT_DIGITS = 29;
    private final SchemaConvertersConfiguration configuration;

    private SchemaConverters(SchemaConvertersConfiguration configuration) {
        this.configuration = configuration;
    }

    public static SchemaConverters from(SchemaConvertersConfiguration configuration) {
        return new SchemaConverters(configuration);
    }

    public StructType toSpark(Schema schema) {
        List<StructField> fieldList = schema.getFields().stream().map(this::convert).collect(Collectors.toList());
        StructType structType = new StructType(fieldList.toArray(new StructField[0]));
        return structType;
    }

    public Schema getSchemaWithPseudoColumns(TableInfo tableInfo) {
        TimePartitioning timePartitioning = null;
        TableDefinition tableDefinition = tableInfo.getDefinition();
        if (tableDefinition instanceof StandardTableDefinition) {
            timePartitioning = ((StandardTableDefinition)tableDefinition).getTimePartitioning();
        }
        boolean tableSupportsPseudoColumns = timePartitioning != null && timePartitioning.getField() == null && timePartitioning.getType() != null;
        Schema schema = tableDefinition.getSchema();
        if (tableSupportsPseudoColumns) {
            ArrayList<Field> fields = new ArrayList<Field>((Collection<Field>)schema.getFields());
            fields.add(this.createBigQueryFieldBuilder("_PARTITIONTIME", LegacySQLTypeName.TIMESTAMP, Field.Mode.NULLABLE, null).build());
            if (timePartitioning.getType().equals((Object)TimePartitioning.Type.DAY)) {
                fields.add(this.createBigQueryFieldBuilder("_PARTITIONDATE", LegacySQLTypeName.DATE, Field.Mode.NULLABLE, null).build());
            }
            schema = Schema.of(fields);
        }
        return schema;
    }

    public InternalRow convertToInternalRow(Schema schema, List<String> namesInOrder, GenericRecord record, Optional<StructType> userProvidedSchema) {
        List<StructField> userProvidedFieldList = Arrays.stream(userProvidedSchema.orElse(new StructType()).fields()).collect(Collectors.toList());
        return this.convertAll(schema.getFields(), record, namesInOrder, userProvidedFieldList);
    }

    Object convert(Field field, Object value, StructField userProvidedField) {
        if (value == null) {
            return null;
        }
        if (field.getMode() == Field.Mode.REPEATED) {
            LegacySQLTypeName fType = LegacySQLTypeName.valueOfStrict((String)field.getType().name());
            Field nestedField = Field.newBuilder((String)field.getName(), (LegacySQLTypeName)fType, (FieldList)field.getSubFields()).setMode(Field.Mode.REQUIRED).build();
            List valueList = (List)value;
            return new GenericArrayData(valueList.stream().map(v -> this.convert(nestedField, v, this.getStructFieldForRepeatedMode(userProvidedField))).collect(Collectors.toList()));
        }
        return this.convertByBigQueryType(field, value, userProvidedField);
    }

    private StructField getStructFieldForRepeatedMode(StructField field) {
        StructField nestedField = null;
        if (field != null) {
            ArrayType arrayType = (ArrayType)field.dataType();
            nestedField = new StructField(field.name(), arrayType.elementType(), arrayType.containsNull(), Metadata.empty());
        }
        return nestedField;
    }

    Object convertByBigQueryType(Field bqField, Object value, StructField userProvidedField) {
        if (LegacySQLTypeName.INTEGER.equals((Object)bqField.getType())) {
            if (userProvidedField != null) {
                DataType userProvidedType = userProvidedField.dataType();
                if (userProvidedType.equals(DataTypes.IntegerType)) {
                    return ((Number)value).intValue();
                }
                if (userProvidedType.equals(DataTypes.ShortType)) {
                    return ((Number)value).shortValue();
                }
                if (userProvidedType.equals(DataTypes.ByteType)) {
                    return ((Number)value).byteValue();
                }
            }
            return value;
        }
        if (LegacySQLTypeName.FLOAT.equals((Object)bqField.getType()) || LegacySQLTypeName.BOOLEAN.equals((Object)bqField.getType()) || LegacySQLTypeName.DATE.equals((Object)bqField.getType()) || LegacySQLTypeName.TIME.equals((Object)bqField.getType()) || LegacySQLTypeName.TIMESTAMP.equals((Object)bqField.getType())) {
            return value;
        }
        if (LegacySQLTypeName.STRING.equals((Object)bqField.getType()) || LegacySQLTypeName.DATETIME.equals((Object)bqField.getType()) || LegacySQLTypeName.GEOGRAPHY.equals((Object)bqField.getType()) || LegacySQLTypeName.JSON.equals((Object)bqField.getType())) {
            return UTF8String.fromBytes((byte[])((Utf8)value).getBytes());
        }
        if (LegacySQLTypeName.BYTES.equals((Object)bqField.getType())) {
            return this.getBytes((ByteBuffer)value);
        }
        if (LegacySQLTypeName.NUMERIC.equals((Object)bqField.getType()) || LegacySQLTypeName.BIGNUMERIC.equals((Object)bqField.getType())) {
            byte[] bytes = this.getBytes((ByteBuffer)value);
            int scale = Optional.ofNullable(bqField.getScale()).map(Long::intValue).orElse(9);
            BigDecimal b = new BigDecimal(new BigInteger(bytes), scale);
            int precision = Optional.ofNullable(bqField.getPrecision()).map(Long::intValue).orElse(38);
            Decimal d = Decimal.apply((BigDecimal)b, (int)precision, (int)scale);
            return d;
        }
        if (LegacySQLTypeName.RECORD.equals((Object)bqField.getType())) {
            List<String> namesInOrder = null;
            List<StructField> structList = null;
            if (userProvidedField != null) {
                StructType userStructType = (StructType)SupportedCustomDataType.toSqlType(userProvidedField.dataType());
                structList = Arrays.stream(userStructType.fields()).collect(Collectors.toList());
                namesInOrder = structList.stream().map(StructField::name).collect(Collectors.toList());
            } else {
                namesInOrder = bqField.getSubFields().stream().map(Field::getName).collect(Collectors.toList());
            }
            return this.convertAll(bqField.getSubFields(), (GenericRecord)value, namesInOrder, structList);
        }
        throw new IllegalStateException("Unexpected type: " + bqField.getType());
    }

    private byte[] getBytes(ByteBuffer buf) {
        byte[] bytes = new byte[buf.remaining()];
        buf.get(bytes);
        return bytes;
    }

    GenericInternalRow convertAll(FieldList fieldList, GenericRecord record, List<String> namesInOrder, List<StructField> userProvidedFieldList) {
        HashMap fieldMap = new HashMap();
        HashMap userProvidedFieldMap = userProvidedFieldList == null ? new HashMap() : userProvidedFieldList.stream().collect(Collectors.toMap(StructField::name, Function.identity()));
        fieldList.stream().forEach(field -> fieldMap.put(field.getName(), this.convert((Field)field, record.get(field.getName()), (StructField)userProvidedFieldMap.get(field.getName()))));
        Object[] values = new Object[namesInOrder.size()];
        for (int i = 0; i < namesInOrder.size(); ++i) {
            values[i] = fieldMap.get(namesInOrder.get(i));
        }
        return new GenericInternalRow(values);
    }

    @VisibleForTesting
    StructField convert(Field field) {
        DataType dataType = this.getDataType(field);
        boolean nullable = true;
        if (field.getMode() == Field.Mode.REQUIRED) {
            nullable = false;
        } else if (field.getMode() == Field.Mode.REPEATED) {
            dataType = new ArrayType(dataType, true);
        }
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        if (field.getDescription() != null) {
            metadataBuilder.putString("description", field.getDescription());
            metadataBuilder.putString("comment", field.getDescription());
        }
        if (LegacySQLTypeName.JSON.equals((Object)field.getType())) {
            metadataBuilder.putString("sqlType", "JSON");
        }
        Metadata metadata = metadataBuilder.build();
        return this.convertMap(field, metadata).orElse(new StructField(field.getName(), dataType, nullable, metadata));
    }

    Optional<StructField> convertMap(Field field, Metadata metadata) {
        if (!this.configuration.getAllowMapTypeConversion()) {
            return Optional.empty();
        }
        if (field.getMode() != Field.Mode.REPEATED) {
            return Optional.empty();
        }
        if (field.getType() != LegacySQLTypeName.RECORD) {
            return Optional.empty();
        }
        FieldList subFields = field.getSubFields();
        if (subFields.size() != 2) {
            return Optional.empty();
        }
        Set subFieldNames = subFields.stream().map(Field::getName).collect(Collectors.toSet());
        if (!subFieldNames.contains("key") || !subFieldNames.contains("value")) {
            return Optional.empty();
        }
        Field key = subFields.get("key");
        Field value = subFields.get("value");
        MapType mapType = DataTypes.createMapType((DataType)this.convert(key).dataType(), (DataType)this.convert(value).dataType());
        return Optional.of(new StructField(field.getName(), (DataType)mapType, false, metadata));
    }

    private DataType getDataType(Field field) {
        return this.getCustomDataType(field).map(udt -> udt).orElseGet(() -> this.getStandardDataType(field));
    }

    @VisibleForTesting
    Optional<UserDefinedType> getCustomDataType(Field field) {
        String description = field.getDescription();
        if (description != null && LegacySQLTypeName.RECORD.equals((Object)field.getType())) {
            return SupportedCustomDataType.forDescription(description).map(SupportedCustomDataType::getSparkDataType);
        }
        return Optional.empty();
    }

    private DataType getStandardDataType(Field field) {
        Optional<DataType> sparkType = SparkBigQueryUtil.getTypeConverterStream().filter(tc -> tc.supportsBigQueryType(field.getType())).map(tc -> tc.toSparkType(field.getType())).findFirst();
        if (sparkType.isPresent()) {
            return sparkType.get();
        }
        if (LegacySQLTypeName.INTEGER.equals((Object)field.getType())) {
            return DataTypes.LongType;
        }
        if (LegacySQLTypeName.FLOAT.equals((Object)field.getType())) {
            return DataTypes.DoubleType;
        }
        if (LegacySQLTypeName.NUMERIC.equals((Object)field.getType())) {
            return SchemaConverters.createDecimalTypeFromNumericField(field, LegacySQLTypeName.NUMERIC, 38, 9);
        }
        if (LegacySQLTypeName.BIGNUMERIC.equals((Object)field.getType())) {
            int precision = Optional.ofNullable(field.getPrecision()).map(Long::intValue).orElse(this.configuration.getBigNumericDefaultPrecision());
            if (precision > DecimalType.MAX_PRECISION()) {
                throw new IllegalArgumentException(String.format("BigNumeric precision is too wide (%d), Spark can only handle decimal types with max precision of %d, If your data is within Spark's precision, you can set it using bigNumericDefaultPrecision", precision, DecimalType.MAX_PRECISION()));
            }
            int scale = Optional.ofNullable(field.getScale()).map(Long::intValue).orElse(this.configuration.getBigNumericDefaultScale());
            if (scale > DecimalType.MAX_SCALE()) {
                throw new IllegalArgumentException(String.format("BigNumeric scale is too wide (%d), Spark can only handle decimal types with max scale of %d, If your data is within Spark's scale, you can set it using bigNumericDefaultScale", scale, DecimalType.MAX_SCALE()));
            }
            return SchemaConverters.createDecimalTypeFromNumericField(field, LegacySQLTypeName.BIGNUMERIC, this.configuration.getBigNumericDefaultPrecision(), this.configuration.getBigNumericDefaultScale());
        }
        if (LegacySQLTypeName.STRING.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        if (LegacySQLTypeName.BOOLEAN.equals((Object)field.getType())) {
            return DataTypes.BooleanType;
        }
        if (LegacySQLTypeName.BYTES.equals((Object)field.getType())) {
            return DataTypes.BinaryType;
        }
        if (LegacySQLTypeName.DATE.equals((Object)field.getType())) {
            return DataTypes.DateType;
        }
        if (LegacySQLTypeName.TIMESTAMP.equals((Object)field.getType())) {
            return DataTypes.TimestampType;
        }
        if (LegacySQLTypeName.TIME.equals((Object)field.getType())) {
            return DataTypes.LongType;
        }
        if (LegacySQLTypeName.DATETIME.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        if (LegacySQLTypeName.RECORD.equals((Object)field.getType())) {
            List<StructField> structFields = field.getSubFields().stream().map(this::convert).collect(Collectors.toList());
            return new StructType(structFields.toArray(new StructField[0]));
        }
        if (LegacySQLTypeName.GEOGRAPHY.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        if (LegacySQLTypeName.JSON.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        throw new IllegalStateException("Unexpected type: " + field.getType());
    }

    @VisibleForTesting
    static DecimalType createDecimalTypeFromNumericField(Field field, LegacySQLTypeName expectedType, int defaultPrecision, int defaultScale) {
        Preconditions.checkArgument((boolean)field.getType().equals((Object)expectedType), (String)"Field %s must be of type NUMERIC, instead it is of type %s", (Object)field.getName(), (Object)field.getType());
        Optional<Integer> precisionOpt = Optional.ofNullable(field.getPrecision()).map(Long::intValue);
        Optional<Integer> scaleOpt = Optional.ofNullable(field.getScale()).map(Long::intValue);
        if (precisionOpt.isPresent() && scaleOpt.isPresent()) {
            return DataTypes.createDecimalType((int)precisionOpt.get(), (int)scaleOpt.get());
        }
        if (!precisionOpt.isPresent() && !scaleOpt.isPresent()) {
            return DataTypes.createDecimalType((int)defaultPrecision, (int)defaultScale);
        }
        int maxLeftOfDotDigits = defaultPrecision - defaultScale;
        if (precisionOpt.isPresent()) {
            Integer precision = (int)precisionOpt.get();
            return DataTypes.createDecimalType((int)precision, (int)Math.max(0, precision - maxLeftOfDotDigits));
        }
        Integer scale = scaleOpt.get();
        return DataTypes.createDecimalType((int)(scale + maxLeftOfDotDigits), (int)scale);
    }

    public Schema toBigQuerySchema(StructType sparkSchema) {
        FieldList bigQueryFields = this.sparkToBigQueryFields(sparkSchema, 0);
        return Schema.of((Iterable)bigQueryFields);
    }

    private FieldList sparkToBigQueryFields(StructType sparkStruct, int depth) {
        Preconditions.checkArgument((depth < 15 ? 1 : 0) != 0, (Object)"Spark Schema exceeds BigQuery maximum nesting depth.");
        ArrayList<Field> bqFields = new ArrayList<Field>();
        for (StructField field : sparkStruct.fields()) {
            bqFields.add(this.createBigQueryColumn(field, depth));
        }
        return FieldList.of(bqFields);
    }

    @VisibleForTesting
    protected Field createBigQueryColumn(StructField sparkField, int depth) {
        LegacySQLTypeName fieldType;
        Optional<SupportedCustomDataType> supportedCustomDataTypeOptional;
        DataType sparkType = sparkField.dataType();
        String fieldName = sparkField.name();
        Field.Mode fieldMode = sparkField.nullable() ? Field.Mode.NULLABLE : Field.Mode.REQUIRED;
        FieldList subFields = null;
        OptionalLong scale = OptionalLong.empty();
        long precision = 0L;
        if (sparkType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)sparkType;
            fieldMode = Field.Mode.REPEATED;
            sparkType = arrayType.elementType();
        }
        if ((supportedCustomDataTypeOptional = SupportedCustomDataType.of(sparkType)).isPresent()) {
            SupportedCustomDataType supportedCustomDataType = supportedCustomDataTypeOptional.get();
            sparkType = supportedCustomDataType.getSqlType();
        }
        if (sparkType instanceof StructType) {
            subFields = this.sparkToBigQueryFields((StructType)sparkType, depth + 1);
            fieldType = LegacySQLTypeName.RECORD;
        } else if (sparkType instanceof MapType) {
            MapType mapType = (MapType)sparkType;
            fieldMode = Field.Mode.REPEATED;
            fieldType = LegacySQLTypeName.RECORD;
            subFields = FieldList.of((Field[])new Field[]{this.buildMapTypeField("key", mapType.keyType(), sparkField.metadata(), Field.Mode.REQUIRED, depth), this.buildMapTypeField("value", mapType.valueType(), sparkField.metadata(), mapType.valueContainsNull() ? Field.Mode.NULLABLE : Field.Mode.REQUIRED, depth)});
        } else if (sparkType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)sparkType;
            int leftOfDotDigits = decimalType.precision() - decimalType.scale();
            fieldType = decimalType.scale() > 9 || leftOfDotDigits > 29 ? LegacySQLTypeName.BIGNUMERIC : LegacySQLTypeName.NUMERIC;
            scale = OptionalLong.of(decimalType.scale());
            precision = decimalType.precision();
        } else {
            fieldType = this.toBigQueryType(sparkType, sparkField.metadata());
        }
        Field.Builder fieldBuilder = this.createBigQueryFieldBuilder(fieldName, fieldType, fieldMode, subFields);
        Optional<String> description = SchemaConverters.getDescriptionOrCommentOfField(sparkField, supportedCustomDataTypeOptional);
        if (description.isPresent()) {
            fieldBuilder.setDescription(description.get());
        }
        if (scale.isPresent()) {
            fieldBuilder.setPrecision(Long.valueOf(precision));
            fieldBuilder.setScale(Long.valueOf(scale.getAsLong()));
        }
        return fieldBuilder.build();
    }

    public static Optional<String> getDescriptionOrCommentOfField(StructField field, Optional<SupportedCustomDataType> supportedCustomDataTypeOptional) {
        Optional<Object> description = Optional.empty();
        if (!field.getComment().isEmpty()) {
            description = Optional.of(field.getComment().get());
        } else if (field.metadata().contains("description") && field.metadata().getString("description") != null) {
            description = Optional.of(field.metadata().getString("description"));
        }
        Optional<String> marker = supportedCustomDataTypeOptional.map(SupportedCustomDataType::getTypeMarker);
        if (description.isPresent()) {
            String descriptionString = (String)description.get();
            return Optional.of(marker.map(value -> descriptionString + " " + value).orElse(descriptionString));
        }
        return marker;
    }

    private Field buildMapTypeField(String fieldName, DataType sparkType, Metadata metadata, Field.Mode fieldMode, int depth) {
        LegacySQLTypeName sqlType = this.toBigQueryType(sparkType, metadata);
        if (sqlType == LegacySQLTypeName.RECORD) {
            FieldList subFields = this.sparkToBigQueryFields((StructType)sparkType, depth + 1);
            return this.createBigQueryFieldBuilder(fieldName, sqlType, fieldMode, subFields).build();
        }
        return this.createBigQueryFieldBuilder(fieldName, sqlType, fieldMode, null).build();
    }

    @VisibleForTesting
    protected LegacySQLTypeName toBigQueryType(DataType elementType, Metadata metadata) {
        Optional<LegacySQLTypeName> bigQueryType = SparkBigQueryUtil.getTypeConverterStream().filter(tc -> tc.supportsSparkType(elementType)).map(tc -> tc.toBigQueryType(elementType)).findFirst();
        if (bigQueryType.isPresent()) {
            return bigQueryType.get();
        }
        if (elementType instanceof BinaryType) {
            return LegacySQLTypeName.BYTES;
        }
        if (elementType instanceof ByteType || elementType instanceof ShortType || elementType instanceof IntegerType || elementType instanceof LongType) {
            return LegacySQLTypeName.INTEGER;
        }
        if (elementType instanceof BooleanType) {
            return LegacySQLTypeName.BOOLEAN;
        }
        if (elementType instanceof FloatType || elementType instanceof DoubleType) {
            return LegacySQLTypeName.FLOAT;
        }
        if (elementType instanceof StringType) {
            if (SparkBigQueryUtil.isJson(metadata)) {
                return LegacySQLTypeName.JSON;
            }
            return LegacySQLTypeName.STRING;
        }
        if (elementType instanceof TimestampType) {
            return LegacySQLTypeName.TIMESTAMP;
        }
        if (elementType instanceof DateType) {
            return LegacySQLTypeName.DATE;
        }
        if (elementType instanceof StructType) {
            return LegacySQLTypeName.RECORD;
        }
        throw new IllegalArgumentException("Data type not expected: " + elementType.simpleString());
    }

    private Field.Builder createBigQueryFieldBuilder(String name, LegacySQLTypeName type, Field.Mode mode, FieldList subFields) {
        return Field.newBuilder((String)name, (LegacySQLTypeName)type, (FieldList)subFields).setMode(mode);
    }
}

