/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryClientModule;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.SparkBigQueryConnectorModule;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

public class InjectorFactory {
    private InjectorFactory() {
    }

    public static Injector createInjector(StructType schema, Map<String, String> options, boolean tableIsMandatory) {
        SparkSession spark = SparkSession.active();
        return InjectorFactory.createInjector(spark, schema, options, tableIsMandatory);
    }

    public static Injector createInjector(SparkSession spark, StructType schema, Map<String, String> options, boolean tableIsMandatory) {
        ImmutableMap customDefaults = ImmutableMap.of();
        return Guice.createInjector((Module[])new Module[]{new BigQueryClientModule(), new SparkBigQueryConnectorModule(spark, options, (Map<String, String>)customDefaults, Optional.ofNullable(schema), DataSourceVersion.V2, tableIsMandatory, Optional.empty())});
    }
}

