/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.spark.bigquery.TypeConverter;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.CivilTimeEncoder;
import com.google.cloud.spark.bigquery.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.cloud.spark.bigquery.repackaged.org.threeten.bp.LocalDateTime;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

public class TimestampNTZTypeConverter
implements TypeConverter<Long> {
    @Override
    public DataType toSparkType(LegacySQLTypeName bigQueryType) {
        if (this.supportsBigQueryType(bigQueryType)) {
            return DataTypes.TimestampNTZType;
        }
        throw new IllegalArgumentException("Data type not supported : " + bigQueryType);
    }

    @Override
    public LegacySQLTypeName toBigQueryType(DataType sparkType) {
        if (this.supportsSparkType(sparkType)) {
            return LegacySQLTypeName.DATETIME;
        }
        throw new IllegalArgumentException("Data type not supported : " + sparkType);
    }

    @Override
    public DescriptorProtos.FieldDescriptorProto.Type toProtoFieldType(DataType sparkType) {
        if (this.supportsSparkType(sparkType)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
        }
        throw new IllegalArgumentException("Data type not supported : " + sparkType);
    }

    @Override
    public boolean supportsBigQueryType(LegacySQLTypeName bigQueryType) {
        return bigQueryType.getStandardType().equals((Object)StandardSQLTypeName.DATETIME);
    }

    @Override
    public boolean supportsSparkType(DataType sparkType) {
        return sparkType.sameType(DataTypes.TimestampNTZType);
    }

    @Override
    public Long sparkToProtoValue(Object sparkValue) {
        java.time.LocalDateTime javaLocalTime = (java.time.LocalDateTime)sparkValue;
        LocalDateTime threeTenLocalTime = LocalDateTime.of(javaLocalTime.getYear(), javaLocalTime.getMonthValue(), javaLocalTime.getDayOfMonth(), javaLocalTime.getHour(), javaLocalTime.getMinute(), javaLocalTime.getSecond(), javaLocalTime.getNano());
        return CivilTimeEncoder.encodePacked64DatetimeMicros(threeTenLocalTime);
    }
}

