/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.namespace.resolver;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.namespace.resolver.DatasetNamespaceResolver;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.namespace.resolver.HostListNamespaceResolverConfig;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.lang3.StringUtils;

public class HostListNamespaceResolver
implements DatasetNamespaceResolver {
    private final String resolvedName;
    private final HostListNamespaceResolverConfig config;

    public HostListNamespaceResolver(String resolvedName, HostListNamespaceResolverConfig config) {
        this.resolvedName = resolvedName;
        this.config = config;
    }

    @Override
    public String resolve(String namespace) {
        if (this.config.getHosts() == null) {
            return namespace;
        }
        if (StringUtils.isNotEmpty(this.config.getSchema()) && !namespace.startsWith(this.config.getSchema() + "://")) {
            return namespace;
        }
        return this.config.getHosts().stream().filter(h2 -> StringUtils.containsIgnoreCase(namespace, h2)).findAny().map(h2 -> StringUtils.replaceIgnoreCase(namespace, h2, this.resolvedName)).orElseGet(() -> namespace);
    }
}

